/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.util;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.android.deployers.AndroidFileUtils;
import oracle.adfmf.framework.dt.deploy.editor.options.ImageOptions;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.DeployException;

public class AndroidImageUtil {
    private static final String DEFAULT_RESOURCE_RELATIVE_PATH = "resources/android/";
    private static final String APPLICATION_ICON_NAME = "adfmf_icon.png";
    private static final String APPLICATION_SPLASHSCREEN_NAME = "adfmf_loading.png";
    private static final String DISPLAY_LDPI_ICON_PNG = "display-ldpi-icon.png";
    private static final String DISPLAY_MDPI_ICON_PNG = "display-mdpi-icon.png";
    private static final String DISPLAY_HDPI_ICON_PNG = "display-hdpi-icon.png";
    private static final String DISPLAY_XHDPI_ICON_PNG = "display-xhdpi-icon.png";
    private static final String DISPLAY_LAND_LDPI_SPLASHSCREENT_PNG = "display-land-ldpi-splashscreen.png";
    private static final String DISPLAY_LAND_MDPI_SPLASHSCREENT_PNG = "display-land-mdpi-splashscreen.png";
    private static final String DISPLAY_LAND_HDPI_SPLASHSCREENT_PNG = "display-land-hdpi-splashscreen.png";
    private static final String DISPLAY_LAND_XHDPI_SPLASHSCREENT_PNG = "display-land-xhdpi-splashscreen.png";
    private static final String DISPLAY_PORT_LDIP_SPLASCREEN_PNG = "display-port-ldpi-splashscreen.png";
    private static final String DISPLAY_PORT_MDIP_SPLASCREEN_PNG = "display-port-mdpi-splashscreen.png";
    private static final String DISPLAY_PORT_HDIP_SPLASCREEN_PNG = "display-port-hdpi-splashscreen.png";
    private static final String DISPLAY_PORT_XHDIP_SPLASCREEN_PNG = "display-port-xhdpi-splashscreen.png";
    private static final String DRAWABLE_LDPI_DIR_NAME = "drawable-ldpi";
    private static final String DRAWABLE_MDPI_DIR_NAME = "drawable-mdpi";
    private static final String DRAWABLE_HDPI_DIR_NAME = "drawable-hdpi";
    private static final String DRAWABLE_XHDPI_DIR_NAME = "drawable-xhdpi";
    private static final String DRAWABLE_LAND_LDPI_DIR_NAME = "drawable-land-ldpi";
    private static final String DRAWABLE_LAND_MDPI_DIR_NAME = "drawable-land-mdpi";
    private static final String DRAWABLE_LAND_HDPI_DIR_NAME = "drawable-land-hdpi";
    private static final String DRAWABLE_LAND_XHDPI_DIR_NAME = "drawable-land-xhdpi";
    private static final String DRAWABLE_PORT_LDPI_DIR_NAME = "drawable-port-ldpi";
    private static final String DRAWABLE_PORT_MDPI_DIR_NAME = "drawable-port-mdpi";
    private static final String DRAWABLE_PORT_HDPI_DIR_NAME = "drawable-port-hdpi";
    private static final String DRAWABLE_PORT_XHDPI_DIR_NAME = "drawable-port-xhdpi";

    public static void copyApplicationImages(ImageOptions imageOptions, AndroidFileUtils af, Logger logger) throws DeployException {
        try {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-21502"));
            URL applicationResourceOutputUrl = af.getApplicationResourceOutputURL();
            URL defaultResourcesRootFolderUrl = af.getApplicationDefaultResourceFolderURL();
            Map<ImageToDeviceInformation, DestinationImageFolderSet> imageInfoToDestinationFolderSetMap = ImageToDeviceInformation.getImageFolderToDestinationFolderMap();
            Map<ImageToDeviceInformation, DefaultImageNameSet> imageInfoToDefaultImageSetMap = ImageToDeviceInformation.getImageInfoToDefaultImageMap();
            for (Map.Entry<ImageToDeviceInformation, DestinationImageFolderSet> currEntry : imageInfoToDestinationFolderSetMap.entrySet()) {
                ImageToDeviceInformation currImageToDevice = currEntry.getKey();
                DestinationImageFolderSet currDestinationFolderSet = currEntry.getValue();
                DefaultImageNameSet currDefaultImageNameSet = imageInfoToDefaultImageSetMap.get((Object)currImageToDevice);
                HashStructure imageOptionsHash = DeployFileUtils.getDeviceTypeHash(imageOptions, currImageToDevice.getImageOptionsKey());
                URL appIconFolderUrl = URLFactory.newDirURL((URL)applicationResourceOutputUrl, (String)currDestinationFolderSet.getAppImageFolderName());
                String configuredIconPath = AndroidImageUtil._getConfiguredImagePathFromHash(af.getWorkspace(), "appIconPath", imageOptionsHash);
                DeployFileUtils.copyImage(appIconFolderUrl, defaultResourcesRootFolderUrl, configuredIconPath, currDefaultImageNameSet.getAppImageName(), APPLICATION_ICON_NAME);
                URL appPortraitSplashFolderUrl = URLFactory.newDirURL((URL)applicationResourceOutputUrl, (String)currDestinationFolderSet.getPortraitSplashFolderName());
                String configuredPortraitSplashPath = AndroidImageUtil._getConfiguredImagePathFromHash(af.getWorkspace(), "portraitSplashScreenPath", imageOptionsHash);
                DeployFileUtils.copyImage(appPortraitSplashFolderUrl, defaultResourcesRootFolderUrl, configuredPortraitSplashPath, currDefaultImageNameSet.getPortraitSplashName(), APPLICATION_SPLASHSCREEN_NAME);
                URL appLandscapSplashFolderUrl = URLFactory.newDirURL((URL)applicationResourceOutputUrl, (String)currDestinationFolderSet.getLandscapeSplashFolderName());
                String configuredLandscapSplashPath = AndroidImageUtil._getConfiguredImagePathFromHash(af.getWorkspace(), "landscapeSplashScreenPath", imageOptionsHash);
                DeployFileUtils.copyImage(appLandscapSplashFolderUrl, defaultResourcesRootFolderUrl, configuredLandscapSplashPath, currDefaultImageNameSet.getLandscapeSplashName(), APPLICATION_SPLASHSCREEN_NAME);
            }
        }
        catch (Exception e) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00025"), (Throwable)e);
        }
    }

    public static void addDefaultsToImageOptions(ImageOptions imageOptions) {
        HashStructure imageOptionsHash;
        for (v1ToV1_1ImageSet imageSet : v1ToV1_1ImageSet.values()) {
            String imagePath = imageOptions.getStringValue(imageSet.getOldKey());
            if (null != imagePath && !imagePath.isEmpty()) {
                imageOptionsHash = DeployFileUtils.getDeviceTypeHash(imageOptions, imageSet.getDeviceType());
                imageOptionsHash.putString(imageSet.getNewKey(), imagePath);
            }
            imageOptions.removeKey(imageSet.getOldKey());
        }
        Map<ImageToDeviceInformation, DefaultImageNameSet> imageInfoToDefaultImageSetMap = ImageToDeviceInformation.getImageInfoToDefaultImageMap();
        for (Map.Entry<ImageToDeviceInformation, DefaultImageNameSet> currEntry : imageInfoToDefaultImageSetMap.entrySet()) {
            ImageToDeviceInformation currImageToDevice = currEntry.getKey();
            DefaultImageNameSet currDefaultImageSet = currEntry.getValue();
            imageOptionsHash = DeployFileUtils.getDeviceTypeHash(imageOptions, currImageToDevice.getImageOptionsKey());
            String imageDefault = currDefaultImageSet.getAppImageName();
            AndroidImageUtil._updateImageInOptions(imageOptionsHash, "appIconPath", imageDefault);
            String portraitSplashDefault = currDefaultImageSet.getPortraitSplashName();
            AndroidImageUtil._updateImageInOptions(imageOptionsHash, "portraitSplashScreenPath", portraitSplashDefault);
            String landscapeSplashDefault = currDefaultImageSet.getLandscapeSplashName();
            AndroidImageUtil._updateImageInOptions(imageOptionsHash, "landscapeSplashScreenPath", landscapeSplashDefault);
        }
    }

    private static String _getConfiguredImagePathFromHash(Workspace workspace, String imageType, HashStructure imageOptionsHash) {
        String imagePath = imageOptionsHash.getString(imageType);
        return FileUtils.getAbsoluteLocation(workspace, imagePath);
    }

    private static void _updateImageInOptions(HashStructure imageOptionsHash, String imageType, String imageName) {
        String appIcon = imageOptionsHash.getString(imageType);
        if (null == appIcon || appIcon.isEmpty()) {
            imageOptionsHash.putString(imageType, DEFAULT_RESOURCE_RELATIVE_PATH + imageName);
        }
    }

    private static enum v1ToV1_1ImageSet {
        LOW_DENSITY_IMAGE_MAPPING("icon1", "Low Density", "appIconPath"),
        MED_DENSITY_IMAGE_MAPPING("icon2", "Medium Density", "appIconPath"),
        HIGH_DENSITY_APP_IMAGE_MAPPING("icon3", "High Density", "appIconPath"),
        EXTRA_HIGH_DENSITY_APP_IMAGE_MAPPING("icon4", "Extra-High Density", "appIconPath"),
        LOW_DENSITY_PORT_SPLASH_MAPPING("portSplashScreen1", "Low Density", "portraitSplashScreenPath"),
        MED_DENSITY_PORT_SPLASH_MAPPING("portSplashScreen2", "Medium Density", "portraitSplashScreenPath"),
        HIGH_DENSITY_PORT_SPLASH_MAPPING("portSplashScreen3", "High Density", "portraitSplashScreenPath"),
        EXTRA_HIGH_DENSITY_PORT_SPLASH_MAPPING("portSplashScreen4", "Extra-High Density", "portraitSplashScreenPath"),
        LOW_DENSITY_LANDSPLASH_MAPPING("landSplashScreen1", "Low Density", "landscapeSplashScreenPath"),
        MED_DENSITY_LAND_SPLASH_MAPPING("landSplashScreen2", "Medium Density", "landscapeSplashScreenPath"),
        HIGH_DENSITY_LAND_SPLASH_MAPPING("landSplashScreen1", "High Density", "landscapeSplashScreenPath"),
        EXTRA_HIGH_DENSITY_LAND_SPLASH_MAPPING("landSplashScreen2", "Extra-High Density", "landscapeSplashScreenPath");

        private final String _oldKey;
        private final String _deviceType;
        private final String _newKey;

        public String getOldKey() {
            return this._oldKey;
        }

        public String getDeviceType() {
            return this._deviceType;
        }

        public String getNewKey() {
            return this._newKey;
        }

        private v1ToV1_1ImageSet(String oldKey, String deviceType, String newKey) {
            this._oldKey = oldKey;
            this._deviceType = deviceType;
            this._newKey = newKey;
        }
    }

    private static enum ImageToDeviceInformation {
        DRAWABLE_IPHONE_IMAGE_DEST(DefaultImageNameSet.DISPLAY_LOW_RES_IMAGES, DestinationImageFolderSet.DISPLAY_LOW_RES_IMAGES, "Low Density"),
        DRAWABLE_IPAD_IMAGE_DEST(DefaultImageNameSet.DISPLAY_MEDIUM_RES_IMAGES, DestinationImageFolderSet.DISPLAY_MEDIUM_RES_IMAGES, "Medium Density"),
        DRAWABLE_IPHONE_RETINA_IMAGE_DEST(DefaultImageNameSet.DISPLAY_HIGH_RES_IMAGES, DestinationImageFolderSet.DISPLAY_HIGH_RES_IMAGES, "High Density"),
        DRAWABLE_IPAD_RETINA_IMAGE_DEST(DefaultImageNameSet.DISPLAY_ULTRA_HIGH_RES_IMAGES, DestinationImageFolderSet.DISPLAY_ULTRA_HIGH_RES_IMAGES, "Extra-High Density");

        private final DefaultImageNameSet m_defaultImageName;
        private final DestinationImageFolderSet m_destinationImageFolderName;
        private final String m_imageOptionsKey;

        public static Map<ImageToDeviceInformation, DefaultImageNameSet> getImageInfoToDefaultImageMap() {
            HashMap<ImageToDeviceInformation, DefaultImageNameSet> defaultImageNameToImageNameMap = new HashMap<ImageToDeviceInformation, DefaultImageNameSet>();
            for (ImageToDeviceInformation V1_2_ImageInformation : ImageToDeviceInformation.values()) {
                defaultImageNameToImageNameMap.put(V1_2_ImageInformation, V1_2_ImageInformation.getDefaultImageName());
            }
            return defaultImageNameToImageNameMap;
        }

        public static Map<ImageToDeviceInformation, DestinationImageFolderSet> getImageFolderToDestinationFolderMap() {
            HashMap<ImageToDeviceInformation, DestinationImageFolderSet> folderNameToImageNameMap = new HashMap<ImageToDeviceInformation, DestinationImageFolderSet>();
            for (ImageToDeviceInformation V1_2_ImageInformation : ImageToDeviceInformation.values()) {
                folderNameToImageNameMap.put(V1_2_ImageInformation, V1_2_ImageInformation.getDestinationFolderName());
            }
            return folderNameToImageNameMap;
        }

        public DefaultImageNameSet getDefaultImageName() {
            return this.m_defaultImageName;
        }

        public DestinationImageFolderSet getDestinationFolderName() {
            return this.m_destinationImageFolderName;
        }

        public String getImageOptionsKey() {
            return this.m_imageOptionsKey;
        }

        private ImageToDeviceInformation(DefaultImageNameSet defaultImageName, DestinationImageFolderSet destinationFolderName, String imageOptionsKey) {
            this.m_defaultImageName = defaultImageName;
            this.m_destinationImageFolderName = destinationFolderName;
            this.m_imageOptionsKey = imageOptionsKey;
        }
    }

    private static enum DestinationImageFolderSet {
        DISPLAY_LOW_RES_IMAGES("drawable-ldpi", "drawable-port-ldpi", "drawable-land-ldpi"),
        DISPLAY_MEDIUM_RES_IMAGES("drawable-mdpi", "drawable-port-mdpi", "drawable-land-mdpi"),
        DISPLAY_HIGH_RES_IMAGES("drawable-hdpi", "drawable-port-hdpi", "drawable-land-hdpi"),
        DISPLAY_ULTRA_HIGH_RES_IMAGES("drawable-xhdpi", "drawable-port-xhdpi", "drawable-land-xhdpi");

        private final String m_defaultAppImageFolderName;
        private final String m_defaultPortraitSplashFolderName;
        private final String m_defaultLandscapeSplashfolderName;

        public String getAppImageFolderName() {
            return this.m_defaultAppImageFolderName;
        }

        public String getPortraitSplashFolderName() {
            return this.m_defaultPortraitSplashFolderName;
        }

        public String getLandscapeSplashFolderName() {
            return this.m_defaultLandscapeSplashfolderName;
        }

        private DestinationImageFolderSet(String defaultImageName, String defaultPortraitSplashImage, String defaultLandscapeSplashImage) {
            this.m_defaultAppImageFolderName = defaultImageName;
            this.m_defaultPortraitSplashFolderName = defaultPortraitSplashImage;
            this.m_defaultLandscapeSplashfolderName = defaultLandscapeSplashImage;
        }
    }

    private static enum DefaultImageNameSet {
        DISPLAY_LOW_RES_IMAGES("display-ldpi-icon.png", "display-port-ldpi-splashscreen.png", "display-land-ldpi-splashscreen.png"),
        DISPLAY_MEDIUM_RES_IMAGES("display-mdpi-icon.png", "display-port-mdpi-splashscreen.png", "display-land-mdpi-splashscreen.png"),
        DISPLAY_HIGH_RES_IMAGES("display-hdpi-icon.png", "display-port-hdpi-splashscreen.png", "display-land-hdpi-splashscreen.png"),
        DISPLAY_ULTRA_HIGH_RES_IMAGES("display-xhdpi-icon.png", "display-port-xhdpi-splashscreen.png", "display-land-xhdpi-splashscreen.png");

        private final String m_defaultAppImageName;
        private final String m_defaultPortraitSplashName;
        private final String m_defaultLandscapeSplashName;

        public String getAppImageName() {
            return this.m_defaultAppImageName;
        }

        public String getPortraitSplashName() {
            return this.m_defaultPortraitSplashName;
        }

        public String getLandscapeSplashName() {
            return this.m_defaultLandscapeSplashName;
        }

        private DefaultImageNameSet(String defaultImageName, String defaultPortraitSplashImage, String defaultLandscapeSplashImage) {
            this.m_defaultAppImageName = defaultImageName;
            this.m_defaultPortraitSplashName = defaultPortraitSplashImage;
            this.m_defaultLandscapeSplashName = defaultLandscapeSplashImage;
        }
    }
}

