/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.util;

import java.net.URL;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.AndroidProfile;
import oracle.adfmf.framework.dt.preferences.PlatformSDKsPrefs;
import oracle.ide.config.Preferences;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;

public class AndroidDeployUtil {
    private static final String ANDROID_SDK_TOOLS_DIR_NAME = "tools";
    private static final String ANDROID_PLATFORM_TOOLS_DIR_NAME = "platform-tools";
    private static final String ANDROID_JAR_FILE = "android.jar";
    private static final String ANDROID = "Android";

    public static String getAndroidSdkPath() throws DeployException {
        Preferences preferences = Preferences.getPreferences();
        PlatformSDKsPrefs platformPrefs = PlatformSDKsPrefs.getInstance((PropertyStorage)preferences);
        String androidSdkDir = platformPrefs.getAndroidSdkDir();
        if (!ModelUtil.hasLength((String)androidSdkDir)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00027"));
        }
        String trimmedSdkDir = androidSdkDir.trim();
        if (!ModelUtil.hasLength((String)trimmedSdkDir)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00027"));
        }
        if (!FileUtils.doesFileExist(trimmedSdkDir)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00028"));
        }
        return trimmedSdkDir;
    }

    public static String getAndroidPlatformPath() throws DeployException {
        Preferences preferences = Preferences.getPreferences();
        PlatformSDKsPrefs platformPrefs = PlatformSDKsPrefs.getInstance((PropertyStorage)preferences);
        String androidPlatformPath = platformPrefs.getAndroidPlatformDir();
        if (!ModelUtil.hasLength((String)androidPlatformPath)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00030"));
        }
        String trimmedPlatformPath = androidPlatformPath.trim();
        if (!ModelUtil.hasLength((String)trimmedPlatformPath)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00030"));
        }
        String androidJarPath = trimmedPlatformPath + ADFMobileConstants.PATH_SEP + ANDROID_JAR_FILE;
        if (!FileUtils.doesFileExist(androidJarPath)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00029"));
        }
        return androidPlatformPath;
    }

    public static String getAndroidSdkToolPath(String androidToolName) throws DeployException {
        return AndroidDeployUtil.getAndroidToolPath(ANDROID_SDK_TOOLS_DIR_NAME, androidToolName);
    }

    public static String getAndroidBuildToolPath(String androidToolName) throws DeployException {
        Preferences preferences = Preferences.getPreferences();
        PlatformSDKsPrefs platformPrefs = PlatformSDKsPrefs.getInstance((PropertyStorage)preferences);
        String buildToolsDir = platformPrefs.getAndroidBuildToolsDir();
        String ANDROID_TOOL_PATH_FORMAT = "%s\\%s";
        String toolPath = String.format("%s\\%s", buildToolsDir, androidToolName);
        return URLFileSystem.getPlatformPathName((URL)URLFactory.newFileURL((String)toolPath));
    }

    public static String getAndroidPlatformToolPath(String androidToolName) throws DeployException {
        return AndroidDeployUtil.getAndroidToolPath(ANDROID_PLATFORM_TOOLS_DIR_NAME, androidToolName);
    }

    private static String getAndroidToolPath(String toolDirFolder, String androidToolName) throws DeployException {
        String ANDROID_TOOL_PATH_FORMAT = "%s\\%s\\%s";
        String toolPath = String.format("%s\\%s\\%s", AndroidDeployUtil.getAndroidSdkPath(), toolDirFolder, androidToolName);
        return URLFileSystem.getPlatformPathName((URL)URLFactory.newFileURL((String)toolPath));
    }

    public static String getJavaJdkToolPath(String jdkBinFolderPath, String jdkToolName) {
        String JDK_TOOL_PATH_FORMAT = "%s\\%s";
        String toolPath = String.format("%s\\%s", jdkBinFolderPath, jdkToolName);
        return URLFileSystem.getPlatformPathName((URL)URLFactory.newFileURL((String)toolPath));
    }

    public static URL getAndroidSupportFilesDirectoryUrl() {
        return URLFactory.newURL((URL)FileUtils.getSupportFilesDirectoryUrl(), (String)ANDROID);
    }

    public static final AndroidProfile getAndroidProfile(DeployShell deployShell) throws DeployException {
        return AndroidProfile.newAndroidProfile(deployShell);
    }

    public static String getVersionNameFromAdfmfApplicationXml(Workspace workspace) {
        return McAppUtils.getApplicationVersion(workspace);
    }

    public static boolean isValidPackageName(String packageName) {
        String APPLICATION_BUNDLE_ID_REGEX = "[a-zA-Z]+[a-zA-Z0-9_]*(\\.[a-zA-Z][a-zA-Z0-9_]*)+";
        return packageName.matches("[a-zA-Z]+[a-zA-Z0-9_]*(\\.[a-zA-Z][a-zA-Z0-9_]*)+");
    }
}

