/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.ui.wizard.spi;

import java.net.URL;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.AndroidProfile;
import oracle.adfmf.framework.dt.deploy.android.deployers.AndroidFileUtils;
import oracle.adfmf.framework.dt.deploy.android.ui.editor.options.AndroidOptions;
import oracle.adfmf.framework.dt.deploy.android.ui.wizard.commands.DeviceCommand;
import oracle.adfmf.framework.dt.deploy.android.ui.wizard.commands.EmulatorCommand;
import oracle.adfmf.framework.dt.deploy.android.ui.wizard.commands.PackageCommand;
import oracle.adfmf.framework.dt.deploy.cmd.McAppProfileDeployCommand;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.dt.wizard.spi.AbstractDeploySummaryProvider;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public class DeploySummaryBuilder
extends AbstractDeploySummaryProvider {
    private Workspace _workspace;

    protected boolean shouldCreateFor(DeployCommand deployCommand, ToolkitContext context, Cookie cookie) {
        if (deployCommand instanceof EmulatorCommand || deployCommand instanceof DeviceCommand || deployCommand instanceof PackageCommand) {
            this._workspace = context.getIdeContext().getWorkspace();
            return true;
        }
        return false;
    }

    public Class getTypeForNarrow() {
        return AndroidProfile.class;
    }

    protected TreeNode buildSummary(DeployCommand deployCommand, TraversableContext tc, Cookie cookie) {
        assert (deployCommand instanceof McAppProfileDeployCommand);
        McAppProfileDeployCommand mobileDeployCmd = (McAppProfileDeployCommand)deployCommand;
        Profile profile = mobileDeployCmd.getProfile();
        assert (profile instanceof AndroidProfile);
        AndroidProfile androidProfile = (AndroidProfile)profile;
        String appDetailDescription = MobileResourceUtils.getText("DEPLOY_SUMMARY_APPLICATION_DETAIL_DESCRIPTION");
        DefaultMutableTreeNode appDetail = new DefaultMutableTreeNode(appDetailDescription);
        if (null != androidProfile && null != this._workspace) {
            try {
                AndroidFileUtils af = new AndroidFileUtils(this._workspace, androidProfile);
                AndroidOptions options = androidProfile.getAndroidOptions();
                String appBundleId = options.getAppBundleId();
                String appBundleIdInfo = MobileResourceUtils.getText("DEPLOY_SUMMARY_APPLICATION_BUNDLE_ID_DESCRIPTION", appBundleId);
                appDetail.add(new DefaultMutableTreeNode(appBundleIdInfo));
                String deployFileName = URLFileSystem.getFileName((URL)af.getAndroidApplicationURL());
                String deployFileInfo = MobileResourceUtils.getText("DEPLOY_SUMMARY_FILE_DESCRIPTION", deployFileName);
                appDetail.add(new DefaultMutableTreeNode(deployFileInfo));
                String deployMode = null;
                deployMode = options.getIsDebugMode() ? MobileResourceUtils.getText("ANDROID_DEPLOY_SUMMARY_DEBUG_MODE_DESCRIPTION") : MobileResourceUtils.getText("ANDROID_DEPLOY_SUMMARY_RELEASE_MODE_DESCRIPTION");
                String deployModeInfo = MobileResourceUtils.getText("ANDROID_DEPLOY_SUMMARY_DEPLOY_MODE_DESCRIPTION", deployMode);
                appDetail.add(new DefaultMutableTreeNode(deployModeInfo));
            }
            catch (DeployException e) {
                // empty catch block
            }
        }
        return appDetail;
    }
}

