/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.ui.wizard.commands;

import oracle.adfmf.framework.dt.deploy.android.ui.wizard.commands.DeviceCommand;
import oracle.adfmf.framework.dt.deploy.android.ui.wizard.commands.EmulatorCommand;
import oracle.adfmf.framework.dt.deploy.android.ui.wizard.commands.PackageCommand;
import oracle.adfmf.framework.dt.deploy.cmd.McAppProfileDeployCommand;
import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.cmd.DeployCommandState;
import oracle.jdeveloper.deploy.cmd.spi.HashDeployCommandWriter;
import oracle.jdeveloper.deploy.cmd.spi.providers.AbstractHashDeployCommandIOProvider;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public class CommandIOProvider
extends AbstractHashDeployCommandIOProvider {
    protected boolean canRead(Element element, HashStructure hash, ToolkitContext tkContext, Cookie cookie) {
        String className = DeployCommandState.getCommandClassName((HashStructure)hash);
        if (EmulatorCommand.class.getName().equals(className) || PackageCommand.class.getName().equals(className) || DeviceCommand.class.getName().equals(className)) {
            cookie.bind(HashStructure.class, (Object)hash);
            return true;
        }
        return false;
    }

    protected boolean canWrite(Element element, DeployCommand command, ToolkitContext tkContext, Cookie cookie) {
        boolean bCanWrite = false;
        Class<?> commandClass = command.getClass();
        if (commandClass == EmulatorCommand.class) {
            cookie.bind(EmulatorCommand.class, (Object)command);
            bCanWrite = true;
        } else if (commandClass == DeviceCommand.class) {
            cookie.bind(DeviceCommand.class, (Object)command);
            bCanWrite = true;
        } else if (commandClass == PackageCommand.class) {
            cookie.bind(PackageCommand.class, (Object)command);
            bCanWrite = true;
        }
        return bCanWrite;
    }

    protected DeployCommand read(Element element, Cookie cookie) {
        HashStructure hash = (HashStructure)cookie.get(HashStructure.class);
        String className = DeployCommandState.getCommandClassName((HashStructure)hash);
        McAppProfileDeployCommand deployCommand = null;
        if (EmulatorCommand.class.getName().equals(className)) {
            deployCommand = new EmulatorCommand(hash);
        } else if (PackageCommand.class.getName().equals(className)) {
            deployCommand = new PackageCommand(hash);
        } else if (DeviceCommand.class.getName().equals(className)) {
            deployCommand = new DeviceCommand(hash);
        }
        return deployCommand;
    }

    protected void write(HashStructure hash, Element element, Cookie cookie) {
        DeployCommand cmd = this.getAndroidCommandFromCookie(cookie);
        cmd.getState().saveTo(hash);
    }

    protected HashDeployCommandWriter.HashDisplayable getDisplayable(Element element, Cookie cookie) {
        DeployCommand command = this.getAndroidCommandFromCookie(cookie);
        HashDeployCommandWriter.HashDisplayable d = new HashDeployCommandWriter.HashDisplayable();
        d.setShortLabel(command.getShortLabel());
        d.setLongLabel(command.getLongLabel());
        d.setToolTipText(command.getToolTipText());
        return d;
    }

    private DeployCommand getAndroidCommandFromCookie(Cookie cookie) {
        Object cmdObject = null;
        if (cookie.containsKey((Object)EmulatorCommand.class.getName())) {
            cmdObject = cookie.get((Object)EmulatorCommand.class.getName());
        } else if (cookie.containsKey((Object)DeviceCommand.class.getName())) {
            cmdObject = cookie.get((Object)DeviceCommand.class.getName());
        } else if (cookie.containsKey((Object)PackageCommand.class.getName())) {
            cmdObject = cookie.get((Object)PackageCommand.class.getName());
        }
        assert (null != cmdObject);
        assert (cmdObject instanceof DeployCommand);
        return (DeployCommand)cmdObject;
    }
}

