/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.ui.editor.panels;

import java.awt.Component;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.adfmf.common.ControlGroupPanel;
import oracle.adfmf.common.McTwoColumnPanel;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.core.JavacOptions;
import oracle.adfmf.framework.dt.deploy.android.core.ZipAlignOptions;
import oracle.adfmf.framework.dt.deploy.android.ui.editor.AndroidEditor;
import oracle.adfmf.framework.dt.deploy.android.ui.editor.options.AndroidOptions;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.adfmf.framework.dt.deploy.common.util.DeployUtil;
import oracle.ide.model.Workspace;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Encodings;
import oracle.ide.util.Namespace;
import oracle.javatools.ui.Borders;
import oracle.javatools.util.ModelUtil;

public class AndroidOptionsPanel
extends McTwoColumnPanel {
    private static final long serialVersionUID = 1L;
    private static final int SPINNER_STEP_COUNT = 1;
    private static final int PADDING_PIXEL_COUNT = 10;
    private static final String KEYSTORE_FILE_EXTENSION = ".keystore";
    private static final String JDK_VERSION_1_5 = "1.5";
    private static final String JDK_VERSION_1_6 = "1.6";
    private static final String COMBO_PROTOTYPE_DISPLAY_VALUE = "XXXXXXXXXXXXXXXX";
    private JRadioButton m_debugDeployRadioButton;
    private JRadioButton m_releaseDeployRadioButton;
    private JComboBox m_zipAlignComboBox;
    private JCheckBox m_verboseOutputCheckbox;
    private JSpinner m_minimumSdkLevelSpinner;
    private JSpinner m_targetSdkLevelSpinner;
    private JTextField m_versionNameTextField;
    private JSpinner m_versionCodeSpinner;
    private JComboBox m_encodingCombo;
    private JComboBox m_classCombo;
    private JComboBox m_srcCombo;
    private final URL m_projectUrl = McAppUtils.getAppRootURL(null);
    private JTextField m_applicationBundleId;
    private JTextField m_applicationArchiveName;
    private static final Map<String, String> m_sSupportedKeystoreFileTypeMap;
    private static final Map<String, String> m_sZipAlignmentUiToOptionValueMap;
    private static final Map<String, String> m_sZipAlignmentOptionValueToUiMap;
    private static final Map<String, String> m_sVersionCompatibilityOptionValueToUiMap;
    private static final Map<String, String> m_sVersionCompatibilityUiToOptionValueMap;
    private static final String[] m_sZipAlignUiArray;
    private static final String[] m_sVersionCompatibilityArray;
    private static String OPTIONS_HELP_ID;

    public AndroidOptionsPanel() {
        this.createControls();
    }

    public void onEntry(TraversableContext context) {
        super.onEntry(context);
        AndroidOptions androidOptions = AndroidEditor.getAndroidOptions((Namespace)context);
        Workspace workspace = McAppUtils.newWorkspaceFromNamespace((Namespace)context);
        if (null != androidOptions) {
            boolean bIsDebugDeployment = androidOptions.getIsDebugMode();
            this.m_debugDeployRadioButton.setSelected(bIsDebugDeployment);
            this.m_releaseDeployRadioButton.setSelected(!bIsDebugDeployment);
            this.m_verboseOutputCheckbox.setSelected(androidOptions.getIsVerboseMode());
            this.m_minimumSdkLevelSpinner.setValue(Integer.parseInt(androidOptions.getMinimumSdkVersion()));
            this.m_versionCodeSpinner.setValue(Integer.parseInt(androidOptions.getVersionCode()));
            this.m_targetSdkLevelSpinner.setValue(Integer.parseInt(androidOptions.getTargetSdkVersion()));
            String configuredCharacterEncoding = androidOptions.getCharacterEncoding();
            Encodings.initComboBox((JComboBox)this.m_encodingCombo, (boolean)true, (String)configuredCharacterEncoding);
            String configuredClassVersionCompatibility = androidOptions.getClassJdkVersionCompatibility();
            this.m_classCombo.setSelectedItem(m_sVersionCompatibilityOptionValueToUiMap.get(configuredClassVersionCompatibility));
            String configuredSourceVersionCompatibility = androidOptions.getJavaJdkVersionCompatibility();
            this.m_srcCombo.setSelectedItem(m_sVersionCompatibilityOptionValueToUiMap.get(configuredSourceVersionCompatibility));
            String configuredZipAlignment = androidOptions.getZipAlignment();
            if (m_sZipAlignmentOptionValueToUiMap.containsKey(configuredZipAlignment)) {
                this.m_zipAlignComboBox.setSelectedItem(m_sZipAlignmentOptionValueToUiMap.get(configuredZipAlignment));
            } else {
                this.m_zipAlignComboBox.setSelectedItem(m_sZipAlignmentOptionValueToUiMap.get(ZipAlignOptions.get32BitAlignmentValue()));
            }
            String deploymentApplicationBundleId = androidOptions.getAppBundleId();
            this.m_applicationBundleId.setText(deploymentApplicationBundleId);
            String deploymentApplicationArchiveName = androidOptions.getApplicationArchiveName();
            this.m_applicationArchiveName.setText(deploymentApplicationArchiveName);
            String versionName = androidOptions.getVersionName();
            if (!ModelUtil.hasLength((String)versionName)) {
                versionName = AndroidDeployUtil.getVersionNameFromAdfmfApplicationXml(workspace);
            }
            this.m_versionNameTextField.setText(versionName);
        }
    }

    public void onExit(TraversableContext context) throws TraversalException {
        super.onExit(context);
        AndroidOptions androidOptions = AndroidEditor.getAndroidOptions((Namespace)context);
        Workspace workspace = McAppUtils.newWorkspaceFromNamespace((Namespace)context);
        if (null != androidOptions) {
            androidOptions.setIsDebugMode(this.m_debugDeployRadioButton.isSelected());
            androidOptions.setIsVerboseMode(this.m_verboseOutputCheckbox.isSelected());
            androidOptions.setMinimumSdkVersion(this.getSpinnerValueAsString(this.m_minimumSdkLevelSpinner));
            androidOptions.setTargetSdkVersion(this.getSpinnerValueAsString(this.m_targetSdkLevelSpinner));
            androidOptions.setVersionCode(this.getSpinnerValueAsString(this.m_versionCodeSpinner));
            String selectedUiZipOption = this.m_zipAlignComboBox.getSelectedItem().toString();
            androidOptions.setZipAlignment(m_sZipAlignmentUiToOptionValueMap.get(selectedUiZipOption));
            String selectedCharacterEncoding = this.m_encodingCombo.getSelectedItem().toString();
            androidOptions.setCharacterEncoding(selectedCharacterEncoding);
            String selectedClassVersionCompatibility = this.m_classCombo.getSelectedItem().toString();
            androidOptions.setClassJdkVersionCompatibility(m_sVersionCompatibilityUiToOptionValueMap.get(selectedClassVersionCompatibility));
            String selectedSourceVersionCompatibility = this.m_srcCombo.getSelectedItem().toString();
            androidOptions.setJavaJdkVersionCompatibility(m_sVersionCompatibilityUiToOptionValueMap.get(selectedSourceVersionCompatibility));
            String configuredApplicationBundleId = this.m_applicationBundleId.getText();
            if (!AndroidDeployUtil.isValidPackageName(configuredApplicationBundleId)) {
                String dialogTitle = MobileResourceUtils.getText("ANDROID_INVALID_APPLICATION_BUNDLE_ID_DLG_TITLE");
                String errMessage = MobileResourceUtils.getMsg("ADF-MBL-01600");
                this.m_applicationBundleId.requestFocusInWindow();
                throw new TraversalException(errMessage, dialogTitle);
            }
            androidOptions.setAppBundleId(configuredApplicationBundleId);
            String configuredApplicationArchiveName = this.m_applicationArchiveName.getText();
            if (!DeployUtil.isValidApplicationArchiveName(configuredApplicationArchiveName)) {
                this.m_applicationArchiveName.requestFocusInWindow();
                String msg = MobileResourceUtils.getMsg("ADF-MBL-02014");
                throw new TraversalException(msg);
            }
            androidOptions.setApplicationArchiveName(configuredApplicationArchiveName);
            String configuredVersionName = this.m_versionNameTextField.getText();
            String applicationXmlVersionName = AndroidDeployUtil.getVersionNameFromAdfmfApplicationXml(workspace);
            if (ModelUtil.hasLength((String)configuredVersionName)) {
                if (!configuredVersionName.equals(applicationXmlVersionName)) {
                    androidOptions.setVersionName(configuredVersionName);
                }
            } else {
                androidOptions.setVersionName("");
            }
        }
    }

    private void createControls() {
        boolean gridX = false;
        int gridY = 0;
        ControlGroupPanel parentPanel = new ControlGroupPanel();
        parentPanel.addPanel(this.createApplicationDetailPanel(), 0, gridY++);
        parentPanel.addPanel(this.createDeploymentOptionsPanel(), 0, gridY++);
        this.add((Component)((Object)parentPanel), this.gbc(this._lastX, this._lastY++, 1, 1, 0.0, 0.0, 17, 1, this._insets));
        this.addGlue();
    }

    private String getSpinnerValueAsString(JSpinner spinner) {
        Object o = spinner.getValue();
        assert (o instanceof Integer);
        Integer value = (Integer)o;
        return value.toString();
    }

    private SpinnerNumberModel newSpinnerModel(int initialValue, int minimumValue) {
        if (initialValue < minimumValue) {
            throw new IllegalArgumentException();
        }
        return new SpinnerNumberModel((Number)initialValue, Integer.valueOf(minimumValue), null, (Number)1);
    }

    private ControlGroupPanel createApplicationDetailPanel() {
        boolean MIN_VERSION = true;
        boolean gridX = false;
        int gridY = 0;
        ControlGroupPanel appDetail = new ControlGroupPanel();
        appDetail.addLabeledSeparator(MobileResourceUtils.getText("APPLICATION_DETAILS_SEPARATOR"), 0, gridY++);
        this.m_applicationBundleId = appDetail.addLabeledTextField(MobileResourceUtils.getText("APP_BUNDLE_ID_LABEL"), 0, 0, gridY++, false, false, false);
        this.m_applicationBundleId.getDocument().addDocumentListener(new ApplicationBundleIdDocumentListener());
        this.m_applicationArchiveName = appDetail.addLabeledTextField(MobileResourceUtils.getText("APP_ARCHIVE_NAME_LABEL"), 0, 0, gridY++, false, false, false);
        this.m_applicationArchiveName.getDocument().addDocumentListener(new ApplicationPackageNameDocumentListener());
        this.m_versionNameTextField = appDetail.addLabeledTextField(MobileResourceUtils.getText("ANDROID_OPTIONS_VERSION_NAME_LABEL"), 0, 0, gridY++, false, false, false);
        this.m_versionCodeSpinner = appDetail.addLabeledNumberSpinner(MobileResourceUtils.getText("ANDROID_OPTIONS_VERSION_CODE_LABEL"), this.newSpinnerModel(1, 1), 1, 10, 0, gridY++);
        return appDetail;
    }

    private ControlGroupPanel createDeploymentOptionsPanel() {
        boolean gridX = false;
        int gridY = 0;
        ControlGroupPanel toolOptions = new ControlGroupPanel();
        int PADDING_SECOND_COLOMN = 8;
        toolOptions.addLabeledSeparator(MobileResourceUtils.getText("ANDROID_DEPLOYMENT_SEPARATOR"), 0, gridY++);
        this.m_srcCombo = toolOptions.addLabeledComboBox(MobileResourceUtils.getText("ANDROID_SOURCE_FILE_VERSION_COMPATIBILITY_LABEL"), m_sVersionCompatibilityArray, 0, gridY);
        this.m_srcCombo.setPrototypeDisplayValue(COMBO_PROTOTYPE_DISPLAY_VALUE);
        toolOptions.setLeftIndentPixelSize(8);
        this.m_targetSdkLevelSpinner = toolOptions.addLabeledNumberSpinner(MobileResourceUtils.getText("ANDROID_OPTIONS_SDK_TARGET_LEVEL_LABEL"), this.newSpinnerModel(9, 9), 1, 10, 2, gridY++);
        toolOptions.setLeftIndentPixelSize(0);
        this.m_classCombo = toolOptions.addLabeledComboBox(MobileResourceUtils.getText("ANDROID_CLASS_FILE_VERSION_COMPATIBILITY_LABEL"), m_sVersionCompatibilityArray, 0, gridY);
        this.m_classCombo.setPrototypeDisplayValue(COMBO_PROTOTYPE_DISPLAY_VALUE);
        toolOptions.setLeftIndentPixelSize(8);
        this.m_minimumSdkLevelSpinner = toolOptions.addLabeledNumberSpinner(MobileResourceUtils.getText("ANDROID_OPTIONS_SDK_MINIMUM_LEVEL_LABEL"), this.newSpinnerModel(9, 9), 1, 10, 2, gridY++);
        toolOptions.setLeftIndentPixelSize(0);
        this.m_encodingCombo = toolOptions.addLabeledComboBox(MobileResourceUtils.getText("ANDROID_CHARACTER_ENCODING_LABEL"), null, 0, gridY++);
        this.m_encodingCombo.setPrototypeDisplayValue(COMBO_PROTOTYPE_DISPLAY_VALUE);
        this.m_zipAlignComboBox = toolOptions.addLabeledComboBox(MobileResourceUtils.getText("ANDROID_ZIP_ALIGNMENT_OPTIMIZATION_LABEL"), m_sZipAlignUiArray, 0, gridY++);
        this.m_zipAlignComboBox.setPrototypeDisplayValue(COMBO_PROTOTYPE_DISPLAY_VALUE);
        this.m_verboseOutputCheckbox = toolOptions.addCheckbox(MobileResourceUtils.getText("ANDROID_VERBOSE_OUTPUT_LABEL"), 0, gridY++, false);
        toolOptions.addJWrappedLabel(MobileResourceUtils.getText("BUILD_OPTIONS_MODE_LABEL"), 0, gridY++, 1, true);
        int LEFT_INDENT_PIXEL_LEN = 6;
        toolOptions.setLeftIndentPixelSize(6);
        this.m_debugDeployRadioButton = toolOptions.addRadioButton(MobileResourceUtils.getText("BUILD_OPTIONS_DEBUG_MODE"), true, 0, gridY++);
        this.m_releaseDeployRadioButton = toolOptions.addRadioButton(MobileResourceUtils.getText("BUILD_OPTIONS_RELEASE_MODE"), false, 0, gridY++);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_debugDeployRadioButton);
        buttonGroup.add(this.m_releaseDeployRadioButton);
        return toolOptions;
    }

    public String getHelpID() {
        return OPTIONS_HELP_ID;
    }

    static {
        OPTIONS_HELP_ID = "f1_adfmf_deployment_androidoptions_html";
        m_sSupportedKeystoreFileTypeMap = new HashMap<String, String>();
        m_sSupportedKeystoreFileTypeMap.put(KEYSTORE_FILE_EXTENSION, "");
        m_sZipAlignmentUiToOptionValueMap = new HashMap<String, String>();
        m_sZipAlignmentUiToOptionValueMap.put(MobileResourceUtils.getText("ANDROID_ZIP_ALIGNMENT_32_BIT_ALIGN_OPTION"), ZipAlignOptions.get32BitAlignmentValue());
        m_sZipAlignmentUiToOptionValueMap.put(MobileResourceUtils.getText("ANDROID_ZIP_ALIGNMENT_64_BIT_ALIGN_OPTION"), ZipAlignOptions.get64BitAlignmentValue());
        m_sZipAlignmentOptionValueToUiMap = new HashMap<String, String>();
        m_sZipAlignmentOptionValueToUiMap.put(ZipAlignOptions.get32BitAlignmentValue(), MobileResourceUtils.getText("ANDROID_ZIP_ALIGNMENT_32_BIT_ALIGN_OPTION"));
        m_sZipAlignmentOptionValueToUiMap.put(ZipAlignOptions.get64BitAlignmentValue(), MobileResourceUtils.getText("ANDROID_ZIP_ALIGNMENT_64_BIT_ALIGN_OPTION"));
        m_sZipAlignUiArray = new String[]{MobileResourceUtils.getText("ANDROID_ZIP_ALIGNMENT_32_BIT_ALIGN_OPTION"), MobileResourceUtils.getText("ANDROID_ZIP_ALIGNMENT_64_BIT_ALIGN_OPTION")};
        m_sVersionCompatibilityArray = new String[]{MobileResourceUtils.getText("ANDROID_VERSION_COMPATIBILITY_DEFAULT_OPTION"), JDK_VERSION_1_5, JDK_VERSION_1_6};
        m_sVersionCompatibilityOptionValueToUiMap = new HashMap<String, String>();
        m_sVersionCompatibilityOptionValueToUiMap.put(JavacOptions.getDefaultVersionCompatibility(), MobileResourceUtils.getText("ANDROID_VERSION_COMPATIBILITY_DEFAULT_OPTION"));
        m_sVersionCompatibilityOptionValueToUiMap.put(JDK_VERSION_1_5, JDK_VERSION_1_5);
        m_sVersionCompatibilityOptionValueToUiMap.put(JDK_VERSION_1_6, JDK_VERSION_1_6);
        m_sVersionCompatibilityUiToOptionValueMap = new HashMap<String, String>();
        m_sVersionCompatibilityUiToOptionValueMap.put(MobileResourceUtils.getText("ANDROID_VERSION_COMPATIBILITY_DEFAULT_OPTION"), JavacOptions.getDefaultVersionCompatibility());
        m_sVersionCompatibilityUiToOptionValueMap.put(JDK_VERSION_1_5, JDK_VERSION_1_5);
        m_sVersionCompatibilityUiToOptionValueMap.put(JDK_VERSION_1_6, JDK_VERSION_1_6);
    }

    private final class ApplicationPackageNameDocumentListener
    implements DocumentListener {
        private ApplicationPackageNameDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this._validateApplicationArchiveName();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this._validateApplicationArchiveName();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this._validateApplicationArchiveName();
        }

        private void _validateApplicationArchiveName() {
            String applicationArchiveName = AndroidOptionsPanel.this.m_applicationArchiveName.getText();
            if (DeployUtil.isValidApplicationArchiveName(applicationArchiveName)) {
                Borders.restoreBorder((JComponent)AndroidOptionsPanel.this.m_applicationArchiveName);
            } else {
                Borders.attachErrorBorder((JComponent)AndroidOptionsPanel.this.m_applicationArchiveName);
            }
        }
    }

    private final class ApplicationBundleIdDocumentListener
    implements DocumentListener {
        private ApplicationBundleIdDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this._validateBundleId();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this._validateBundleId();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this._validateBundleId();
        }

        private void _validateBundleId() {
            if (AndroidDeployUtil.isValidPackageName(AndroidOptionsPanel.this.m_applicationBundleId.getText())) {
                Borders.restoreBorder((JComponent)AndroidOptionsPanel.this.m_applicationBundleId);
            } else {
                Borders.attachErrorBorder((JComponent)AndroidOptionsPanel.this.m_applicationBundleId);
            }
        }
    }
}

