/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.ui.editor.options;

import oracle.adfmf.framework.dt.deploy.android.core.JavacOptions;
import oracle.adfmf.framework.dt.deploy.android.core.ZipAlignOptions;
import oracle.adfmf.framework.dt.deploy.common.ui.options.ApplicationArchiveNameDefaultValueImpl;
import oracle.adfmf.framework.dt.deploy.common.ui.options.ApplicationBundleIdDefaultValueImpl;
import oracle.ide.model.Workspace;
import oracle.ide.util.Namespace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;

public class AndroidOptions
extends DefaultLinkedDirtyable
implements Copyable {
    private final HashStructure _hash;
    private String _defaultApplicationArchiveName;
    private String _defaultApplicationBundleId;
    private static final String DEFAULT_VERSION_CODE = "1";
    private static final String KEY_ANDROID_OPTIONS = "android_options";
    private static final String KEY_APP_ZIP_ALIGN_FACTOR = "zip_align_optimization";
    private static final String KEY_TOOL_VERBOSE_MODE = "tool_verbose_mode";
    private static final String KEY_VERSION_CODE = "version_code";
    private static final String KEY_VERSION_NAME = "version_name";
    private static final String KEY_MINIMUM_SDK_VERSION = "minimum_sdk_version";
    private static final String KEY_TARGET_SDK_VERSION = "target_sdk_version";
    private static final String KEY_APP_DEPLOY_DEBUG_MODE = "android_deploy_debug_mode";
    private static final String KEY_APPLICATION_BUNDLE_ID = "application_bundle_id";
    private static final String KEY_APP_ARCHIVE_NAME = "application_archive_name";
    private static final String KEY_CHARACTER_ENCODING = "character_encoding";
    private static final String DEFAULT_CHARACTER_ENCODING = "Default";
    private static final String KEY_CLASS_JDK_VERSION_COMPATIBILITY = "class_jdk_version_compatibility";
    private static final String KEY_JAVA_JDK_VERSION_COMPATIBILITY = "java_jdk_version_compatibility";
    private static final String DEFAULT_VALUE = "";

    public static AndroidOptions newAndroidOptions(HashStructure hash, Workspace workspace) {
        if (null == hash || null == workspace) {
            throw new IllegalArgumentException();
        }
        AndroidOptions androidOptions = new AndroidOptions(hash);
        androidOptions._initialize(workspace);
        return androidOptions;
    }

    public static AndroidOptions newAndroidOptions(Namespace data) {
        if (null == data) {
            throw new IllegalArgumentException();
        }
        Object androidDataObject = data.find(KEY_ANDROID_OPTIONS);
        if (null == androidDataObject || !(androidDataObject instanceof AndroidOptions)) {
            throw new IllegalArgumentException();
        }
        AndroidOptions androidOptions = (AndroidOptions)((Object)androidDataObject);
        assert (null != androidOptions._defaultApplicationArchiveName);
        assert (null != androidOptions._defaultApplicationBundleId);
        return androidOptions;
    }

    public Object copyTo(Object target) {
        if (null != target && !(target instanceof AndroidOptions)) {
            throw new IllegalArgumentException();
        }
        if (null == this._defaultApplicationArchiveName || null == this._defaultApplicationBundleId) {
            throw new IllegalStateException();
        }
        AndroidOptions copy = target != null ? (AndroidOptions)((Object)target) : new AndroidOptions(HashStructure.newInstance());
        this._copyToImpl(copy);
        return copy;
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (null == o || o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (null == this._defaultApplicationArchiveName || null == this._defaultApplicationBundleId) {
            throw new IllegalStateException();
        }
        return this._equalsImpl((AndroidOptions)((Object)o));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 17;
        result = 31 * result + ModelUtil.hashCodeFor((Object)this._hash);
        result = 31 * result + ModelUtil.hashCodeFor((Object)this._defaultApplicationArchiveName);
        result = 31 * result + ModelUtil.hashCodeFor((Object)this._defaultApplicationBundleId);
        return result;
    }

    public static String getHashStructureKeyName() {
        return KEY_ANDROID_OPTIONS;
    }

    private boolean getBooleanValue(String keyName, boolean defaultValue) {
        return this.getHashStructure().getBoolean(keyName, defaultValue);
    }

    private void setBooleanValue(String keyName, boolean bValue) {
        if (ModelUtil.areDifferent((Object)this.getStringValue(keyName, DEFAULT_VALUE), (Object)Boolean.valueOf(bValue).toString())) {
            this.getHashStructure().putBoolean(keyName, bValue);
            this.markDirty(true);
        }
    }

    private String getStringValue(String keyName, String defaultValue) {
        return this.getHashStructure().getString(keyName, defaultValue);
    }

    private void setStringValue(String keyName, String keyValue) {
        if (ModelUtil.areDifferent((Object)this.getStringValue(keyName, DEFAULT_VALUE), (Object)keyValue)) {
            this.getHashStructure().putString(keyName, keyValue);
            this.markDirty(true);
        }
    }

    public boolean getIsVerboseMode() {
        return this.getBooleanValue(KEY_TOOL_VERBOSE_MODE, false);
    }

    public void setIsVerboseMode(boolean isVerboseMode) {
        this.setBooleanValue(KEY_TOOL_VERBOSE_MODE, isVerboseMode);
    }

    public boolean getIsDebugMode() {
        return this.getBooleanValue(KEY_APP_DEPLOY_DEBUG_MODE, true);
    }

    public void setIsDebugMode(boolean isDebugMode) {
        this.setBooleanValue(KEY_APP_DEPLOY_DEBUG_MODE, isDebugMode);
    }

    public String getZipAlignment() {
        return this.getStringValue(KEY_APP_ZIP_ALIGN_FACTOR, ZipAlignOptions.get32BitAlignmentValue());
    }

    public void setZipAlignment(String zipAlignment) {
        this.setStringValue(KEY_APP_ZIP_ALIGN_FACTOR, zipAlignment);
    }

    public String getVersionCode() {
        return this.getStringValue(KEY_VERSION_CODE, DEFAULT_VERSION_CODE);
    }

    public void setVersionCode(String version) {
        this.setStringValue(KEY_VERSION_CODE, version);
    }

    public String getVersionName() {
        return this.getStringValue(KEY_VERSION_NAME, DEFAULT_VALUE);
    }

    public void setVersionName(String version) {
        this.setStringValue(KEY_VERSION_NAME, version);
    }

    public String getMinimumSdkVersion() {
        return this.getStringValue(KEY_MINIMUM_SDK_VERSION, "9");
    }

    public void setMinimumSdkVersion(String version) {
        this.setStringValue(KEY_MINIMUM_SDK_VERSION, version);
    }

    public String getTargetSdkVersion() {
        return this.getStringValue(KEY_TARGET_SDK_VERSION, "9");
    }

    public void setTargetSdkVersion(String version) {
        this.setStringValue(KEY_TARGET_SDK_VERSION, version);
    }

    public String getAppBundleId() {
        if (null == this._defaultApplicationBundleId) {
            throw new IllegalStateException();
        }
        return this.getStringValue(KEY_APPLICATION_BUNDLE_ID, this._defaultApplicationBundleId);
    }

    public void setAppBundleId(String applicationBundleId) {
        this.setStringValue(KEY_APPLICATION_BUNDLE_ID, applicationBundleId);
    }

    public String getDefaultCharacterEncoding() {
        return DEFAULT_CHARACTER_ENCODING;
    }

    public String getCharacterEncoding() {
        return this.getStringValue(KEY_CHARACTER_ENCODING, DEFAULT_CHARACTER_ENCODING);
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.setStringValue(KEY_CHARACTER_ENCODING, characterEncoding);
    }

    public String getClassJdkVersionCompatibility() {
        return this.getStringValue(KEY_CLASS_JDK_VERSION_COMPATIBILITY, JavacOptions.getDefaultVersionCompatibility());
    }

    public void setClassJdkVersionCompatibility(String classJdkVersionCompatibilityVersion) {
        this.setStringValue(KEY_CLASS_JDK_VERSION_COMPATIBILITY, classJdkVersionCompatibilityVersion);
    }

    public String getJavaJdkVersionCompatibility() {
        return this.getStringValue(KEY_JAVA_JDK_VERSION_COMPATIBILITY, JavacOptions.getDefaultVersionCompatibility());
    }

    public void setJavaJdkVersionCompatibility(String javaJdkVersionCompatibilityVersion) {
        this.setStringValue(KEY_JAVA_JDK_VERSION_COMPATIBILITY, javaJdkVersionCompatibilityVersion);
    }

    public String getApplicationArchiveName() {
        if (null == this._defaultApplicationArchiveName) {
            throw new IllegalStateException();
        }
        return this.getStringValue(KEY_APP_ARCHIVE_NAME, this._defaultApplicationArchiveName);
    }

    public void setApplicationArchiveName(String appArchiveNameValue) {
        this.setStringValue(KEY_APP_ARCHIVE_NAME, appArchiveNameValue);
    }

    private void _initialize(Workspace workspace) {
        if (null != this._defaultApplicationBundleId && null != this._defaultApplicationArchiveName) {
            throw new IllegalStateException();
        }
        ApplicationBundleIdDefaultValueImpl defaultAppBundleId = new ApplicationBundleIdDefaultValueImpl(workspace);
        this._defaultApplicationBundleId = defaultAppBundleId.getDefaultValue();
        ApplicationArchiveNameDefaultValueImpl defaultAppArchiveName = new ApplicationArchiveNameDefaultValueImpl(workspace);
        this._defaultApplicationArchiveName = defaultAppArchiveName.getDefaultValue();
    }

    private void _copyToImpl(AndroidOptions target) {
        this._hash.copyTo(target._hash);
        target._defaultApplicationBundleId = this._defaultApplicationBundleId;
        target._defaultApplicationArchiveName = this._defaultApplicationArchiveName;
    }

    private boolean _equalsImpl(AndroidOptions otherAndroidOptions) {
        return ModelUtil.areEqual((Object)this._hash, (Object)otherAndroidOptions._hash) && ModelUtil.areEqual((Object)this._defaultApplicationArchiveName, (Object)otherAndroidOptions._defaultApplicationArchiveName) && ModelUtil.areEqual((Object)this._defaultApplicationBundleId, (Object)otherAndroidOptions._defaultApplicationBundleId);
    }

    private AndroidOptions(HashStructure hash) {
        this._hash = hash;
    }
}

