/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.ui.editor;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.AndroidProfile;
import oracle.adfmf.framework.dt.deploy.android.ui.editor.options.AndroidOptions;
import oracle.adfmf.framework.dt.deploy.android.ui.editor.panels.AndroidImagePanel;
import oracle.adfmf.framework.dt.deploy.android.ui.editor.panels.AndroidOptionsPanel;
import oracle.adfmf.framework.dt.deploy.editor.McArchiveEditor;
import oracle.adfmf.framework.dt.deploy.editor.options.ImageOptions;
import oracle.ide.Context;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.util.Namespace;

public class AndroidEditor
extends McArchiveEditor {
    private static final int ANDROID_EDITOR_ADDITIONAL_PIXEL_WIDTH = 37;

    public AndroidEditor(String title, AndroidProfile profile, Context context) {
        super(title, profile, context);
    }

    protected void initLauncher(TDialogLauncher launcher) {
        super.initLauncher(launcher);
        Dimension initialDimension = launcher.getInitialSize();
        Dimension newDimension = new Dimension((int)initialDimension.getWidth() + 37, (int)initialDimension.getHeight());
        launcher.setInitialSize(newDimension);
    }

    @Override
    protected Navigable[] getNavigables() {
        ArrayList<Navigable> newNavs = new ArrayList<Navigable>();
        newNavs.addAll(Arrays.asList(super.getNavigables()));
        Navigable[] iconOptionsNav = new Navigable[]{new Navigable(MobileResourceUtils.getText("APPLICATION_IMAGE"), AndroidImagePanel.class)};
        newNavs.add(new Navigable(MobileResourceUtils.getText("ANDROID_OPTIONS_PANEL_NAME"), AndroidOptionsPanel.class, iconOptionsNav));
        return this.convertToNavsArray(newNavs);
    }

    protected void scatterData(Namespace namespace) {
        super.scatterData(namespace);
        AndroidProfile androidProfile = AndroidProfile.newAndroidProfile(namespace);
        this.setAndroidOptions(androidProfile.getAndroidOptions(), namespace);
        AndroidEditor.setImageOptions(androidProfile.getImageOptions(), namespace);
    }

    protected void gatherData(Namespace namespace) {
        super.gatherData(namespace);
        AndroidProfile profile = AndroidProfile.newAndroidProfile(namespace);
        profile.setAndroidOptions(AndroidEditor.getAndroidOptions(namespace));
        profile.setImageOptions(AndroidEditor.getImageOptions(namespace));
    }

    private void setAndroidOptions(AndroidOptions androidOptions, Namespace data) {
        data.findAndReplace(AndroidOptions.getHashStructureKeyName(), (Object)androidOptions);
    }

    public static final AndroidOptions getAndroidOptions(Namespace data) {
        return AndroidOptions.newAndroidOptions(data);
    }

    public static final ImageOptions getImageOptions(Namespace data) {
        Object androidDataObject = data.find("mc-app-images");
        assert (null != androidDataObject && androidDataObject instanceof ImageOptions);
        return (ImageOptions)((Object)androidDataObject);
    }

    public static void setImageOptions(ImageOptions opts, Namespace data) {
        data.findAndReplace("mc-app-images", (Object)opts);
    }
}

