/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.deployers;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.AndroidProfile;
import oracle.adfmf.framework.dt.deploy.android.core.AndroidDeployer;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbDevicesCache;
import oracle.adfmf.framework.dt.deploy.android.deployers.AndroidDeployerFactory;
import oracle.adfmf.framework.dt.deploy.android.ui.editor.options.AndroidOptions;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.common.AbstractDeployer;
import oracle.jdeveloper.deploy.shell.ShellAdapter;

public class CheckAttachedDevicesDeployer
extends AbstractDeployer {
    private static final int _MAX_CONNECTED_DEVICES_OR_EMULATORS = 1;

    public CheckAttachedDevicesDeployer(int deploySequenceId) {
        super(deploySequenceId);
    }

    protected void deployImpl(int deploySequenceId, DeployShell deployShell) throws DeployException {
        Logger logger = deployShell.getLogger();
        AndroidProfile androidProfile = AndroidDeployUtil.getAndroidProfile(deployShell);
        AndroidOptions androidOptions = androidProfile.getAndroidOptions();
        ShellAdapter shellAdapter = ShellAdapter.getInstance((DeployShell)deployShell);
        boolean isEmulatorInstall = shellAdapter.isDeploying(AndroidDeployerFactory.getEmulatorDeploymentSequenceId());
        if (isEmulatorInstall) {
            this._checkAttachedAndroidEmulators(logger, androidOptions);
            List<String> cpuInfoList = AndroidDeployer.getEmulatorCpuInfo(androidOptions, logger);
            this._validateArmVersion(cpuInfoList, logger, "ADF-MBL-11500", "ADF-MBL-01608");
        } else {
            this._checkAttachedAndroidDevices(logger, androidOptions);
            List<String> cpuInfoList = AndroidDeployer.getDeviceCpuInfo(androidOptions, logger);
            this._validateArmVersion(cpuInfoList, logger, "ADF-MBL-11501", "ADF-MBL-01609");
        }
    }

    private void _checkAttachedAndroidEmulators(Logger logger, AndroidOptions androidOptions) throws DeployException {
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-21514"));
        AdbDevicesCache deviceCache = AndroidDeployer.getAndroidDevicesStatus(androidOptions, logger);
        this._validateDevicesOrEmulatorsCount(true, deviceCache);
    }

    private void _checkAttachedAndroidDevices(Logger logger, AndroidOptions androidOptions) throws DeployException {
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-21513"));
        AdbDevicesCache deviceCache = AndroidDeployer.getAndroidDevicesStatus(androidOptions, logger);
        this._validateDevicesOrEmulatorsCount(false, deviceCache);
    }

    private void _validateDevicesOrEmulatorsCount(boolean isEmulatorDeploy, AdbDevicesCache deviceCache) throws DeployException {
        int attachedCount = 0;
        int offlineCount = 0;
        String tooManyAttachedMsgId = "ADF-MBL-01605";
        String noAttachedMsgId = "ADF-MBL-01606";
        String offlineMsgId = "ADF-MBL-01610";
        if (isEmulatorDeploy) {
            attachedCount = deviceCache.getAttachedEmulatorCount();
            offlineCount = deviceCache.getOfflineEmulatorCount();
        } else {
            attachedCount = deviceCache.getAttachedDeviceCount();
            offlineCount = deviceCache.getOfflineDeviceCount();
            tooManyAttachedMsgId = "ADF-MBL-01604";
            noAttachedMsgId = "ADF-MBL-01603";
            offlineMsgId = "ADF-MBL-01611";
        }
        if (attachedCount != 1) {
            String errMsgId = "";
            if (attachedCount > 1) {
                errMsgId = tooManyAttachedMsgId;
            } else {
                errMsgId = noAttachedMsgId;
                if (offlineCount > 0) {
                    errMsgId = offlineMsgId;
                }
            }
            assert (ModelUtil.hasLength((String)errMsgId));
            throw new DeployException(MobileResourceUtils.getMsg(errMsgId, deviceCache.getAdbDevicesStatus()));
        }
    }

    private void _validateArmVersion(List<String> cpuInfoList, Logger logger, String noArmVersionResId, String invalidArmVersionResId) throws DeployException {
        String CPU_ARCHITECTURE = "CPU architecture";
        int MIN_ARM_VERSION = 6;
        boolean UNKNOWN_ARM_VERSION = false;
        if (cpuInfoList.isEmpty()) {
            logger.warning(MobileResourceUtils.getMsg(noArmVersionResId));
        } else {
            int cpuVersion = 0;
            for (String currLine : cpuInfoList) {
                String cpuArchValue;
                String[] currLineParts;
                if (!currLine.startsWith("CPU architecture") || null == (currLineParts = currLine.split(":")) || 1 >= currLineParts.length || 1 > (cpuArchValue = currLineParts[1].trim()).length()) continue;
                String LEADING_INT_REGEX = "\\d+";
                Pattern leadingIntPattern = Pattern.compile("\\d+");
                Matcher findMatcher = leadingIntPattern.matcher(cpuArchValue);
                if (!findMatcher.find()) continue;
                String armVersionAsString = findMatcher.group();
                cpuVersion = Integer.valueOf(armVersionAsString, 10);
                break;
            }
            if (cpuVersion <= 0) {
                logger.warning(MobileResourceUtils.getMsg(noArmVersionResId));
            } else if (cpuVersion < 6) {
                if (logger.isLoggable(Level.FINEST)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Invalid ARM version.  The following is the CPU information: ");
                    sb.append("\n");
                    for (String currLine : cpuInfoList) {
                        sb.append(currLine);
                        sb.append("\n");
                    }
                    logger.finest(sb.toString());
                }
                throw new DeployException(MobileResourceUtils.getMsg(invalidArmVersionResId, cpuVersion));
            }
        }
    }
}

