/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.deployers;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.android.AndroidProfile;
import oracle.adfmf.framework.dt.deploy.android.ui.editor.options.AndroidOptions;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibraryManager;

public class AndroidFileUtils
extends DeployFileUtils {
    private static final int DEFAULT_STRING_BUILDER_LEN = 256;
    private static final String ALIGNED_APK_FILE_NAME = "aligned_apk.apk";
    private static final String FRAMEWORK_ANDROID_MANIFEST_TEMPLATE_FILE_NAME = "AndroidManifest.template.xml";
    public static final String FRAMEWORK_ANDROID_GCM_INTENT_SERVICE_JAVA_FILE_NAME = "GCMIntentService.java";
    private static final String FRAMEWORK_TEMPLATE_DIRECTORY_NAME = "template";
    private static final String FRAMEWORK_BUILD_DIRECTORY_NAME = "build";
    private static final String APPLICATION_PREFERENCES_XML_RELATIVE_PATH = "xml/preferences.xml";
    private static final String CONFIG_XML_RELATIVE_PATH = "xml/config.xml";
    private static final String APPLICATION_DEFAULT_STRINGS_XML_RELATIVE_PATH = "values/strings.xml";
    private static final String APPLICATION_DEFAULT_ARRAYS_XML_RELATIVE_PATH = "values/arrays.xml";
    private static final String FRAMEWORK_BUILD_JAR_RELATIVE_PATH = "build/jar";
    private static final String LIBS_DIR = "libs";
    private static final String LIB_DIR = "lib";
    private static final String ARMEABI_DIR = "armeabi";
    private static final String DRAWABLE_DIR = "drawable";
    private static final String FRAMEWORK_JAVA_RES_RELATIVE_PATH = "build/java_res";
    private static final String FRAMEWORK_JAVA_RES_DEBUG_RELATIVE_PATH = "build/java_res_debug";
    private static final String FRAMEWORK_JAVA_RES_RELEASE_RELATIVE_PATH = "build/java_res_release";
    private static final String LIBCVM_SO_FILE_NAME = "libcvm.so";
    private static final String VM_CHANNEL_JAR_FILE_NAME = "vmchannel.jar";
    private static final String FRAMEWORK_RES_RELATIVE_PATH = "build/res";
    private static final String FRAMEWORK_TEMPLATE_ANDROID_ROOT_ENTRY_NAME = "framework/Android";
    private static final String APK_FILE_EXTENSION = ".apk";
    private static final String PREFERENCES_XML_FILENAME = "preferences.xml";
    private static final String FRAMEWORK_ZIP_FILE_NAME = "Oracle_ADFmf_Framework.zip";
    private static final String ANDROID_MANIFEST_FILE_NAME = "AndroidManifest.xml";
    private static final String ANDROID_JAR_FILE_NAME = "android.jar";
    private static final String ANDROID_DIR_NAME = "Android";
    private static final String APPLICATION_DEFAULT_RESOURCE_RELATIVE_PATH = "resources/android";
    private static final String ASSETS_DIR_NAME = "assets";
    private static final String JVM_LIB_RELATIVE_URL = "assets/storage/jvm/lib";
    private static final String DEPLOY_FRAMEWORK_DIR_NAME = "framework";
    private static final String JAVA_RES_DIR_NAME = "java_res";
    private static final String DEX_CLASSES_FILE_NAME = "classes.dex";
    private static final String ANDROID_PREFERENCE_TRANFORM_JAR_ENTRY_PATH = "oracle/adfmf/framework/dt/deploy/android/preferences/androidtransform.xsl";
    private static final String ANDROID_PREFERENCE_XML_SCHEMA_ENTRY_PATH = "oracle/adfmf/framework/dt/deploy/android/preferences/androidpreferences.xsd";
    private final AndroidOptions m_androidOptions;
    private URL m_applicationResourceOutputUrl;
    private URL m_androidApplicationURL;
    private URL m_androidDalvikByteCodeURL;
    private URL m_debugKeystoreFileURL;
    private URL m_javaSourceURL;
    private URL m_androidManifestXmlURL;
    private URL m_jdkBinFolderURL;
    private URL m_androidFolderURL;
    private URL m_alignedAppURL;
    private URL m_classFileURL;
    private URL m_androidFrameworkOutputURL;
    private URL m_frameworkJavaResourceOutputUrl;
    private URL m_androidManifestTemplateXmlURL;
    private URL m_applicationRawFilesURL;
    private URL m_frameworkResourceOutputURL;
    private URL m_applicationFeatureURL;
    private URL m_applicationAssetURL;
    private URL m_webContentURL;
    private URL m_resourceRootUrl;
    private String m_applicationPackageName;
    private URL m_applicationCvmLibsUrl;
    private URL m_applicationCvmLibUrl;
    private URL m_deploymentAdfFolderUrl;

    public AndroidFileUtils(Workspace workspace, AndroidProfile androidProfile) throws DeployException {
        super(workspace, androidProfile);
        this.m_androidOptions = androidProfile.getAndroidOptions();
    }

    @Override
    public boolean doesTemplateExist() {
        ArrayList<URL> requiredDirOrFileUrlList = new ArrayList<URL>();
        requiredDirOrFileUrlList.add(this.getFrameworkBuildRootDirectoryUrl());
        requiredDirOrFileUrlList.add(this.getFrameworkManifestTemplateXmlURL());
        requiredDirOrFileUrlList.add(this.getFrameworkGCMIntentServiceJavaUrl());
        requiredDirOrFileUrlList.add(this.getFrameworkConfigXmlUrl());
        return this._verifyFilesOrDirectoriesExists(requiredDirOrFileUrlList);
    }

    public boolean doesTemplateResourcesExist() {
        ArrayList<URL> requiredDirOrFileUrlList = new ArrayList<URL>();
        requiredDirOrFileUrlList.add(this.getApplicationDrawableDirUrl());
        requiredDirOrFileUrlList.add(this.getApplicationConfigXmlUrl());
        return this._verifyFilesOrDirectoriesExists(requiredDirOrFileUrlList);
    }

    public boolean doesTemplateJavaResourcesExist() {
        ArrayList<URL> requiredDirOrFileUrlList = new ArrayList<URL>();
        requiredDirOrFileUrlList.add(this.getApplicationCvmLibURL());
        requiredDirOrFileUrlList.add(this.getApplicationAssetsOutputURL());
        return this._verifyFilesOrDirectoriesExists(requiredDirOrFileUrlList);
    }

    public URL getAndroidApplicationURL() {
        if (null == this.m_androidApplicationURL) {
            StringBuilder sb = new StringBuilder(256);
            sb.append(this.m_androidOptions.getApplicationArchiveName());
            sb.append(APK_FILE_EXTENSION);
            this.m_androidApplicationURL = this.getOutputFilePath(sb.toString());
        }
        return this.m_androidApplicationURL;
    }

    public URL getAndroidDalvikByteCodeURL() {
        if (null == this.m_androidDalvikByteCodeURL) {
            StringBuilder sb = new StringBuilder(256);
            sb.append(DEX_CLASSES_FILE_NAME);
            this.m_androidDalvikByteCodeURL = this.getOutputFilePath(sb.toString());
        }
        return this.m_androidDalvikByteCodeURL;
    }

    public URL getDebugKeyStoreFileURL(String keyStoreFileName) {
        if (null == this.m_debugKeystoreFileURL) {
            this.m_debugKeystoreFileURL = URLFactory.newDirURL((URL)this.getOutputDirectoryURL(), (String)keyStoreFileName);
        }
        return this.m_debugKeystoreFileURL;
    }

    public URL getJavaSourceURL() {
        if (null == this.m_javaSourceURL) {
            this.m_javaSourceURL = URLFactory.newDirURL((URL)this.getOutputDirectoryURL(), (String)"src");
        }
        return this.m_javaSourceURL;
    }

    public URL getAndroidRClassFileUrl() {
        if (null == this.m_classFileURL) {
            this.m_classFileURL = URLFactory.newDirURL((URL)this.getOutputDirectoryURL(), (String)"classes");
        }
        return this.m_classFileURL;
    }

    public URL getApplicationResourceOutputURL() {
        if (null == this.m_applicationResourceOutputUrl) {
            this.m_applicationResourceOutputUrl = URLFactory.newDirURL((URL)this.getOutputDirectoryURL(), (String)"res");
        }
        return this.m_applicationResourceOutputUrl;
    }

    public URL getAndroidManifestXmlURL() {
        if (null == this.m_androidManifestXmlURL) {
            this.m_androidManifestXmlURL = URLFactory.newDirURL((URL)this.getOutputDirectoryURL(), (String)ANDROID_MANIFEST_FILE_NAME);
        }
        return this.m_androidManifestXmlURL;
    }

    public URL getFrameworkManifestTemplateXmlURL() {
        if (null == this.m_androidManifestTemplateXmlURL) {
            URL templateRootDirUrl = this.getFrameworkTemplateRootDirectoryUrl();
            this.m_androidManifestTemplateXmlURL = URLFactory.newDirURL((URL)templateRootDirUrl, (String)FRAMEWORK_ANDROID_MANIFEST_TEMPLATE_FILE_NAME);
        }
        return this.m_androidManifestTemplateXmlURL;
    }

    public String getFrameworkGcmIntentServiceJavaFileName() {
        return FRAMEWORK_ANDROID_GCM_INTENT_SERVICE_JAVA_FILE_NAME;
    }

    public URL getFrameworkBuildRootDirectoryUrl() {
        return URLFactory.newDirURL((URL)this.getAndroidFrameworkOutputURL(), (String)FRAMEWORK_BUILD_DIRECTORY_NAME);
    }

    public URL getFrameworkTemplateRootDirectoryUrl() {
        return URLFactory.newDirURL((URL)this.getAndroidFrameworkOutputURL(), (String)FRAMEWORK_TEMPLATE_DIRECTORY_NAME);
    }

    public URL getFrameworkGCMIntentServiceJavaUrl() {
        return URLFactory.newDirURL((URL)this.getFrameworkTemplateRootDirectoryUrl(), (String)this.getFrameworkGcmIntentServiceJavaFileName());
    }

    public URL getAndroidGcmJarUrl() throws DeployException {
        String GCM_JAR_RELATIVE_PATH = "extras/google/gcm/gcm-client/dist/gcm.jar";
        String androidSdkPath = AndroidDeployUtil.getAndroidSdkPath();
        URL androidSdkUrl = URLFactory.newDirURL((String)androidSdkPath);
        return URLFactory.newURL((URL)androidSdkUrl, (String)"extras/google/gcm/gcm-client/dist/gcm.jar");
    }

    public URL getDeployGCMIntentServiceJavaUrl(String relativePath) {
        URL parentFolderUrl = URLFactory.newDirURL((URL)this.getJavaSourceURL(), (String)relativePath);
        return URLFactory.newDirURL((URL)parentFolderUrl, (String)this.getFrameworkGcmIntentServiceJavaFileName());
    }

    public URL getJDKBinURL() throws DeployException {
        if (null == this.m_jdkBinFolderURL) {
            URL jdkBinUrl;
            String jdkBinDir = null;
            JDK jdk = JLibraryManager.getDefaultJDK();
            if (null != jdk && null != (jdkBinUrl = jdk.getSDKBinDir())) {
                jdkBinDir = jdkBinUrl.getFile();
            }
            if (!ModelUtil.hasLength(jdkBinDir)) {
                throw new DeployException("Failed to locate the JDK bin directory.");
            }
            this.m_jdkBinFolderURL = URLFactory.newDirURL((String)this.getPlatformDependentDirectoryPath(jdkBinDir));
        }
        return this.m_jdkBinFolderURL;
    }

    public String getApplicationPackageName(AndroidOptions androidOptions) {
        if (null == this.m_applicationPackageName) {
            this.m_applicationPackageName = androidOptions.getAppBundleId();
        }
        return this.m_applicationPackageName;
    }

    public URL getAndroidPlatformJarURL() throws DeployException {
        if (null == this.m_androidFolderURL) {
            this.m_androidFolderURL = FileUtils.newFileUrl(URLFactory.newDirURL((String)AndroidDeployUtil.getAndroidPlatformPath()), ANDROID_JAR_FILE_NAME);
        }
        return this.m_androidFolderURL;
    }

    private String getPlatformDependentDirectoryPath(String directoryPath) {
        return URLFileSystem.getPlatformPathName((URL)URLFactory.newDirURL((String)directoryPath));
    }

    private URL getOutputFilePath(String filePath) {
        URL outputDir = this.getOutputDirectoryURL();
        return URLFactory.newDirURL((URL)outputDir, (String)filePath);
    }

    public URL getAndroidAlignedApplicationURL() {
        if (null == this.m_alignedAppURL) {
            this.m_alignedAppURL = this.getOutputFilePath(ALIGNED_APK_FILE_NAME);
        }
        return this.m_alignedAppURL;
    }

    public URL getAndroidPreferenceXslURL() {
        return this.getAdfmfJarEntryUrl(ANDROID_PREFERENCE_TRANFORM_JAR_ENTRY_PATH);
    }

    public URL getAndroidPreferenceXsdURL() {
        return this.getAdfmfJarEntryUrl(ANDROID_PREFERENCE_XML_SCHEMA_ENTRY_PATH);
    }

    @Override
    public URL getDeploymentAdfmfApplicationXmlFileUrl() {
        URL adfConfigUrl = URLFactory.newDirURL((URL)this.getApplicationJavaResourceURL(), (String)"Configuration");
        return FileUtils.newFileUrl(adfConfigUrl, "adfmf-application.xml");
    }

    @Override
    public URL getDeploymentCacertsFileUrl() {
        URL appJavaResDirectory = this.getApplicationJavaResourceURL();
        URL securityDirectory = URLFactory.newDirURL((URL)this._getJvmLibDirUrl(appJavaResDirectory), (String)"security");
        return FileUtils.newFileUrl(securityDirectory, "cacerts");
    }

    @Override
    public URL getDeploymentAdfmfFeatureXmlFileUrl() {
        URL adfConfigUrl = URLFactory.newDirURL((URL)this.getApplicationJavaResourceURL(), (String)"Configuration");
        return FileUtils.newFileUrl(adfConfigUrl, ADFMobileConstants.FEATURE_XML_FILENAME);
    }

    @Override
    public URL getDeploymentAdfmfConfigURL() {
        URL adfConfigUrl = URLFactory.newDirURL((URL)this.getApplicationJavaResourceURL(), (String)"Configuration");
        return URLFactory.newDirURL((URL)adfConfigUrl, (String)"adfmf-config.xml");
    }

    @Override
    public URL getDeploymentFARsURL() {
        URL applicationAssestsOutputURL = this.getApplicationAssetsOutputURL();
        return URLFactory.newDirURL((URL)applicationAssestsOutputURL, (String)"FARs");
    }

    public URL getAndroidPreferenceXmlURL() {
        URL rootFolderURL = this.getApplicationResourceOutputURL();
        URL xmlFolderURL = URLFactory.newDirURL((URL)rootFolderURL, (String)"xml");
        return URLFactory.newDirURL((URL)xmlFolderURL, (String)PREFERENCES_XML_FILENAME);
    }

    public URL getAndroidFrameworkURL() {
        URL androidFrameworkTemplateDirURL = URLFactory.newURL((URL)FileUtils.getSupportFilesDirectoryUrl(), (String)ANDROID_DIR_NAME);
        URL frameworkZipURL = URLFactory.newURL((URL)androidFrameworkTemplateDirURL, (String)FRAMEWORK_ZIP_FILE_NAME);
        URL frameworkFileJarURL = URLFactory.newJarURL((URL)frameworkZipURL, null);
        return URLFactory.newJarURL((URL)frameworkFileJarURL, (String)FRAMEWORK_TEMPLATE_ANDROID_ROOT_ENTRY_NAME);
    }

    public URL getAndroidFrameworkOutputURL() {
        if (null == this.m_androidFrameworkOutputURL) {
            this.m_androidFrameworkOutputURL = URLFactory.newDirURL((URL)this.getOutputDirectoryURL(), (String)DEPLOY_FRAMEWORK_DIR_NAME);
        }
        return this.m_androidFrameworkOutputURL;
    }

    public URL getApplicationFeatureURL() {
        if (null == this.m_applicationFeatureURL) {
            URL projectURL = this.getProject().getURL();
            URL parentURL = URLFileSystem.getParent((URL)projectURL);
            this.m_applicationFeatureURL = URLFactory.newDirURL((URL)parentURL, (String)"public_html");
        }
        return this.m_applicationFeatureURL;
    }

    public URL getApplicationAssetsOutputURL() {
        if (null == this.m_applicationAssetURL) {
            this.m_applicationAssetURL = URLFactory.newDirURL((URL)this.getApplicationJavaResourceURL(), (String)ASSETS_DIR_NAME);
        }
        return this.m_applicationAssetURL;
    }

    @Override
    public final URL getFarsExtractionParentFolderUrl() {
        return this.getApplicationAssetsOutputURL();
    }

    @Override
    public URL getApplicationWebContentURL() {
        if (null == this.m_webContentURL) {
            this.m_webContentURL = URLFactory.newDirURL((URL)this.getApplicationAssetsOutputURL(), (String)"www");
        }
        return this.m_webContentURL;
    }

    public URL getFrameworkJavaResourcesOutputURL() {
        if (null == this.m_frameworkJavaResourceOutputUrl) {
            this.m_frameworkJavaResourceOutputUrl = URLFactory.newDirURL((URL)this.getAndroidFrameworkOutputURL(), (String)FRAMEWORK_JAVA_RES_RELATIVE_PATH);
        }
        return this.m_frameworkJavaResourceOutputUrl;
    }

    public URL getDeployTypeFrameworkJavaResourcesOutputUrl() {
        return URLFactory.newDirURL((URL)this.getAndroidFrameworkOutputURL(), (String)(this.isDebugMode() ? FRAMEWORK_JAVA_RES_DEBUG_RELATIVE_PATH : FRAMEWORK_JAVA_RES_RELEASE_RELATIVE_PATH));
    }

    public URL getApplicationJavaResourceURL() {
        if (null == this.m_applicationRawFilesURL) {
            this.m_applicationRawFilesURL = URLFactory.newDirURL((URL)this.getOutputDirectoryURL(), (String)JAVA_RES_DIR_NAME);
        }
        return this.m_applicationRawFilesURL;
    }

    public List<String> getFrameworkJarFilePaths() {
        URL jarFolder = URLFactory.newDirURL((URL)this.getAndroidFrameworkOutputURL(), (String)FRAMEWORK_BUILD_JAR_RELATIVE_PATH);
        URL[] frameworkJarArray = URLFileSystem.list((URL)jarFolder);
        ArrayList<String> frameworkJarPathList = new ArrayList<String>();
        for (int i = 0; i < frameworkJarArray.length; ++i) {
            String currExt;
            assert (!URLFileSystem.isDirectoryPath((URL)frameworkJarArray[i]));
            String currPath = URLFileSystem.getPlatformPathName((URL)frameworkJarArray[i]);
            if (!ModelUtil.hasLength((String)currPath) || !ModelUtil.hasLength((String)(currExt = FileUtils.getFileExtension(currPath))) || !currExt.equalsIgnoreCase(".jar")) continue;
            frameworkJarPathList.add(URLFileSystem.getPlatformPathName((URL)frameworkJarArray[i]));
        }
        return frameworkJarPathList;
    }

    public URL getFrameworkResourceOutputURL() {
        if (null == this.m_frameworkResourceOutputURL) {
            this.m_frameworkResourceOutputURL = URLFactory.newDirURL((URL)this.getAndroidFrameworkOutputURL(), (String)FRAMEWORK_RES_RELATIVE_PATH);
        }
        return this.m_frameworkResourceOutputURL;
    }

    public URL getApplicationDefaultResourceFolderURL() {
        if (null == this.m_resourceRootUrl) {
            this.m_resourceRootUrl = URLFactory.newDirURL((URL)McAppUtils.getAppRootURL(this.getWorkspace()), (String)AndroidFileUtils.getApplicationDefaultResourceRelativePath());
        }
        return this.m_resourceRootUrl;
    }

    public static String getApplicationDefaultResourceRelativePath() {
        return APPLICATION_DEFAULT_RESOURCE_RELATIVE_PATH;
    }

    public URL getJvmLibUrl() {
        URL applicationJavaResFolder = this.getApplicationJavaResourceURL();
        URL libFolder = this._getJvmLibDirUrl(applicationJavaResFolder);
        return libFolder;
    }

    public URL getLoggingPropertiesUrl() {
        return this.getJvmLibUrl();
    }

    public URL getApplicationCvmLibsURL() {
        if (null == this.m_applicationCvmLibsUrl) {
            this.m_applicationCvmLibsUrl = URLFactory.newDirURL((URL)this.getApplicationJavaResourceURL(), (String)LIBS_DIR);
        }
        return this.m_applicationCvmLibsUrl;
    }

    public URL getApplicationCvmLibURL() {
        if (null == this.m_applicationCvmLibUrl) {
            this.m_applicationCvmLibUrl = URLFactory.newDirURL((URL)this.getApplicationJavaResourceURL(), (String)LIB_DIR);
        }
        return this.m_applicationCvmLibUrl;
    }

    public String getDalvikFileName() {
        return DEX_CLASSES_FILE_NAME;
    }

    public URL getAdfOutputFolderUrl() {
        URL adfSourceDirectoryUrl;
        if (null == this.m_deploymentAdfFolderUrl && null != (adfSourceDirectoryUrl = this.getApplicationAdfFolderUrl())) {
            String adfSourceDirectoryPath = URLFileSystem.getPlatformPathName((URL)adfSourceDirectoryUrl);
            String adfFolderName = URLFileSystem.getSuffix((URL)URLFactory.newURL((String)adfSourceDirectoryPath));
            this.m_deploymentAdfFolderUrl = URLFactory.newDirURL((URL)this.getOutputDirectoryURL(), (String)adfFolderName);
        }
        return this.m_deploymentAdfFolderUrl;
    }

    @Override
    public boolean isDebugMode() {
        return this.m_androidOptions.getIsDebugMode();
    }

    @Override
    public URL getPlatformSpecificJavaScriptSourceZipURL() {
        URL zipFileUrl = null;
        URL supportFilesDirectoryURL = FileUtils.getSupportFilesDirectoryUrl();
        URL javascriptSrcDir = URLFactory.newDirURL((URL)supportFilesDirectoryURL, (String)"javascript");
        URL javascriptAndroidSrcDir = URLFactory.newDirURL((URL)javascriptSrcDir, (String)ANDROID_DIR_NAME);
        zipFileUrl = this.isDebugMode() ? URLFactory.newDirURL((URL)javascriptAndroidSrcDir, (String)"ADFmf_AmxJavascript_debug_Android.zip") : URLFactory.newDirURL((URL)javascriptAndroidSrcDir, (String)"ADFmf_AmxJavascript_release_Android.zip");
        return URLFactory.newJarURL((URL)zipFileUrl, null);
    }

    private URL _getLibCvmFileUrl(URL parentLibFolder) {
        URL armeabiDirUrl = URLFactory.newDirURL((URL)parentLibFolder, (String)ARMEABI_DIR);
        return FileUtils.newFileUrl(armeabiDirUrl, LIBCVM_SO_FILE_NAME);
    }

    public URL getApplicationLibCvmFileUrl() {
        return this._getLibCvmFileUrl(this.getApplicationCvmLibURL());
    }

    public URL getDeployTypeFrameworkLibCvmFileUrl() {
        URL javaResUrl = this.getDeployTypeFrameworkJavaResourcesOutputUrl();
        URL javaResLibsUrl = URLFactory.newDirURL((URL)javaResUrl, (String)LIBS_DIR);
        return this._getLibCvmFileUrl(javaResLibsUrl);
    }

    @Override
    public void copyPlatformSpecificSecurityFiles() throws IOException {
        URL appCacertsFileUrl = this.getCacertsFileUrl();
        if (URLFileSystem.exists((URL)appCacertsFileUrl)) {
            URL javaResParentFolder = this.getDeployTypeFrameworkJavaResourcesOutputUrl();
            URL securityDirectory = URLFactory.newDirURL((URL)this._getJvmLibDirUrl(javaResParentFolder), (String)"security");
            URL destinationCacertsFileUrl = URLFactory.newURL((URL)securityDirectory, (String)"cacerts");
            URLFileSystem.copy((URL)appCacertsFileUrl, (URL)destinationCacertsFileUrl);
        }
    }

    private URL _getVmChannelFileUrl(URL javaResParentFolder) {
        URL libDirUrl = this._getJvmLibDirUrl(javaResParentFolder);
        return FileUtils.newFileUrl(libDirUrl, VM_CHANNEL_JAR_FILE_NAME);
    }

    public URL getDeployTypeFrameworkVmChannelFileUrl() {
        return this._getVmChannelFileUrl(this.getDeployTypeFrameworkJavaResourcesOutputUrl());
    }

    public URL getApplicationsVmChannelFileUrl() {
        return this._getVmChannelFileUrl(this.getApplicationJavaResourceURL());
    }

    public URL getApplicationPreferencesXmlUrl() {
        return URLFactory.newURL((URL)this.getApplicationResourceOutputURL(), (String)APPLICATION_PREFERENCES_XML_RELATIVE_PATH);
    }

    public URL getDefaultStringsXmlFileUrl() {
        return URLFactory.newURL((URL)this.getApplicationResourceOutputURL(), (String)APPLICATION_DEFAULT_STRINGS_XML_RELATIVE_PATH);
    }

    public URL getDefaultArraysXmlFileUrl() {
        return URLFactory.newURL((URL)this.getApplicationResourceOutputURL(), (String)APPLICATION_DEFAULT_ARRAYS_XML_RELATIVE_PATH);
    }

    public URL getApplicationDrawableDirUrl() {
        return URLFactory.newDirURL((URL)this.getApplicationResourceOutputURL(), (String)DRAWABLE_DIR);
    }

    public URL getApplicationConfigXmlUrl() {
        return URLFactory.newURL((URL)this.getApplicationResourceOutputURL(), (String)CONFIG_XML_RELATIVE_PATH);
    }

    public URL getFrameworkConfigXmlUrl() {
        return URLFactory.newURL((URL)this.getFrameworkResourceOutputURL(), (String)CONFIG_XML_RELATIVE_PATH);
    }

    public URL getFrameworkTemplateConfigXmlUrl() {
        URL frameworkUrl = this.getAndroidFrameworkURL();
        URL buildResUrl = URLFactory.newJarURL((URL)frameworkUrl, (String)FRAMEWORK_RES_RELATIVE_PATH);
        URL configXmlUrl = URLFactory.newJarURL((URL)buildResUrl, (String)CONFIG_XML_RELATIVE_PATH);
        return configXmlUrl;
    }

    private URL _getJvmLibDirUrl(URL javaResParentFolder) {
        return URLFactory.newDirURL((URL)javaResParentFolder, (String)JVM_LIB_RELATIVE_URL);
    }

    private boolean _verifyFilesOrDirectoriesExists(List<URL> dirOrFileUrlList) {
        for (URL currUrl : dirOrFileUrlList) {
            if (URLFileSystem.exists((URL)currUrl)) continue;
            return false;
        }
        return true;
    }
}

