/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.deployers;

import java.util.logging.Logger;
import oracle.adfmf.framework.dt.deploy.android.AndroidProfile;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbServerManager;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.adfmf.framework.dt.deploy.common.deployers.AbstractDeployerWrapper;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;

public class AndroidDeployerWrapper
extends AbstractDeployerWrapper {
    private AndroidDeployerWrapper(int deploySequenceId, Logger logger, Deployer deployer) {
        super(deploySequenceId, logger, deployer);
    }

    public static AndroidDeployerWrapper newInstance(int deploySequenceId, Logger logger, Deployer deployer) {
        if (!AndroidDeployerWrapper.isDeployerWrappable(deployer)) {
            throw new IllegalArgumentException();
        }
        return new AndroidDeployerWrapper(deploySequenceId, logger, deployer);
    }

    @Override
    public void deploy(int deploySequenceId, DeployShell deployShell) throws DeployException {
        try {
            super.deploy(deploySequenceId, deployShell);
        }
        catch (Exception e) {
            AndroidProfile androidProfile = AndroidDeployUtil.getAndroidProfile(deployShell);
            AdbServerManager.getInstance().stop(androidProfile.getAndroidOptions(), deployShell.getLogger(), true);
            if (e instanceof DeployException) {
                throw (DeployException)((Object)e);
            }
            throw new DeployException((Throwable)e);
        }
    }
}

