/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.deployers;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.adfmf.framework.dt.deploy.android.AndroidProfile;
import oracle.adfmf.framework.dt.deploy.android.deployers.AaptDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.AndroidArchiveDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.AndroidDeployerWrapper;
import oracle.adfmf.framework.dt.deploy.android.deployers.AndroidFileUtils;
import oracle.adfmf.framework.dt.deploy.android.deployers.AndroidJavaCompilerDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.ApkDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.CheckAttachedDevicesDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.CopyAdfDirectoryDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.CopyAdfMobileXmlFilesDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.CopyAndroidTemplateDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.CopyApplicationImagesDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.CopyCvmAndLoggingPropertiesFileDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.CopyFrameworkJavaResourcesDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.CopyFrameworkResourcesDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.CreateGCMIntentServiceJavaFileDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.DeviceDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.DexDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.EmulatorDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.ManifestUpdateDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.MaybeShutdownAdbServerDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.MaybeStartupAdbServerDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.PreparePackagingDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.SignDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.TransformAdfMobileXmlFilesDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.ValidatePreferencesDeployer;
import oracle.adfmf.framework.dt.deploy.android.deployers.ZipAlignDeployer;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.adfmf.framework.dt.deploy.common.deployers.AbstractDeployerWrapper;
import oracle.adfmf.framework.dt.deploy.common.deployers.ApplicationValidatorDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.ApplicationXmlValidatorDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.CustomizeContentDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.DebugPerfBannerDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.FarExtractorDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.JavaScriptDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.ProjectValidatorDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.ProjectXmlValidatorDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.SecurityDeployer;
import oracle.adfmf.framework.dt.deploy.common.deployers.SkinsDeployer;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.common.BatchDeployer;
import oracle.jdeveloper.deploy.common.BuildDeployer;
import oracle.jdeveloper.deploy.common.DynamicDeployer;
import oracle.jdeveloper.deploy.common.ModulePackager;
import oracle.jdeveloper.deploy.jar.JarDeployerFactory;
import oracle.jdevimpl.deploy.common.ProfileDependencyAnalyzer;

public class AndroidDeployerFactory
implements DeployerFactory {
    public Deployer newDeployer(int deploySequenceId, DeployShell deployShell) {
        if (!AndroidDeployerSequenceId.contains(deploySequenceId)) {
            return null;
        }
        AndroidDeployerSequenceId androidId = AndroidDeployerSequenceId.fromInt(deploySequenceId);
        Object newDeployer = null;
        switch (androidId) {
            case ANDROID_PACKAGING_SEQUENCE_ID: {
                newDeployer = this._createPackagingBatchDeployer(deployShell);
                break;
            }
            case ANDROID_DEPENDENCY_ANALYZER_ID: {
                newDeployer = new ProfileDependencyAnalyzer(deploySequenceId, deployShell);
                break;
            }
            case ANDROID_BUILD_DEPLOYER_ID: {
                newDeployer = new BuildDeployer(deploySequenceId, deployShell);
                break;
            }
            case ANDROID_MODULE_PACKAGER_ID: {
                newDeployer = new ModulePackager(deploySequenceId, deployShell);
                break;
            }
            case ANDROID_MAYBE_START_ADB_SERVER_ID: {
                newDeployer = new MaybeStartupAdbServerDeployer(deploySequenceId);
                break;
            }
            case ANDROID_CHECK_ATTACHED_DEVICES_ID: {
                newDeployer = new CheckAttachedDevicesDeployer(deploySequenceId);
                break;
            }
            case ANDROID_MAYBE_SHUTDOWN_ADB_SERVER_ID: {
                newDeployer = new MaybeShutdownAdbServerDeployer(deploySequenceId);
                break;
            }
            case ANDROID_MAYBE_SHOW_DEBUG_PERFORMANCE_WARNING_DEPLOYER_ID: {
                AndroidFileUtils af = this._getFileUtils(deployShell);
                if (null == af) break;
                newDeployer = new DebugPerfBannerDeployer(deploySequenceId, af.isDebugMode());
                break;
            }
            case ANDROID_VALIDATE_PREFERENCES_FOR_PACKAGE_DEPLOYER_ID: 
            case ANDROID_VALIDATE_PREFERENCES_DEPLOYER_ID: {
                newDeployer = new ValidatePreferencesDeployer(deploySequenceId);
                break;
            }
            case ANDROID_PRE_PACKAGING_DEPLOYER_ID: {
                newDeployer = this._createPrePackagingBatchDeployer();
                break;
            }
            case ANDROID_COMMON_PACKAGE_BATCH_DEPLOYER_ID: {
                newDeployer = this._createCommonPackageBatchDeployer();
                break;
            }
            case ANDROID_PACKAGE_BATCH_DEPLOYER_ID: {
                newDeployer = this._createPackageBatchDeployer();
                break;
            }
            case ANDROID_EMULATOR_BATCH_DEPLOYER_ID: {
                newDeployer = this._createEmulatorBatchDeployer();
                break;
            }
            case ANDROID_DEVICE_BATCH_DEPLOYER_ID: {
                newDeployer = this._createDeviceBatchDeployer();
                break;
            }
            case ANDROID_PACKAGE_POST_PACKAGING_BATCH_DEPLOYER_ID: {
                newDeployer = this._createPostPackagingPackageBatchDeployer();
                break;
            }
            case ANDROID_PREPARE_PACKAGAING_DEPLOYER_ID: {
                newDeployer = new PreparePackagingDeployer(androidId.getInt());
                break;
            }
            case ANDROID_SEQUENCE_ID: {
                newDeployer = new DynamicDeployer(AndroidDeployerSequenceId.ANDROID_ARCHIVE_DEPLOYER_ID.m_value);
                break;
            }
            case ANDROID_ARCHIVE_DEPLOYER_ID: {
                newDeployer = new AndroidArchiveDeployer(deploySequenceId, deployShell);
                break;
            }
            case ANDROID_COPY_TEMPLATE_DEPLOYER_ID: {
                newDeployer = new CopyAndroidTemplateDeployer(deploySequenceId);
                break;
            }
            case ANDROID_COPY_FRAMEWORK_JAVA_RESOURCES_ID: {
                newDeployer = new CopyFrameworkJavaResourcesDeployer(deploySequenceId);
                break;
            }
            case ANDROID_COPY_COMMON_JAVASCRIPT_DEPLOYER_ID: {
                AndroidFileUtils af = this._getFileUtils(deployShell);
                if (null == af) break;
                newDeployer = new JavaScriptDeployer(deploySequenceId, af);
                break;
            }
            case ANDROID_COPY_FRAMEWORK_RESOURCES_ID: {
                newDeployer = new CopyFrameworkResourcesDeployer(deploySequenceId);
                break;
            }
            case ANDROID_COPY_APPLICATION_IMAGES_DEPLOYER_ID: {
                newDeployer = new CopyApplicationImagesDeployer(deploySequenceId);
                break;
            }
            case ANDROID_CUSTOMIZE_CONTENT_DEPLOYER_ID: {
                AndroidFileUtils af = this._getFileUtils(deployShell);
                if (null == af) break;
                newDeployer = new CustomizeContentDeployer(deploySequenceId, af);
                break;
            }
            case ANDROID_COPY_CVM_AND_LOGGING_PROPERTIES_FILES_DEPLOYER_ID: {
                newDeployer = new CopyCvmAndLoggingPropertiesFileDeployer(deploySequenceId);
                break;
            }
            case ANDROID_COPY_ADF_MOBILE_XML_FILES_DEPLOYER_ID: {
                newDeployer = new CopyAdfMobileXmlFilesDeployer(deploySequenceId);
                break;
            }
            case ANDROID_COPY_SECURITY_FILES_DEPLOYER_ID: {
                AndroidFileUtils af = this._getFileUtils(deployShell);
                if (null == af) break;
                newDeployer = new SecurityDeployer(deploySequenceId, af);
                break;
            }
            case ANDROID_COPY_ADF_DIRECTORY_DEPLOYER_ID: {
                newDeployer = new CopyAdfDirectoryDeployer(deploySequenceId);
                break;
            }
            case ANDROID_TRANSFORM_ADF_MOBILE_XML_FILES_DEPLOYER_ID: {
                newDeployer = new TransformAdfMobileXmlFilesDeployer(deploySequenceId);
                break;
            }
            case ANDROID_MANIFEST_UPDATER_DEPLOYER_ID: {
                newDeployer = new ManifestUpdateDeployer(deploySequenceId);
                break;
            }
            case ANDROID_CREATE_GCM_INTENT_SERVICE_JAVA_FILE_DEPLOYER_ID: {
                newDeployer = new CreateGCMIntentServiceJavaFileDeployer(deploySequenceId);
                break;
            }
            case ANDROID_APPT_DEPLOYER_ID: {
                newDeployer = new AaptDeployer(deploySequenceId);
                break;
            }
            case ANDROID_JAVA_COMPILER_DEPLOYER_ID: {
                newDeployer = new AndroidJavaCompilerDeployer(deploySequenceId);
                break;
            }
            case ANDROID_FAR_EXTRACTION_DEPLOYER_ID: {
                AndroidFileUtils af = this._getFileUtils(deployShell);
                if (null == af) break;
                URL javaResURL = af.getApplicationAssetsOutputURL();
                newDeployer = new FarExtractorDeployer(deploySequenceId, javaResURL);
                break;
            }
            case ANDROID_SKINS_DEPLOYER_ID: {
                AndroidFileUtils af = this._getFileUtils(deployShell);
                if (null == af) break;
                newDeployer = new SkinsDeployer(deploySequenceId, af);
                break;
            }
            case ANDROID_DEX_DEPLOYER_ID: {
                newDeployer = new DexDeployer(deploySequenceId);
                break;
            }
            case ANDROID_APK_DEPLOYER_ID: {
                newDeployer = new ApkDeployer(deploySequenceId);
                break;
            }
            case ANDROID_SIGN_DEPLOYER_ID: {
                newDeployer = new SignDeployer(deploySequenceId);
                break;
            }
            case ANDROID_ZIP_ALIGN_DEPLOYER_ID: {
                newDeployer = new ZipAlignDeployer(deploySequenceId);
                break;
            }
            case ANDROID_DEVICE_DEPLOYER_ID: {
                newDeployer = new DeviceDeployer(deploySequenceId);
                break;
            }
            case ANDROID_EMULATOR_DEPLOYER_ID: {
                newDeployer = new EmulatorDeployer(deploySequenceId);
                break;
            }
            case ANDROID_APPLICATION_VALIDATOR_DEPLOYER_ID: {
                newDeployer = new ApplicationValidatorDeployer(deploySequenceId);
                break;
            }
            case ANDROID_PROJECT_VALIDATOR_DEPLOYER_ID: {
                newDeployer = new ProjectValidatorDeployer(deploySequenceId);
                break;
            }
            case ANDROID_APPLICATION_XML_VALIDATOR_DEPLOYER_ID: {
                newDeployer = new ApplicationXmlValidatorDeployer(deploySequenceId);
                break;
            }
            case ANDROID_PROJECT_XML_VALIDATOR_DEPLOYER_ID: {
                newDeployer = new ProjectXmlValidatorDeployer(deploySequenceId, false);
                break;
            }
        }
        if (AbstractDeployerWrapper.isDeployerWrappable(newDeployer)) {
            newDeployer = AndroidDeployerWrapper.newInstance(deploySequenceId, deployShell.getLogger(), (Deployer)newDeployer);
        }
        return newDeployer;
    }

    public static int getDeviceDeploymentSequenceId() {
        return AndroidDeployerSequenceId.ANDROID_DEVICE_BATCH_DEPLOYER_ID.getInt();
    }

    public static int getEmulatorDeploymentSequenceId() {
        return AndroidDeployerSequenceId.ANDROID_EMULATOR_BATCH_DEPLOYER_ID.getInt();
    }

    public static int getPackageDeploymentSequenceId() {
        return AndroidDeployerSequenceId.ANDROID_PACKAGE_BATCH_DEPLOYER_ID.getInt();
    }

    public static int getPackageValidatePreferencesDeploymentSequenceId() {
        return AndroidDeployerSequenceId.ANDROID_VALIDATE_PREFERENCES_FOR_PACKAGE_DEPLOYER_ID.getInt();
    }

    private BatchDeployer _createCommonPackageBatchDeployer() {
        return new BatchDeployer(AndroidDeployerSequenceId.ANDROID_COMMON_PACKAGE_BATCH_DEPLOYER_ID.getInt(), new int[]{AndroidDeployerSequenceId.ANDROID_VALIDATE_PREFERENCES_FOR_PACKAGE_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_PRE_PACKAGING_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_PACKAGE_POST_PACKAGING_BATCH_DEPLOYER_ID.getInt()});
    }

    private BatchDeployer _createPackageBatchDeployer() {
        return new BatchDeployer(AndroidDeployerSequenceId.ANDROID_PACKAGE_BATCH_DEPLOYER_ID.getInt(), new int[]{AndroidDeployerSequenceId.ANDROID_COMMON_PACKAGE_BATCH_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_MAYBE_SHOW_DEBUG_PERFORMANCE_WARNING_DEPLOYER_ID.getInt()});
    }

    private BatchDeployer _createEmulatorBatchDeployer() {
        return new BatchDeployer(AndroidDeployerSequenceId.ANDROID_EMULATOR_BATCH_DEPLOYER_ID.getInt(), new int[]{AndroidDeployerSequenceId.ANDROID_VALIDATE_PREFERENCES_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_MAYBE_START_ADB_SERVER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_CHECK_ATTACHED_DEVICES_ID.getInt(), AndroidDeployerSequenceId.ANDROID_COMMON_PACKAGE_BATCH_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_EMULATOR_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_MAYBE_SHUTDOWN_ADB_SERVER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_MAYBE_SHOW_DEBUG_PERFORMANCE_WARNING_DEPLOYER_ID.getInt()});
    }

    private BatchDeployer _createDeviceBatchDeployer() {
        return new BatchDeployer(AndroidDeployerSequenceId.ANDROID_DEVICE_BATCH_DEPLOYER_ID.getInt(), new int[]{AndroidDeployerSequenceId.ANDROID_VALIDATE_PREFERENCES_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_MAYBE_START_ADB_SERVER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_CHECK_ATTACHED_DEVICES_ID.getInt(), AndroidDeployerSequenceId.ANDROID_COMMON_PACKAGE_BATCH_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_DEVICE_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_MAYBE_SHUTDOWN_ADB_SERVER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_MAYBE_SHOW_DEBUG_PERFORMANCE_WARNING_DEPLOYER_ID.getInt()});
    }

    private BatchDeployer _createPrePackagingBatchDeployer() {
        return new BatchDeployer(AndroidDeployerSequenceId.ANDROID_PRE_PACKAGING_DEPLOYER_ID.getInt(), new int[]{AndroidDeployerSequenceId.ANDROID_PACKAGING_SEQUENCE_ID.getInt(), AndroidDeployerSequenceId.ANDROID_PREPARE_PACKAGAING_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_APPLICATION_VALIDATOR_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_PROJECT_VALIDATOR_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_APPLICATION_XML_VALIDATOR_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_PROJECT_XML_VALIDATOR_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_FAR_EXTRACTION_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_COPY_TEMPLATE_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_COPY_FRAMEWORK_RESOURCES_ID.getInt(), AndroidDeployerSequenceId.ANDROID_COPY_FRAMEWORK_JAVA_RESOURCES_ID.getInt(), AndroidDeployerSequenceId.ANDROID_COPY_COMMON_JAVASCRIPT_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_SKINS_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_CUSTOMIZE_CONTENT_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_COPY_APPLICATION_IMAGES_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_COPY_CVM_AND_LOGGING_PROPERTIES_FILES_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_COPY_ADF_MOBILE_XML_FILES_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_COPY_ADF_DIRECTORY_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_COPY_SECURITY_FILES_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_TRANSFORM_ADF_MOBILE_XML_FILES_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_MANIFEST_UPDATER_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_CREATE_GCM_INTENT_SERVICE_JAVA_FILE_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_APPT_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_JAVA_COMPILER_DEPLOYER_ID.getInt()});
    }

    private BatchDeployer _createPostPackagingPackageBatchDeployer() {
        return new BatchDeployer(AndroidDeployerSequenceId.ANDROID_PACKAGE_POST_PACKAGING_BATCH_DEPLOYER_ID.getInt(), new int[]{AndroidDeployerSequenceId.ANDROID_DEX_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_APK_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_SIGN_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_ZIP_ALIGN_DEPLOYER_ID.getInt()});
    }

    private Deployer _createPackagingBatchDeployer(DeployShell deployShell) {
        BatchDeployer newDeployer = null;
        newDeployer = deployShell.getFlag("ignoreDependencies") ? new BatchDeployer(AndroidDeployerSequenceId.ANDROID_PACKAGING_SEQUENCE_ID.getInt(), new int[]{AndroidDeployerSequenceId.ANDROID_BUILD_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_MODULE_PACKAGER_ID.getInt()}) : new BatchDeployer(AndroidDeployerSequenceId.ANDROID_PACKAGING_SEQUENCE_ID.getInt(), new int[]{AndroidDeployerSequenceId.ANDROID_DEPENDENCY_ANALYZER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_BUILD_DEPLOYER_ID.getInt(), AndroidDeployerSequenceId.ANDROID_MODULE_PACKAGER_ID.getInt()});
        return newDeployer;
    }

    private AndroidFileUtils _getFileUtils(DeployShell deployShell) {
        AndroidFileUtils af = null;
        try {
            AndroidProfile androidProfile = AndroidDeployUtil.getAndroidProfile(deployShell);
            af = new AndroidFileUtils(deployShell.getContext().getWorkspace(), androidProfile);
        }
        catch (DeployException deployException) {
            // empty catch block
        }
        return af;
    }

    public static enum AndroidDeployerSequenceId {
        ANDROID_COMMON_PACKAGE_BATCH_DEPLOYER_ID("Deployment.ANDROID_COMMON_PACKAGE_BATCH_DEPLOYER_ID"),
        ANDROID_PACKAGE_BATCH_DEPLOYER_ID("Deployment.ANDROID_PACKAGE_BATCH_DEPLOYER_ID"),
        ANDROID_DEVICE_BATCH_DEPLOYER_ID("Deployment.ANDROID_DEVICE_BATCH_DEPLOYER_ID"),
        ANDROID_EMULATOR_BATCH_DEPLOYER_ID("Deployment.ANDROID_EMULATOR_BATCH_DEPLOYER_ID"),
        ANDROID_PREPARE_PACKAGAING_DEPLOYER_ID("Deployment.ANDROID_PREPARE_PACKAGAING_DEPLOYER_ID"),
        ANDROID_MAYBE_START_ADB_SERVER_ID("Deployment.ANDROID_MAYBE_START_ADB_SERVER_ID"),
        ANDROID_CHECK_ATTACHED_DEVICES_ID("Deployment.ANDROID_CHECK_ATTACHED_DEVICES_ID"),
        ANDROID_PRE_PACKAGING_DEPLOYER_ID("Deployment.ANDROID_PRE_PACKAGING_DEPLOYER_ID"),
        ANDROID_PACKAGE_POST_PACKAGING_BATCH_DEPLOYER_ID("Deployment.ANDROID_PACKAGE_POST_PACKAGING_BATCH_DEPLOYER_ID"),
        ANDROID_MANIFEST_UPDATER_DEPLOYER_ID("Deployment.ANDROID_MANIFEST_UPDATER_DEPLOYER_ID"),
        ANDROID_APPT_DEPLOYER_ID("Deployment.ANDROID_APPT_DEPLOYER_ID"),
        ANDROID_JAVA_COMPILER_DEPLOYER_ID("Deployment.ANDROID_JAVA_COMPILER_DEPLOYER_ID"),
        ANDROID_DEX_DEPLOYER_ID("Deployment.ANDROID_DEX_DEPLOYER_ID"),
        ANDROID_APK_DEPLOYER_ID("Deployment.ANDROID_APK_DEPLOYER_ID"),
        ANDROID_SIGN_DEPLOYER_ID("Deployment.ANDROID_SIGN_DEPLOYER_ID"),
        ANDROID_ZIP_ALIGN_DEPLOYER_ID("Deployment.ANDROID_ZIP_ALIGN_DEPLOYER_ID"),
        ANDROID_DEVICE_DEPLOYER_ID("Deployment.ANDROID_DEVICE_DEPLOYER_ID"),
        ANDROID_EMULATOR_DEPLOYER_ID("Deployment.ANDROID_EMULATOR_DEPLOYER_ID"),
        ANDROID_COPY_TEMPLATE_DEPLOYER_ID("Deployment.ANDROID_COPY_TEMPLATE_DEPLOYER_ID"),
        ANDROID_COPY_COMMON_JAVASCRIPT_DEPLOYER_ID("Deployment.ANDROID_COPY_COMMON_JAVASCRIPT_DEPLOYER_ID"),
        ANDROID_COPY_FRAMEWORK_RESOURCES_ID("Deployment.ANDROID_COPY_FRAMEWORK_RESOURCES_ID"),
        ANDROID_COPY_APPLICATION_IMAGES_DEPLOYER_ID("Deployment.ANDROID_COPY_APPLICATION_IMAGES_DEPLOYER_ID"),
        ANDROID_CUSTOMIZE_CONTENT_DEPLOYER_ID("Deployment.ANDROID_CUSTOMIZE_CONTENT_DEPLOYER_ID"),
        ANDROID_COPY_CVM_AND_LOGGING_PROPERTIES_FILES_DEPLOYER_ID("Deployment.ANDROID_COPY_CVM_AND_LOGGING_PROPERTIES_FILES_DEPLOYER_ID"),
        ANDROID_COPY_SECURITY_FILES_DEPLOYER_ID("Deployment.ANDROID_COPY_SECURITY_FILES_DEPLOYER_ID"),
        ANDROID_COPY_ADF_MOBILE_XML_FILES_DEPLOYER_ID("Deployment.ANDROID_COPY_ADF_MOBILE_XML_FILES_DEPLOYER_ID"),
        ANDROID_COPY_ADF_DIRECTORY_DEPLOYER_ID("Deployment.ANDROID_COPY_ADF_DIRECTORY_DEPLOYER_ID"),
        ANDROID_TRANSFORM_ADF_MOBILE_XML_FILES_DEPLOYER_ID("Deployment.ANDROID_TRANSFORM_ADF_MOBILE_XML_FILES_DEPLOYER_ID"),
        ANDROID_MAYBE_SHUTDOWN_ADB_SERVER_ID("Deployment.ANDROID_MAYBE_SHUTDOWN_ADB_SERVER_ID"),
        ANDROID_MAYBE_SHOW_DEBUG_PERFORMANCE_WARNING_DEPLOYER_ID("Deployment.ANDROID_MAYBE_SHOW_DEBUG_PERFORMANCE_WARNING_DEPLOYER_ID"),
        ANDROID_VALIDATE_PREFERENCES_DEPLOYER_ID("Deployment.ANDROID_VALIDATE_PREFERENCES_DEPLOYER_ID"),
        ANDROID_VALIDATE_PREFERENCES_FOR_PACKAGE_DEPLOYER_ID("Deployment.ANDROID_VALIDATE_PREFERENCES_FOR_PACKAGE_DEPLOYER_ID"),
        ANDROID_SEQUENCE_ID(DeploymentConstants.DEFAULT_SEQUENCE),
        ANDROID_ARCHIVE_DEPLOYER_ID(DeploymentConstants.ARCHIVE_DEPLOYER),
        ANDROID_PACKAGING_SEQUENCE_ID(DeploymentConstants.PACKAGING_SEQUENCE),
        ANDROID_DEPENDENCY_ANALYZER_ID(JarDeployerFactory.DEPENDENCY_ANALYZER),
        ANDROID_BUILD_DEPLOYER_ID(DeploymentConstants.BUILD_DEPLOYER),
        ANDROID_MODULE_PACKAGER_ID(DeploymentConstants.MODULE_PACKAGER),
        ANDROID_FAR_EXTRACTION_DEPLOYER_ID("Deployment.ANDROID_FAR_EXTRACTION_DEPLOYER_ID"),
        ANDROID_APPLICATION_VALIDATOR_DEPLOYER_ID("Deployment.ANDROID_APPLICATION_VALIDATOR_DEPLOYER_ID"),
        ANDROID_APPLICATION_XML_VALIDATOR_DEPLOYER_ID("Deployment.ANDROID_APPLICATION_XML_VALIDATOR_DEPLOYER_ID"),
        ANDROID_PROJECT_VALIDATOR_DEPLOYER_ID("Deployment.ANDROID_PROJECT_VALIDATOR_DEPLOYER_ID"),
        ANDROID_PROJECT_XML_VALIDATOR_DEPLOYER_ID("Deployment.ANDROID_PROJECT_XML_VALIDATOR_DEPLOYER_ID"),
        ANDROID_SKINS_DEPLOYER_ID("Deployment.ANDROID_SKINS_DEPLOYER_ID"),
        ANDROID_COPY_FRAMEWORK_JAVA_RESOURCES_ID("Deployment.ANDROID_COPY_FRAMEWORK_JAVA_RESOURCES_ID"),
        ANDROID_CREATE_GCM_INTENT_SERVICE_JAVA_FILE_DEPLOYER_ID("Deployment.ANDROID_CREATE_GCM_INTENT_SERVICE_JAVA_FILE_DEPLOYER_ID");

        private int m_value;
        private static Map<Integer, AndroidDeployerSequenceId> s_androidDeployerMap;

        public int getInt() {
            return this.m_value;
        }

        public static boolean contains(int deploySequenceId) {
            return s_androidDeployerMap.containsKey(deploySequenceId);
        }

        public static AndroidDeployerSequenceId fromInt(int deploySequenceId) {
            if (s_androidDeployerMap.containsKey(deploySequenceId)) {
                return s_androidDeployerMap.get(deploySequenceId);
            }
            throw new IllegalArgumentException();
        }

        private AndroidDeployerSequenceId(String stringIdentifier) {
            this.m_value = DeploymentManager.getDeploymentSequenceId((String)stringIdentifier);
        }

        private AndroidDeployerSequenceId(int intIdentifier) {
            this.m_value = intIdentifier;
        }

        static {
            s_androidDeployerMap = new HashMap<Integer, AndroidDeployerSequenceId>();
            for (AndroidDeployerSequenceId id : AndroidDeployerSequenceId.values()) {
                s_androidDeployerMap.put(id.m_value, id);
            }
        }
    }
}

