/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core.adb;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.exec.ExecResults;
import oracle.adfmf.common.util.exec.ExecWrapper;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbDevicesCache;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbDevicesOptions;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbInstallToDeviceOptions;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbInstallToEmulatorOptions;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbOptions;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbShellOptions;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbShutdownServerOptions;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbStartServerOptions;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbUninstallFromDeviceOptions;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbUninstallFromEmulatorOptions;
import oracle.adfmf.framework.dt.deploy.android.ui.editor.options.AndroidOptions;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.common.AbstractDeployer;

public class AdbWrapper {
    public static boolean maybeStartupAdbServer(AndroidOptions androidOptions, Logger logger) throws DeployException {
        String _STARTED_SERVER_MESSAGE = "* daemon started successfully *";
        try {
            AdbStartServerOptions startServerOptions = new AdbStartServerOptions();
            ExecResults results = AdbWrapper._runAdbCommand(startServerOptions, androidOptions, logger);
            if (!results.returnCodeOK()) {
                int ADB_ERROR_CODE_255 = 255;
                if (255 == results.getReturnCode()) {
                    logger.finest("encountered error code 255 - retrying");
                    AdbStartServerOptions retryStart = new AdbStartServerOptions();
                    ExecResults retryStartResults = AdbWrapper._runAdbCommand(retryStart, androidOptions, logger);
                    retryStart.processExecResults(retryStartResults, logger);
                } else {
                    startServerOptions.processExecResults(results, logger);
                }
            } else {
                startServerOptions.processExecResults(results, logger);
            }
            List<String> stdOutList = results.getStandardOutput();
            for (String currMessage : stdOutList) {
                if (!currMessage.contains("* daemon started successfully *")) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new DeployException((Throwable)e);
        }
        return false;
    }

    public static boolean restartAdbServer(AndroidOptions androidOptions, Logger logger, AbstractDeployer deployer, boolean isEmulatorDeployment) throws DeployException {
        int RETRY_COUNT = 5;
        boolean serverStarted = false;
        for (int i = 0; i < 5; ++i) {
            logger.finest("Restart server attempt # " + (i + 1));
            AdbWrapper.shutdownAdbServer(androidOptions, logger);
            if (AdbWrapper.maybeStartupAdbServer(androidOptions, logger)) {
                serverStarted = true;
                logger.finest("Server started OK");
                AdbDevicesCache currentDevices = AdbWrapper.getAndroidDevicesStatus(androidOptions, logger);
                if (isEmulatorDeployment && 0 == currentDevices.getAttachedEmulatorCount()) {
                    logger.finest("ADB did not detect any emulators.  Retrying");
                    continue;
                }
                if (!isEmulatorDeployment && 0 == currentDevices.getAttachedDeviceCount()) {
                    logger.finest("ADB did not detect any devices.  Retrying");
                    continue;
                }
                return serverStarted;
            }
            logger.finest("Failed to start ADB server.");
            serverStarted = false;
            deployer.throwExceptionIfCancelEventReceived();
        }
        return serverStarted;
    }

    public static void shutdownAdbServer(AndroidOptions androidOptions, Logger logger) throws DeployException {
        AdbShutdownServerOptions shutdownServerOptions = new AdbShutdownServerOptions();
        ExecResults shutdownResults = AdbWrapper._runAdbCommand(shutdownServerOptions, androidOptions, logger);
        boolean serverNotRunningError = false;
        if (!shutdownResults.returnCodeOK()) {
            String SERVER_NOT_RUNNING = "* server not running *";
            List<String> stdErrList = shutdownResults.getStandardError();
            for (String currErr : stdErrList) {
                if (!currErr.equals("* server not running *") || null == logger) continue;
                logger.finest("Ignoring an expected, '* server not running *', error when attempting to shutdown the ADB server");
                serverNotRunningError = true;
                break;
            }
        }
        if (!serverNotRunningError) {
            shutdownServerOptions.processExecResults(shutdownResults, logger);
        }
    }

    public static void installToEmulator(String apkFilePath, AndroidOptions androidOptions, Logger logger) throws DeployException {
        AdbWrapper._runAdbCommand(new AdbInstallToEmulatorOptions(apkFilePath), androidOptions, logger);
    }

    public static void installToDevice(String apkFilePath, AndroidOptions androidOptions, Logger logger) throws DeployException {
        AdbWrapper._runAdbCommand(new AdbInstallToDeviceOptions(apkFilePath), androidOptions, logger);
    }

    public static void uninstallFromAndroidEmulator(String appPackageName, AndroidOptions androidOptions, Logger logger) throws DeployException {
        AdbWrapper._runAdbCommand(new AdbUninstallFromEmulatorOptions(appPackageName), androidOptions, logger);
    }

    public static void uninstallFromAndroidDevice(String appPackageName, AndroidOptions androidOptions, Logger logger) throws DeployException {
        AdbWrapper._runAdbCommand(new AdbUninstallFromDeviceOptions(appPackageName), androidOptions, logger);
    }

    public static AdbDevicesCache getAndroidDevicesStatus(AndroidOptions androidOptions, Logger logger) throws DeployException {
        String TAB_REGEX = "\\t";
        ExecResults results = AdbWrapper._runAdbCommand(new AdbDevicesOptions(), androidOptions, logger);
        AdbDevicesCache adbDevicesCache = new AdbDevicesCache();
        if (results.completedOK(new ArrayList<String>())) {
            List<String> stdOutList = results.getStandardOutput();
            for (String currMsg : stdOutList) {
                String[] currMsgParts;
                if (currMsg.equals(AdbDevicesCache.getAdbDevicesCommandHeader()) || null == (currMsgParts = currMsg.split("\\t")) || currMsgParts.length != 2) continue;
                adbDevicesCache.cacheDeviceInformation(currMsgParts[0], currMsgParts[1]);
            }
        }
        return adbDevicesCache;
    }

    public static List<String> getDeviceCpuInfo(AndroidOptions androidOptions, Logger logger) throws DeployException {
        AdbShellOptions cpuInfoShellOptions = AdbWrapper._getAdbShellOptionsForCpuInfo();
        cpuInfoShellOptions.setDirectToEmulator(false);
        return AdbWrapper._getEmulatorOrDeviceCpuInfo(cpuInfoShellOptions, androidOptions, logger);
    }

    public static List<String> getEmulatorCpuInfo(AndroidOptions androidOptions, Logger logger) throws DeployException {
        AdbShellOptions cpuInfoShellOptions = AdbWrapper._getAdbShellOptionsForCpuInfo();
        cpuInfoShellOptions.setDirectToEmulator(true);
        return AdbWrapper._getEmulatorOrDeviceCpuInfo(cpuInfoShellOptions, androidOptions, logger);
    }

    private static AdbShellOptions _getAdbShellOptionsForCpuInfo() {
        AdbShellOptions adbShellOptions = new AdbShellOptions();
        String SHELL_ARG_CAT = "cat";
        String SHELL_ARG_CPU_INFO = "/proc/cpuinfo";
        adbShellOptions.addShellArgument("cat");
        adbShellOptions.addShellArgument("/proc/cpuinfo");
        return adbShellOptions;
    }

    private static List<String> _getEmulatorOrDeviceCpuInfo(AdbShellOptions adbShellOptions, AndroidOptions androidOptions, Logger logger) throws DeployException {
        ArrayList<String> cpuInfoList = new ArrayList<String>();
        ExecResults execResults = AdbWrapper._runAdbCommand(adbShellOptions, androidOptions, logger);
        String ERR_TOKEN_NOT_FOUND = ": not found";
        String ERR_TOKEN_NO_FILE_OR_DIR = ": No such file or directory";
        String ERR_TOKEN = "error:";
        ArrayList<String> errTokenList = new ArrayList<String>();
        errTokenList.add(": not found");
        errTokenList.add(": No such file or directory");
        errTokenList.add("error:");
        if (execResults.completedOK(errTokenList)) {
            List<String> stdOutputList = execResults.getStandardOutput();
            for (String currLine : stdOutputList) {
                String trimmedLine = currLine.trim();
                if (!ModelUtil.hasLength((String)trimmedLine)) continue;
                cpuInfoList.add(trimmedLine);
            }
        }
        return cpuInfoList;
    }

    private static ExecResults _runAdbCommand(AdbOptions adbOptions, AndroidOptions androidOptions, Logger logger) throws DeployException {
        int _MAX_ADB_READ_WAIT_TIME_MS = 1000;
        boolean waitInfinitelyForReaders = !(adbOptions instanceof AdbStartServerOptions);
        ExecResults execResults = null;
        try {
            execResults = waitInfinitelyForReaders ? ExecWrapper.runTool(adbOptions.getCommandLineArguments()) : ExecWrapper.runTool(adbOptions.getCommandLineArguments(), 1000);
            adbOptions.setVerboseMode(androidOptions.getIsVerboseMode());
            if (!(adbOptions instanceof AdbShutdownServerOptions) && !(adbOptions instanceof AdbStartServerOptions)) {
                adbOptions.processExecResults(execResults, logger);
            }
            return execResults;
        }
        catch (Exception e) {
            if (null != logger) {
                FileUtils.logCommand(logger, null, adbOptions.getCommandLineArguments());
            }
            throw new DeployException((Throwable)e);
        }
    }
}

