/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core.adb;

import java.util.ArrayList;
import java.util.List;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbOptions;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;

public class AdbShellOptions
extends AdbOptions {
    private final List<String> _shellArgumentList = new ArrayList<String>();
    private boolean _directToEmulator = false;

    public void addShellArgument(String shellArgument) {
        if (!ModelUtil.hasLength((String)shellArgument)) {
            throw new IllegalArgumentException();
        }
        this._shellArgumentList.add(shellArgument);
    }

    public void setDirectToEmulator(boolean directToEmulator) {
        this._directToEmulator = directToEmulator;
    }

    @Override
    protected void verifyRequiredOptions() throws DeployException {
        if (this._shellArgumentList.isEmpty()) {
            String errorInfo = "No arguments for adb shell command";
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "adb", "No arguments for adb shell command");
            throw new DeployException(exceptionMsg);
        }
    }

    @Override
    protected void buildArgumentList() throws DeployException {
        super.buildArgumentList();
        if (this._directToEmulator) {
            this.addArgument(AdbOptions.AdbDeviceTargetFlags.DIRECT_CMD_TO_EMULATOR);
        } else {
            this.addArgument(AdbOptions.AdbDeviceTargetFlags.DIRECT_CMD_TO_DEVICE);
        }
        this.addArgument(AdbOptions.AdbDeviceCommands.SHELL);
        for (String currShellArg : this._shellArgumentList) {
            this.addArgument(currShellArg);
        }
    }
}

