/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core.adb;

import java.util.logging.Logger;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbWrapper;
import oracle.adfmf.framework.dt.deploy.android.ui.editor.options.AndroidOptions;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.common.AbstractDeployer;

public class AdbServerManager {
    private static volatile AdbServerManager _adbServerManager = null;
    private int _activeDeploymentsCount = 0;
    private boolean _deploymentStartedAdb = false;

    private AdbServerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdbServerManager getInstance() {
        if (null != _adbServerManager) return _adbServerManager;
        Class<AdbServerManager> clazz = AdbServerManager.class;
        synchronized (AdbServerManager.class) {
            if (null != _adbServerManager) return _adbServerManager;
            _adbServerManager = new AdbServerManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _adbServerManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(AndroidOptions androidOptions, Logger logger, AbstractDeployer deployer, boolean isEmulatorDeployment) throws DeployException {
        AdbServerManager adbServerManager = this;
        synchronized (adbServerManager) {
            ++this._activeDeploymentsCount;
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-21509"));
            if (AdbWrapper.maybeStartupAdbServer(androidOptions, logger)) {
                this._deploymentStartedAdb = true;
                if (PlatformUtils.isMac() && !AdbWrapper.restartAdbServer(androidOptions, logger, deployer, isEmulatorDeployment)) {
                    throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-01612"));
                }
                logger.info(MobileResourceUtils.getMsg("ADF-MBL-21510"));
            } else {
                logger.info(MobileResourceUtils.getMsg("ADF-MBL-21511"));
                if (!AdbWrapper.restartAdbServer(androidOptions, logger, deployer, isEmulatorDeployment)) {
                    throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-01612"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(AndroidOptions androidOptions, Logger logger, boolean isDeploymentCancelled) throws DeployException {
        AdbServerManager adbServerManager = this;
        synchronized (adbServerManager) {
            if (0 == this._activeDeploymentsCount) {
                return;
            }
            --this._activeDeploymentsCount;
            if (0 == this._activeDeploymentsCount && this._deploymentStartedAdb) {
                if (isDeploymentCancelled) {
                    logger.severe(MobileResourceUtils.getMsg("ADF-MBL-21512"));
                } else {
                    logger.info(MobileResourceUtils.getMsg("ADF-MBL-21512"));
                }
                AdbWrapper.shutdownAdbServer(androidOptions, logger);
                this._deploymentStartedAdb = false;
            }
        }
    }
}

