/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core.adb;

import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.core.ToolOptionsBase;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;

public abstract class AdbOptions
extends ToolOptionsBase {
    @Override
    protected void buildArgumentList() throws DeployException {
        this.verifyRequiredOptions();
        String androidPlatformToolPath = AndroidDeployUtil.getAndroidPlatformToolPath("adb");
        this.addArgumentValue(androidPlatformToolPath, this.shouldPathsBeQuoted());
    }

    protected abstract void verifyRequiredOptions() throws DeployException;

    protected void addArgument(AdbDeviceTargetFlags targetFlag) {
        this.addArgument(targetFlag.getCommandLineFlag());
    }

    protected void addArgument(AdbDeviceCommands adbDeviceCommand) {
        this.addArgument(adbDeviceCommand.getCommandLineFlag());
    }

    protected void addArgument(AdbInstallCommandFlags adbInstallCommandFlag) {
        this.addArgument(adbInstallCommandFlag.getCommandLineFlag());
    }

    protected void addArgument(AdbScriptingCommandFlags adbScriptCommandFlag) {
        this.addArgument(adbScriptCommandFlag.getCommandLineFlag());
    }

    protected void verifyApkFileExists(String apkFilePath) throws DeployException {
        if (!FileUtils.doesFileExist(apkFilePath)) {
            String errorInfo = "Path to Android application file (.apk)";
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "adb", "Path to Android application file (.apk)");
            throw new DeployException(exceptionMsg);
        }
    }

    protected void verifyApplicationPackageName(String applicationPackageName) throws DeployException {
        if (!ModelUtil.hasLength((String)applicationPackageName)) {
            String errorInfo = "Application package.";
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "adb", "Application package.");
            throw new DeployException(exceptionMsg);
        }
    }

    protected static enum AdbScriptingCommandFlags {
        DEVICES("devices"),
        START_SERVER("start-server"),
        KILL_SERVER("kill-server");

        private final String m_scriptingFlag;

        public String getCommandLineFlag() {
            return this.m_scriptingFlag;
        }

        private AdbScriptingCommandFlags(String scriptingFlag) {
            this.m_scriptingFlag = scriptingFlag;
        }
    }

    protected static enum AdbInstallCommandFlags {
        REINSTALL_APP("-r");

        private final String m_flagValue;

        public String getCommandLineFlag() {
            return this.m_flagValue;
        }

        private AdbInstallCommandFlags(String flag) {
            this.m_flagValue = flag;
        }
    }

    protected static enum AdbDeviceCommands {
        INSTALL("install"),
        UNINSTALL("uninstall"),
        SHELL("shell");

        private final String m_flagValue;

        public String getCommandLineFlag() {
            return this.m_flagValue;
        }

        private AdbDeviceCommands(String flag) {
            this.m_flagValue = flag;
        }
    }

    protected static enum AdbDeviceTargetFlags {
        DIRECT_CMD_TO_DEVICE("-d"),
        DIRECT_CMD_TO_EMULATOR("-e");

        private final String m_flagValue;

        public String getCommandLineFlag() {
            return this.m_flagValue;
        }

        private AdbDeviceTargetFlags(String flag) {
            this.m_flagValue = flag;
        }
    }
}

