/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core.adb;

import java.util.HashMap;
import java.util.Map;

public final class AdbDevicesCache {
    private final Map<String, String> _androidDeviceMap = new HashMap<String, String>();
    private final Map<String, String> _androidEmulatorMap = new HashMap<String, String>();
    private static final String _ADB_EMULATOR_TOKEN = "emulator-";
    private static final String _ADB_LIST_OF_DEVICES_HEADER = "List of devices";
    private static final String _ADB_ATTACHED_HEADER = "attached";
    private static final String _ADB_DEVICE_ATTACHMENT_STATE = "device";
    private static final String _ADB_OFFLINE_ATTACHMENT_STATE = "offline";
    private static final String _ADB_DEVICES_HEADER = "List of devices\tattached";

    public int getAttachedEmulatorCount() {
        return this._getAttachmentStateCount(_ADB_DEVICE_ATTACHMENT_STATE, this._androidEmulatorMap);
    }

    public int getAttachedDeviceCount() {
        return this._getAttachmentStateCount(_ADB_DEVICE_ATTACHMENT_STATE, this._androidDeviceMap);
    }

    public int getOfflineEmulatorCount() {
        return this._getAttachmentStateCount(_ADB_OFFLINE_ATTACHMENT_STATE, this._androidEmulatorMap);
    }

    public int getOfflineDeviceCount() {
        return this._getAttachmentStateCount(_ADB_OFFLINE_ATTACHMENT_STATE, this._androidDeviceMap);
    }

    public void cacheDeviceInformation(String deviceSerialNumber, String attachedState) {
        if (deviceSerialNumber.startsWith(_ADB_EMULATOR_TOKEN)) {
            this._androidEmulatorMap.put(deviceSerialNumber, attachedState);
        } else {
            this._androidDeviceMap.put(deviceSerialNumber, attachedState);
        }
    }

    public String getAdbDevicesStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append(AdbDevicesCache.getAdbDevicesCommandHeader());
        sb.append("\n");
        sb.append(this._getStatusesAsString(this._androidDeviceMap));
        sb.append(this._getStatusesAsString(this._androidEmulatorMap));
        return sb.toString();
    }

    public static String getAdbDevicesCommandHeader() {
        return _ADB_DEVICES_HEADER;
    }

    private String _getStatusesAsString(Map<String, String> statusMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> currEntry : statusMap.entrySet()) {
            sb.append(currEntry.getKey());
            sb.append("\t");
            sb.append(currEntry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    private int _getAttachmentStateCount(String attachmentState, Map<String, String> attachmentStateMap) {
        int count = 0;
        for (Map.Entry<String, String> currEntry : attachmentStateMap.entrySet()) {
            String currAttachedState = currEntry.getValue();
            if (!currAttachedState.equals(attachmentState)) continue;
            ++count;
        }
        return count;
    }
}

