/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core;

import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.core.ToolOptionsBase;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;

public class ZipAlignOptions
extends ToolOptionsBase {
    private static final String ZIP_ALIGN_32_BIT = "4";
    private static final String ZIP_ALIGN_64_BIT = "8";
    private String m_pathToUnalignedApplication;
    private String m_pathToAlignedApplication;
    private String m_alignmentValue;

    @Override
    protected void buildArgumentList() throws DeployException {
        this.verifyRequiredOptions();
        String androidPlatformToolPath = AndroidDeployUtil.getAndroidSdkToolPath("zipalign");
        this.addArgumentValue(androidPlatformToolPath, this.shouldPathsBeQuoted());
        this.addArgument(ZipAlignFlags.OVERWRITE_EXISTING_FILES);
        if (this.getIsVerboseMode()) {
            this.addArgument(ZipAlignFlags.VERBOSE);
        }
        this.addArgumentValue(this.m_alignmentValue, false);
        this.addArgumentValue(this.m_pathToUnalignedApplication, this.shouldPathsBeQuoted());
        this.addArgumentValue(this.m_pathToAlignedApplication, this.shouldPathsBeQuoted());
    }

    private void verifyRequiredOptions() throws DeployException {
        if (!FileUtils.doesFileExist(this.m_pathToUnalignedApplication)) {
            String errInfo = "Path to the unaligned Android application file.";
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "zipalign", "Path to the unaligned Android application file.");
            throw new DeployException(exceptionMsg);
        }
        if (!ModelUtil.hasLength((String)this.m_pathToAlignedApplication)) {
            String errInfo = "Path to the aligned Android application file.";
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "zipalign", "Path to the aligned Android application file.");
            throw new DeployException(exceptionMsg);
        }
    }

    private void addArgument(ZipAlignFlags zipAlignFlag) {
        this.addArgument(zipAlignFlag.getCommandLineFlag());
    }

    public void setPathToUnalignedApplication(String pathToUnalignedApplication) {
        this.m_pathToUnalignedApplication = pathToUnalignedApplication;
    }

    public void setPathToAlignedApplication(String pathToAlignedApplication) {
        this.m_pathToAlignedApplication = pathToAlignedApplication;
    }

    public void setAlignmentValue(String alignmentValue) {
        this.m_alignmentValue = alignmentValue;
    }

    public static String get32BitAlignmentValue() {
        return ZIP_ALIGN_32_BIT;
    }

    public static String get64BitAlignmentValue() {
        return ZIP_ALIGN_64_BIT;
    }

    private static enum ZipAlignFlags {
        OVERWRITE_EXISTING_FILES("-f"),
        VERBOSE("-v");

        private final String m_flagValue;

        private ZipAlignFlags(String flag) {
            this.m_flagValue = flag;
        }

        public String getCommandLineFlag() {
            return this.m_flagValue;
        }
    }
}

