/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.exec.ExecResults;
import oracle.adfmf.common.util.exec.ExecResultsLogger;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.deploy.DeployException;

public abstract class ToolOptionsBase {
    private boolean m_debugMode = true;
    private boolean m_verboseMode = false;
    private boolean m_useQuotedPaths = true;
    private List<String> m_toolArgumentList = new ArrayList<String>();
    private static final String CMD_LINE_ERROR_TOKEN_FAILURE = "Failure [";
    private static final String CMD_LINE_ERROR_TOKEN_ERROR = "Error:";
    private static final String CMD_LINE_WARNING_TOKEN_WARNING = "Warning:";

    public ToolOptionsBase() {
        if (this.isMac() || this.isLinux()) {
            this.m_useQuotedPaths = false;
        } else if (this.isWindows()) {
            this.m_useQuotedPaths = true;
        }
    }

    protected void addArgumentAndValue(String flag, String value, boolean surroundWithQuotes) {
        if (ModelUtil.hasLength((String)flag) && ModelUtil.hasLength((String)value)) {
            String cmdValue = this.createArgumentValue(value, surroundWithQuotes);
            this.m_toolArgumentList.add(flag);
            this.m_toolArgumentList.add(cmdValue);
        }
    }

    protected void addArgumentAndValueWithEqualOperator(String flag, String value, boolean surroundWithQuotes) {
        if (ModelUtil.hasLength((String)flag) && ModelUtil.hasLength((String)value)) {
            String cmdValue = this.createArgumentValue(value, surroundWithQuotes);
            String STRING_FORMAT = "%s%s%s";
            this.m_toolArgumentList.add(String.format("%s%s%s", flag, "=", cmdValue));
        }
    }

    protected void addArgument(String flag) {
        if (!ModelUtil.hasLength((String)flag)) {
            throw new IllegalArgumentException();
        }
        this.m_toolArgumentList.add(flag);
    }

    private String createArgumentValue(String value, boolean surroundWithQuotes) {
        if (surroundWithQuotes) {
            String STRING_FORMAT = "%s%s%s";
            return String.format("%s%s%s", "\"", value, "\"");
        }
        return value;
    }

    protected void addArgumentValue(String value, boolean surroundWithQuotes) {
        this.m_toolArgumentList.add(this.createArgumentValue(value, surroundWithQuotes));
    }

    protected void addArgumentAsDelimitedList(String flag, String delimiterChar, List<String> valueList, boolean surroundWithQuotes) {
        String delimitedList = this.getValuesAsDelimtedList(delimiterChar, valueList, surroundWithQuotes);
        if (ModelUtil.hasLength((String)delimitedList)) {
            this.addArgumentAndValue(flag, delimitedList, false);
        }
    }

    public String getValuesAsDelimtedList(String delimiterChar, List<String> valueList, boolean surroundWithQuotes) {
        if (null == valueList || valueList.isEmpty()) {
            return "";
        }
        StringBuilder charSepListValue = new StringBuilder();
        int listLen = valueList.size();
        int currIdx = 0;
        for (String currValue : valueList) {
            if (!ModelUtil.hasLength((String)currValue)) continue;
            if (surroundWithQuotes) {
                charSepListValue.append("\"");
            }
            charSepListValue.append(currValue);
            if (surroundWithQuotes) {
                charSepListValue.append("\"");
            }
            if (++currIdx >= listLen) continue;
            charSepListValue.append(delimiterChar);
        }
        return charSepListValue.toString();
    }

    protected void addValuesAsDelimitedList(String delimiterChar, List<String> valueList, boolean surroundWithQuotes) {
        String delimitedList = this.getValuesAsDelimtedList(delimiterChar, valueList, surroundWithQuotes);
        if (ModelUtil.hasLength((String)delimitedList)) {
            this.m_toolArgumentList.add(delimitedList);
        }
    }

    public void setDebugMode(boolean debugMode) {
        this.m_debugMode = debugMode;
    }

    protected boolean getIsDebugMode() {
        return this.m_debugMode;
    }

    public void setVerboseMode(boolean verboseMode) {
        this.m_verboseMode = verboseMode;
    }

    protected boolean getIsVerboseMode() {
        return this.m_verboseMode;
    }

    public List<String> getCommandLineArguments() throws DeployException {
        this.m_toolArgumentList.clear();
        this.buildArgumentList();
        return new ArrayList<String>(this.m_toolArgumentList);
    }

    protected abstract void buildArgumentList() throws DeployException;

    public void processExecResults(ExecResults execResults, Logger logger) throws DeployException {
        List<String> errorTokenList = this.getErrorTokenList();
        List<String> warningTokenList = this.getWarningTokenList();
        if (null != logger) {
            ExecResultsLogger execResultsLogger = new ExecResultsLogger(logger, execResults, errorTokenList, warningTokenList);
            if (this.m_verboseMode || FileUtils.isDiagnosticLoggingEnabled() || !execResults.completedOK(errorTokenList)) {
                execResultsLogger.logExecResults();
            }
        }
        if (!execResults.completedOK(errorTokenList)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02002", execResults.getCommandLineFullyQualifiedPath(), execResults.getErrorMessagesAsString(errorTokenList)));
        }
    }

    protected boolean isMac() {
        return PlatformUtils.isMac();
    }

    protected boolean isWindows() {
        return PlatformUtils.isWindows();
    }

    protected boolean isLinux() {
        return PlatformUtils.isLinux();
    }

    protected boolean shouldPathsBeQuoted() {
        return this.m_useQuotedPaths;
    }

    protected List<String> getErrorTokenList() {
        ArrayList<String> errorTokenList = new ArrayList<String>();
        errorTokenList.add(CMD_LINE_ERROR_TOKEN_FAILURE);
        errorTokenList.add(CMD_LINE_ERROR_TOKEN_ERROR);
        return errorTokenList;
    }

    protected List<String> getWarningTokenList() {
        ArrayList<String> warningTokenList = new ArrayList<String>();
        warningTokenList.add(CMD_LINE_WARNING_TOKEN_WARNING);
        return warningTokenList;
    }
}

