/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core;

import java.net.URL;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.core.ToolOptionsBase;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.adfmf.framework.dt.deploy.common.util.EncryptionUtils;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;

public class KeyToolOptions
extends ToolOptionsBase {
    private URL _keystoreUrl;
    private String _keyAlias;
    private String _validityIdDays;
    private char[] _keystorePassword;
    private char[] _keyPassword;
    private String _distinguishedName;
    private URL _jdkBinFolderUrl;
    private boolean _isValidState = true;
    private static final String _RSA_ALGORITHM = "RSA";

    public void invalidate() {
        EncryptionUtils.zeroCharBuffer(this._keystorePassword);
        EncryptionUtils.zeroCharBuffer(this._keyPassword);
        this._isValidState = false;
    }

    @Override
    protected void buildArgumentList() throws DeployException {
        this._verifyState();
        this._verifyRequiredOptions();
        String androidPlatformToolPath = AndroidDeployUtil.getJavaJdkToolPath(URLFileSystem.getPlatformPathName((URL)this._jdkBinFolderUrl), "keytool");
        this.addArgumentValue(androidPlatformToolPath, this.shouldPathsBeQuoted());
        this._addArgument(KeyToolFlags.GEN_KEY);
        if (this.getIsVerboseMode()) {
            this._addArgument(KeyToolFlags.VERBOSE);
        }
        this._addArgumentAndValue(KeyToolFlags.KEY_STORE, URLFileSystem.getPlatformPathName((URL)this._keystoreUrl), this.shouldPathsBeQuoted());
        this._addArgumentAndValue(KeyToolFlags.KEY_ALIAS, this._keyAlias, false);
        this._addArgumentAndValue(KeyToolFlags.KEY_ALGORITHM, _RSA_ALGORITHM, false);
        this._addArgumentAndValue(KeyToolFlags.SIGNATURE_ALGORITHM, "MD5withRSA", false);
        this._addArgumentAndValue(KeyToolFlags.VALIDITY, this._validityIdDays, false);
        this._addArgumentAndValue(KeyToolFlags.STORE_PASS, String.valueOf(this._keystorePassword), false);
        this._addArgumentAndValue(KeyToolFlags.KEY_PASS, String.valueOf(this._keyPassword), false);
        this._addArgumentAndValue(KeyToolFlags.DISTINGUISHED_NAME, this._distinguishedName, false);
    }

    public void setKeyStoreURL(URL keystoreUrl) {
        this._verifyState();
        this._keystoreUrl = URLFactory.newURL((String)URLFileSystem.getPlatformPathName((URL)keystoreUrl));
    }

    public void setKeyAlias(String keyAlias) {
        this._verifyState();
        this._keyAlias = keyAlias;
    }

    public void setValidityIdDays(String validityIdDays) {
        this._verifyState();
        this._validityIdDays = validityIdDays;
    }

    public void setKeyStorePassword(char[] keystorePassword) {
        this._verifyState();
        this._keystorePassword = EncryptionUtils.copyCharBuffer(keystorePassword);
    }

    public void setKeyPassword(char[] keyPassword) {
        this._verifyState();
        this._keyPassword = EncryptionUtils.copyCharBuffer(keyPassword);
    }

    public void setDistinguishedName(String distinguishedName) {
        this._verifyState();
        this._distinguishedName = distinguishedName;
    }

    public void setJdkBinFolderURL(URL jdkBinFolderUrl) {
        this._verifyState();
        this._jdkBinFolderUrl = URLFactory.newURL((String)URLFileSystem.getPlatformPathName((URL)jdkBinFolderUrl));
    }

    private void _verifyRequiredOptions() throws DeployException {
        String tempErrInfo;
        StringBuilder errorInfoBuilder = new StringBuilder();
        if (null == this._keystoreUrl) {
            errorInfoBuilder.append(KeyToolFlags.KEY_STORE.getCommandLineFlag());
            errorInfoBuilder.append(",");
        }
        if (null == this._keystorePassword || this._keystorePassword.length < 1) {
            errorInfoBuilder.append(KeyToolFlags.STORE_PASS.getCommandLineFlag());
            errorInfoBuilder.append(",");
        }
        if (null == this._keyPassword || this._keyPassword.length < 1) {
            errorInfoBuilder.append(KeyToolFlags.KEY_PASS.getCommandLineFlag());
            errorInfoBuilder.append(",");
        }
        if (ModelUtil.hasLength((String)(tempErrInfo = errorInfoBuilder.toString()))) {
            String errInfo = tempErrInfo.substring(0, tempErrInfo.length() - 1);
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "keytool", errInfo);
            throw new DeployException(exceptionMsg);
        }
        if (null == this._jdkBinFolderUrl) {
            String errInfo = MobileResourceUtils.getMsg("ADF-MBL-00043");
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "jarsigner", errInfo);
            throw new DeployException(exceptionMsg);
        }
    }

    private void _addArgument(KeyToolFlags keyToolFlag) {
        this.addArgument(keyToolFlag.getCommandLineFlag());
    }

    private void _addArgumentAndValue(KeyToolFlags flag, String value, boolean surroundWithQuotes) {
        this.addArgumentAndValue(flag.getCommandLineFlag(), value, surroundWithQuotes);
    }

    private void _verifyState() {
        if (!this._isValidState) {
            throw new IllegalStateException();
        }
    }

    private static enum KeyToolFlags {
        GEN_KEY("-genkey"),
        VERBOSE("-v"),
        KEY_STORE("-keystore"),
        KEY_ALIAS("-alias"),
        VALIDITY("-validity"),
        STORE_PASS("-storepass"),
        KEY_PASS("-keypass"),
        DISTINGUISHED_NAME("-dname"),
        KEY_ALGORITHM("-keyalg"),
        SIGNATURE_ALGORITHM("-sigalg");

        private final String _flagValue;

        private KeyToolFlags(String flag) {
            this._flagValue = flag;
        }

        public String getCommandLineFlag() {
            return this._flagValue;
        }
    }
}

