/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.core.ToolOptionsBase;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.deploy.DeployException;

public class JavacOptions
extends ToolOptionsBase {
    private static final String DEFAULT_VERSION_COMPATIBILITY = "Default";
    private static final String ERROR_TOKEN_FATAL_ERROR = "Fatal Error:";
    private static final String ERROR_TOKEN_ERROR = "Error(";
    private URL m_jdkBinFolderURL;
    private String m_sourceJdkVersionCompatibility;
    private String m_targetJdkVersionCompatibility;
    private String m_encoding;
    private URL m_classFilesTargetURL;
    private boolean m_bNoWarn = false;
    private boolean m_bDeprecation = true;
    private final List<String> m_javaSourceFileList = new ArrayList<String>();
    private final List<String> m_bootClasspathList = new ArrayList<String>();

    @Override
    protected List<String> getErrorTokenList() {
        ArrayList<String> errorTokenList = new ArrayList<String>();
        errorTokenList.add(ERROR_TOKEN_FATAL_ERROR);
        errorTokenList.add(ERROR_TOKEN_ERROR);
        return errorTokenList;
    }

    @Override
    protected void buildArgumentList() throws DeployException {
        this.verifyRequiredOptions();
        String androidPlatformToolPath = AndroidDeployUtil.getJavaJdkToolPath(URLFileSystem.getPlatformPathName((URL)this.m_jdkBinFolderURL), "javac");
        this.addArgumentValue(androidPlatformToolPath, this.shouldPathsBeQuoted());
        if (this.getIsDebugMode()) {
            this.addArgument(JavacFlags.GENERATE_DEBUG_INFO);
        } else {
            this.addArgument(JavacFlags.GENERATE_NO_DEBUG_INFO);
        }
        this.addArgumentAndValue(JavacFlags.SOURCE_COMPATIBILITY, this.m_sourceJdkVersionCompatibility, false);
        this.addArgumentAndValue(JavacFlags.TARGET_COMPATIBILITY, this.m_targetJdkVersionCompatibility, false);
        this.addArgumentAndValue(JavacFlags.TARGET_CLASS_FILE_DESTINATION, URLFileSystem.getPlatformPathName((URL)this.m_classFilesTargetURL), this.shouldPathsBeQuoted());
        if (this.m_bNoWarn) {
            this.addArgument(JavacFlags.NO_WARN);
        }
        if (this.getIsVerboseMode()) {
            this.addArgument(JavacFlags.VERBOSE);
        }
        if (this.m_bDeprecation) {
            this.addArgument(JavacFlags.DEPRECATION);
        }
        this.addArgumentAsDelimitedList(JavacFlags.BOOT_CLASS_PATH.getCommandLineFlag(), ADFMobileConstants.CLASSPATH_SEP, this.m_bootClasspathList, this.shouldPathsBeQuoted());
        this.addArgumentValue(JavacFlags.VERSION.getCommandLineFlag(), false);
        this.addArgumentAndValue(JavacFlags.ENCODING, this.m_encoding, false);
        for (String currSrc : this.m_javaSourceFileList) {
            this.addArgumentValue(currSrc, this.shouldPathsBeQuoted());
        }
    }

    public void setFilesToCompile(List<String> javaSourceFileList) {
        this.m_javaSourceFileList.addAll(javaSourceFileList);
    }

    private void addArgument(JavacFlags javacFlag) {
        this.addArgument(javacFlag.getCommandLineFlag());
    }

    private void addArgumentAndValue(JavacFlags javacFlag, String value, boolean surroundWithQuotes) {
        this.addArgumentAndValue(javacFlag.getCommandLineFlag(), value, surroundWithQuotes);
    }

    private void verifyRequiredOptions() throws DeployException {
        if (null == this.m_jdkBinFolderURL) {
            String errInfo = MobileResourceUtils.getMsg("ADF-MBL-00043");
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "jarsigner", errInfo);
            throw new DeployException(exceptionMsg);
        }
        if (null == this.m_classFilesTargetURL) {
            String errInfo = MobileResourceUtils.getMsg("ADF-MBL-00044");
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "jarsigner", errInfo);
            throw new DeployException(exceptionMsg);
        }
        if (this.m_javaSourceFileList.isEmpty()) {
            String errInfo = MobileResourceUtils.getMsg("ADF-MBL-00045");
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "jarsigner", errInfo);
            throw new DeployException(exceptionMsg);
        }
    }

    public void setJdkBinFolderURL(URL jdkBinFolderURL) {
        this.m_jdkBinFolderURL = jdkBinFolderURL;
    }

    public void setSourceJdkVersionCompatibility(String sourceJdkVersionCompatibility) {
        this.m_sourceJdkVersionCompatibility = sourceJdkVersionCompatibility;
    }

    public void setTargetJdkVersionCompatibility(String targetJdkVersionCompatibility) {
        this.m_targetJdkVersionCompatibility = targetJdkVersionCompatibility;
    }

    public void setClassFilesTargetURL(URL classFilesTargetURL) {
        this.m_classFilesTargetURL = classFilesTargetURL;
    }

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    public void setNoWarn(boolean bNoWarn) {
        this.m_bNoWarn = bNoWarn;
    }

    public void setDeprecation(boolean bDeprecation) {
        this.m_bDeprecation = bDeprecation;
    }

    public void setBootClasspath(List<String> bootClasspathList) {
        this.m_bootClasspathList.addAll(bootClasspathList);
    }

    public static String getDefaultVersionCompatibility() {
        return DEFAULT_VERSION_COMPATIBILITY;
    }

    private static enum JavacFlags {
        GENERATE_DEBUG_INFO("-g"),
        GENERATE_NO_DEBUG_INFO("-g:none"),
        NO_WARN("-nowarn"),
        VERBOSE("-verbose"),
        DEPRECATION("-deprecation"),
        BOOT_CLASS_PATH("-bootclasspath"),
        GENERATED_CLASS_FILE_LOCATION("-d"),
        SOURCE_COMPATIBILITY("-source"),
        TARGET_COMPATIBILITY("-target"),
        VERSION("-version"),
        ENCODING("-encoding"),
        TARGET_CLASS_FILE_DESTINATION("-d");

        private final String m_flagValue;

        private JavacFlags(String flag) {
            this.m_flagValue = flag;
        }

        public String getCommandLineFlag() {
            return this.m_flagValue;
        }
    }
}

