/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core;

import java.net.URL;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.core.ToolOptionsBase;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.adfmf.framework.dt.deploy.common.util.EncryptionUtils;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;

public class JarSignerToolOptions
extends ToolOptionsBase {
    private URL _keystoreUrl;
    private char[] _keystorePassword;
    private String _keyAlias;
    private char[] _keyPassword;
    private URL _fileToSignUrl;
    private URL _jdkBinFolderUrl;
    private boolean _isValidState = true;
    private static final String _SHA_1_DIGEST_ALGORITHM = "SHA1";

    public void invalidate() {
        EncryptionUtils.zeroCharBuffer(this._keystorePassword);
        EncryptionUtils.zeroCharBuffer(this._keyPassword);
        this._isValidState = false;
    }

    public void setKeystoreURL(URL keystoreUrl) {
        this._verifyState();
        this._keystoreUrl = URLFactory.newURL((String)URLFileSystem.getPlatformPathName((URL)keystoreUrl));
    }

    public void setKeystorePassword(char[] keystorePassword) {
        this._verifyState();
        this._keystorePassword = EncryptionUtils.copyCharBuffer(keystorePassword);
    }

    public void setKeyAlias(String keyAlias) {
        this._verifyState();
        this._keyAlias = keyAlias;
    }

    public void setKeyPassword(char[] keyPassword) {
        this._verifyState();
        this._keyPassword = EncryptionUtils.copyCharBuffer(keyPassword);
    }

    public void setFileToSignURL(URL fileToSignUrl) {
        this._verifyState();
        this._fileToSignUrl = URLFactory.newURL((String)URLFileSystem.getPlatformPathName((URL)fileToSignUrl));
    }

    public void setJdkBinFolderURL(URL jdkBinFolderUrl) {
        this._verifyState();
        this._jdkBinFolderUrl = URLFactory.newURL((String)URLFileSystem.getPlatformPathName((URL)jdkBinFolderUrl));
    }

    @Override
    protected void buildArgumentList() throws DeployException {
        this._verifyState();
        this._verifyRequiredOptions();
        String androidPlatformToolPath = AndroidDeployUtil.getJavaJdkToolPath(URLFileSystem.getPlatformPathName((URL)this._jdkBinFolderUrl), "jarsigner");
        this.addArgumentValue(androidPlatformToolPath, this.shouldPathsBeQuoted());
        if (this.getIsVerboseMode()) {
            this._addArgument(JarSignerFlags.VERBOSE);
        }
        this._addArgumentAndValue(JarSignerFlags.KEY_STORE, URLFileSystem.getPlatformPathName((URL)this._keystoreUrl), this.shouldPathsBeQuoted());
        this._addArgumentAndValue(JarSignerFlags.STORE_PASS, String.valueOf(this._keystorePassword), false);
        this._addArgumentAndValue(JarSignerFlags.KEY_PASS, String.valueOf(this._keyPassword), false);
        this._addArgumentAndValue(JarSignerFlags.DIGEST_ALGORITHM, _SHA_1_DIGEST_ALGORITHM, false);
        this._addArgumentAndValue(JarSignerFlags.SIGNATURE_ALGORITHM, "MD5withRSA", false);
        this.addArgumentValue(URLFileSystem.getPlatformPathName((URL)this._fileToSignUrl), this.shouldPathsBeQuoted());
        this.addArgumentValue(this._keyAlias, false);
    }

    private void _addArgument(JarSignerFlags flag) {
        this.addArgument(flag.getCommandLineFlag());
    }

    private void _addArgumentAndValue(JarSignerFlags flag, String value, boolean surroundWithQuotes) {
        this.addArgumentAndValue(flag.getCommandLineFlag(), value, surroundWithQuotes);
    }

    private void _verifyRequiredOptions() throws DeployException {
        String tempErrInfo;
        StringBuilder errorInfoBuilder = new StringBuilder();
        if (null == this._keystoreUrl) {
            errorInfoBuilder.append(JarSignerFlags.KEY_STORE.getCommandLineFlag());
            errorInfoBuilder.append(",");
        }
        if (!EncryptionUtils.hasLength(this._keystorePassword)) {
            errorInfoBuilder.append(JarSignerFlags.STORE_PASS.getCommandLineFlag());
            errorInfoBuilder.append(",");
        }
        if (!EncryptionUtils.hasLength(this._keyPassword)) {
            errorInfoBuilder.append(JarSignerFlags.KEY_PASS.getCommandLineFlag());
            errorInfoBuilder.append(",");
        }
        if (ModelUtil.hasLength((String)(tempErrInfo = errorInfoBuilder.toString()))) {
            String errInfo = tempErrInfo.substring(0, tempErrInfo.length() - 1);
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "jarsigner", errInfo);
            throw new DeployException(exceptionMsg);
        }
        if (null == this._fileToSignUrl) {
            String errInfo = MobileResourceUtils.getMsg("ADF-MBL-00042");
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "jarsigner", errInfo);
            throw new DeployException(exceptionMsg);
        }
        if (null == this._jdkBinFolderUrl) {
            String errInfo = MobileResourceUtils.getMsg("ADF-MBL-00043");
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "jarsigner", errInfo);
            throw new DeployException(exceptionMsg);
        }
    }

    private void _verifyState() {
        if (!this._isValidState) {
            throw new IllegalStateException();
        }
    }

    private static enum JarSignerFlags {
        KEY_STORE("-keystore"),
        STORE_PASS("-storepass"),
        KEY_PASS("-keypass"),
        VERBOSE("-verbose"),
        DIGEST_ALGORITHM("-digestalg"),
        SIGNATURE_ALGORITHM("-sigalg");

        private final String _flagValue;

        private JarSignerFlags(String flag) {
            this._flagValue = flag;
        }

        public String getCommandLineFlag() {
            return this._flagValue;
        }
    }
}

