/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.core.ToolOptionsBase;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.deploy.DeployException;

public class JarOptions
extends ToolOptionsBase {
    private URL _jdkBinFolderUrl;
    private URL _archiveUrl;
    private final Map<String, List<String>> _includeDirMap = new HashMap<String, List<String>>();

    public void setJdkBinFolderURL(URL jdkBinFolderUrl) {
        this._jdkBinFolderUrl = jdkBinFolderUrl;
    }

    public void setArchiveFile(URL archiveUrl) {
        this._archiveUrl = archiveUrl;
    }

    public void setIncludeDirectoryMap(Map<String, List<String>> includeDirMap) {
        this._includeDirMap.putAll(includeDirMap);
    }

    @Override
    protected void buildArgumentList() throws DeployException {
        this.verifyRequiredOptions();
        String jdkJarToolPath = AndroidDeployUtil.getJavaJdkToolPath(URLFileSystem.getPlatformPathName((URL)this._jdkBinFolderUrl), "jar");
        this.addArgumentValue(jdkJarToolPath, this.shouldPathsBeQuoted());
        StringBuilder sb = new StringBuilder();
        if (this.getIsVerboseMode()) {
            sb.append(JarFlags.VERBOSE.getCommandLineFlag());
        }
        sb.append(JarFlags.UPDATE.getCommandLineFlag());
        sb.append(JarFlags.ARCHIVE_FILE.getCommandLineFlag());
        this.addArgument(sb.toString());
        this.addArgumentValue(URLFileSystem.getPlatformPathName((URL)this._archiveUrl), this.shouldPathsBeQuoted());
        for (Map.Entry<String, List<String>> currEntry : this._includeDirMap.entrySet()) {
            for (String currDirOrFile : currEntry.getValue()) {
                this.addArgumentAndValue(JarFlags.CHANGE_DIR_AND_INCLUDE.getCommandLineFlag(), currEntry.getKey(), this.shouldPathsBeQuoted());
                this.addArgumentValue(currDirOrFile, this.shouldPathsBeQuoted());
            }
        }
    }

    private void verifyRequiredOptions() throws DeployException {
        if (null == this._jdkBinFolderUrl) {
            String errInfo = MobileResourceUtils.getMsg("ADF-MBL-00043");
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "jar", errInfo);
            throw new DeployException(exceptionMsg);
        }
        if (null == this._archiveUrl) {
            String errInfo = MobileResourceUtils.getMsg("ADF-MBL-00058");
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "jar", errInfo);
            throw new DeployException(exceptionMsg);
        }
    }

    private static enum JarFlags {
        VERBOSE("v"),
        UPDATE("u"),
        ARCHIVE_FILE("f"),
        CHANGE_DIR_AND_INCLUDE("-C");

        private final String _flagValue;

        private JarFlags(String flag) {
            this._flagValue = flag;
        }

        public String getCommandLineFlag() {
            return this._flagValue;
        }
    }
}

