/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core;

import java.util.ArrayList;
import java.util.List;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.core.ToolOptionsBase;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;

public class DexOptions
extends ToolOptionsBase {
    private String m_androidDexToolPath;
    private String m_dexOutputFileName;
    private String m_androidRClassFilesPath;
    private List<String> m_classJarPathList = new ArrayList<String>();

    @Override
    protected void buildArgumentList() throws DeployException {
        if (this.isMac()) {
            this.m_androidDexToolPath = AndroidDeployUtil.getAndroidBuildToolPath("dx");
        } else if (this.isWindows()) {
            this.m_androidDexToolPath = AndroidDeployUtil.getAndroidBuildToolPath("dx.bat");
        } else if (this.isLinux()) {
            this.m_androidDexToolPath = AndroidDeployUtil.getAndroidBuildToolPath("dx");
        } else {
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00050");
            throw new DeployException(exceptionMsg);
        }
        this.verifyRequiredOptions();
        boolean shouldPathsBeQuoted = this.shouldPathsBeQuoted();
        this.addArgumentValue(this.m_androidDexToolPath, shouldPathsBeQuoted);
        this.addArgument(DexFlags.DEX);
        if (this.getIsDebugMode()) {
            this.addArgument(DexFlags.DEBUG_MODE);
        }
        if (this.getIsVerboseMode()) {
            this.addArgument(DexFlags.VERBOSE);
        }
        this.addArgument(DexFlags.KEEP_CLASSES);
        if (this.isWindows()) {
            this.addArgument(DexFlags.OUTPUT);
            this.addArgumentValue(this.m_dexOutputFileName, shouldPathsBeQuoted);
        } else {
            this.addArgumentAndValue(DexFlags.OUTPUT, this.m_dexOutputFileName, shouldPathsBeQuoted);
        }
        this.addArgumentValue(this.m_androidRClassFilesPath, shouldPathsBeQuoted);
        for (String currJar : this.m_classJarPathList) {
            this.addArgumentValue(currJar, shouldPathsBeQuoted);
        }
    }

    private void verifyRequiredOptions() throws DeployException {
        if (this.m_classJarPathList.isEmpty() || !ModelUtil.hasLength((String)this.m_androidRClassFilesPath) || !ModelUtil.hasLength((String)this.m_dexOutputFileName)) {
            String errorInfo = MobileResourceUtils.getMsg("ADF-MBL-00041");
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", this.m_androidDexToolPath, errorInfo);
            throw new DeployException(exceptionMsg);
        }
    }

    private void addArgument(DexFlags dexFlag) {
        this.addArgument(dexFlag.getCommandLineFlag());
    }

    private void addArgumentAndValue(DexFlags dexFlag, String value, boolean surroundWithQuotes) {
        if (DexFlags.isEqualOperandOption(dexFlag)) {
            this.addArgumentAndValueWithEqualOperator(dexFlag.getCommandLineFlag(), value, surroundWithQuotes);
        } else {
            this.addArgumentAndValue(dexFlag.getCommandLineFlag(), value, surroundWithQuotes);
        }
    }

    public void setDexOutputFileName(String dexOutputFileName) {
        this.m_dexOutputFileName = dexOutputFileName;
    }

    public void setClassJarPathList(List<String> classJarPathList) {
        this.m_classJarPathList.addAll(classJarPathList);
    }

    public void setAndroidRClassFilesPath(String androidRClassFilesPath) {
        this.m_androidRClassFilesPath = androidRClassFilesPath;
    }

    private static enum DexFlags {
        VERBOSE("--verbose"),
        DEBUG_MODE("--debug"),
        DEX("--dex"),
        KEEP_CLASSES("--keep-classes"),
        OUTPUT("--output");

        private final String m_flagValue;

        private DexFlags(String flag) {
            this.m_flagValue = flag;
        }

        public String getCommandLineFlag() {
            return this.m_flagValue;
        }

        private static boolean isEqualOperandOption(DexFlags dexFlag) {
            switch (dexFlag) {
                case OUTPUT: {
                    return true;
                }
            }
            return false;
        }
    }
}

