/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.adfmf.common.OracleLocale;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.xsltransformer.XSLParameter;
import oracle.adfmf.framework.dt.deploy.android.deployers.AndroidFileUtils;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilenameFilter;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AndroidXslLocaleData {
    private static final String _XSL_PARAM_LOCALE_DATA_ELEMENTS = "XSL_PARAM_LocaleDataElements";
    private static final String _LOCALE_XML_ELEMENT_NAME = "LocaleData";
    private static final String _PERIOD_REGEX = "\\.";

    public static XSLParameter getLocaleDataElementsParameter(AndroidFileUtils af, Logger logger) throws DeployException {
        try {
            List<String> localeList = AndroidXslLocaleData._getLocaleList(af, logger);
            NodeList localeNodeList = AndroidXslLocaleData._localesToNodeList(localeList);
            return new XSLParameter("", _XSL_PARAM_LOCALE_DATA_ELEMENTS, localeNodeList);
        }
        catch (Exception e) {
            throw new DeployException((Throwable)e);
        }
    }

    private static List<String> _getLocaleList(AndroidFileUtils af, Logger logger) throws DeployException {
        ArrayList<String> xliffLocaleList = new ArrayList<String>();
        HashMap<String, String> localeTokenMap = new HashMap<String, String>();
        Map<String, String> applicationLocaleTokenMap = AndroidXslLocaleData._getLocaleTokenMapFromApplicationAdf(af.getWorkspace());
        localeTokenMap.putAll(applicationLocaleTokenMap);
        List<URL> list = af.getFeatureFarExtractionFolderUrls();
        for (URL currFarUrl : list) {
            Map<String, String> farLocaleTokenMap = AndroidXslLocaleData._getLanguageTokenMapFromFeatureFar(currFarUrl, logger);
            localeTokenMap.putAll(farLocaleTokenMap);
        }
        xliffLocaleList.addAll(localeTokenMap.values());
        for (String oracleLocale : xliffLocaleList) {
            if (OracleLocale.isValidOracleLocale(oracleLocale)) continue;
            String msg = MobileResourceUtils.getMsg("ADF-MBL-02013", oracleLocale);
            throw new DeployException(msg);
        }
        return xliffLocaleList;
    }

    private static NodeList _localesToNodeList(List<String> localeList) throws ParserConfigurationException {
        if (null == localeList) {
            throw new IllegalArgumentException();
        }
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        String TEMP_DOCUMENT_ROOT_NAME = "Root";
        Element rootElement = document.createElementNS(null, "Root");
        document.appendChild(rootElement);
        String ORACLE_LOCALE_ATTRIBUTE_NAME = "oracleLocale";
        String ANDROID_LOCALE_ATTRIBUTE_NAME = "androidLocale";
        for (String oracleLocale : localeList) {
            Element element = document.createElementNS(null, _LOCALE_XML_ELEMENT_NAME);
            if (!oracleLocale.isEmpty()) {
                element.setAttributeNS(null, "oracleLocale", oracleLocale);
                String androidLocale = AndroidXslLocaleData._toAndroidLocale(oracleLocale);
                element.setAttributeNS(null, "androidLocale", androidLocale);
            }
            rootElement.appendChild(element);
        }
        return rootElement.getChildNodes();
    }

    private static String _toAndroidLocale(String oracleLocale) {
        assert (OracleLocale.isValidOracleLocale(oracleLocale));
        String ANDROID_COUNTRY_CODE_PREFIX = "-r";
        String androidLocale = oracleLocale.replace("_", "-r");
        return androidLocale;
    }

    private static Map<String, String> _getLanguageTokenMapFromFeatureFar(URL farDirectoryUrl, Logger logger) throws DeployException {
        if (JarUtil.isJarURL((URL)farDirectoryUrl)) {
            throw new IllegalArgumentException();
        }
        String loadBundleBaseName = null;
        try {
            loadBundleBaseName = McAppUtils.getFeatureLoadBundleBaseName(farDirectoryUrl, logger);
        }
        catch (IOException e) {
            throw new DeployException((Throwable)e);
        }
        if (!ModelUtil.hasLength((String)loadBundleBaseName)) {
            return new HashMap<String, String>();
        }
        String xliffFileRelativePath = AndroidXslLocaleData._convertLoadBundleBaseNameToXliffRelativePath(loadBundleBaseName);
        URL coreXliffFileUrl = URLFactory.newURL((URL)farDirectoryUrl, (String)xliffFileRelativePath);
        return AndroidXslLocaleData._getLanguageTokenMap(coreXliffFileUrl);
    }

    private static Map<String, String> _getLanguageTokenMap(URL coreXliffFileUrl) throws DeployException {
        String xliffFamilyName;
        URLFilenameFilter xliffFileFamilyFilter;
        HashMap<String, String> localeTokenMap = new HashMap<String, String>();
        URL xliffParentFolderUrl = URLFileSystem.getParent((URL)coreXliffFileUrl);
        URL[] filesArray = URLFileSystem.list((URL)xliffParentFolderUrl, (URLFilenameFilter)(xliffFileFamilyFilter = AndroidXslLocaleData._getXliffFamilyFilenameFilter(xliffFamilyName = URLFileSystem.getName((URL)coreXliffFileUrl))));
        if (null == filesArray) {
            return localeTokenMap;
        }
        for (int i = 0; i < filesArray.length; ++i) {
            String currFileNamePath = filesArray[i].getFile();
            String currLocaleToken = AndroidXslLocaleData._getLocaleTokenFromFileName(currFileNamePath, xliffFamilyName);
            if (!ModelUtil.hasLength((String)currLocaleToken)) continue;
            localeTokenMap.put(currLocaleToken, currLocaleToken);
        }
        return localeTokenMap;
    }

    private static String _convertLoadBundleBaseNameToXliffRelativePath(String loadBundleBaseName) {
        String loadBundleBaseNameAsPath = loadBundleBaseName.replaceAll(_PERIOD_REGEX, "/");
        return loadBundleBaseNameAsPath + ".xlf";
    }

    private static URLFilenameFilter _getXliffFamilyFilenameFilter(final String xliffFileFamilyName) {
        return new URLFilenameFilter(){

            public boolean accept(URL url, String name) {
                if (null == url || !ModelUtil.hasLength((String)name)) {
                    return false;
                }
                return name.endsWith(".xlf") && name.startsWith(xliffFileFamilyName);
            }
        };
    }

    private static Map<String, String> _getLocaleTokenMapFromApplicationAdf(Workspace workspace) {
        HashMap<String, String> localeTokenMap = new HashMap<String, String>();
        final String appLoadBundleBaseName = McAppUtils.getApplicationLoadBundleBaseName(workspace);
        if (!ModelUtil.hasLength((String)appLoadBundleBaseName)) {
            return localeTokenMap;
        }
        URLFilenameFilter xlifFilter = new URLFilenameFilter(){

            public boolean accept(URL url, String name) {
                if (null == url || !ModelUtil.hasLength((String)name)) {
                    return false;
                }
                return name.endsWith(".xlf") && name.startsWith(appLoadBundleBaseName);
            }
        };
        URL appAdfMetaInfUrl = McAppUtils.getApplicationAdfMetaInfUrl(workspace);
        URL[] filesArray = URLFileSystem.list((URL)appAdfMetaInfUrl, (URLFilenameFilter)xlifFilter);
        if (null == filesArray) {
            return localeTokenMap;
        }
        for (int i = 0; i < filesArray.length; ++i) {
            String currFileNamePath = filesArray[i].getFile();
            String currLocaleToken = AndroidXslLocaleData._getLocaleTokenFromFileName(currFileNamePath, appLoadBundleBaseName);
            if (!ModelUtil.hasLength((String)currLocaleToken)) continue;
            localeTokenMap.put(currLocaleToken, currLocaleToken);
        }
        return localeTokenMap;
    }

    private static String _getLocaleTokenFromFileName(String fileName, String bundleBaseName) {
        int bundleBaseNameIdx = fileName.indexOf(bundleBaseName);
        if (0 > bundleBaseNameIdx) {
            return "";
        }
        String localeToken = fileName.substring(bundleBaseNameIdx + bundleBaseName.length() + 1);
        int periodIdx = localeToken.indexOf(".");
        if (0 > periodIdx) {
            return "";
        }
        localeToken = localeToken.substring(0, periodIdx);
        return localeToken;
    }
}

