/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.XmlUtils;
import oracle.adfmf.framework.dt.deploy.android.AndroidProfile;
import oracle.adfmf.framework.dt.deploy.android.deployers.AndroidFileUtils;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.adfmf.framework.dt.deploy.common.deployers.whitelist.WhiteListFileCreator;
import oracle.adfmf.framework.dt.deploy.common.deployers.whitelist.WhiteListUrlPattern;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AndroidWhiteListFileCreator
implements WhiteListFileCreator {
    private static List<String> _whiteListableProtocols = new ArrayList<String>();
    private static final String _HTTP_PROTOCOL = "http";
    private static final String _HTTPS_PROTOCOL = "https";
    private static final String _FTP_PROTOCOL = "ftp";
    private static final String _FTPS_PROTOCOL = "ftps";

    @Override
    public void createWhiteListFile(DeployShell deployShell, Set<WhiteListUrlPattern> whiteListedUrlPatterns) throws DeployException {
        Logger logger = deployShell.getLogger();
        AndroidProfile androidProfile = AndroidDeployUtil.getAndroidProfile(deployShell);
        AndroidFileUtils af = new AndroidFileUtils(deployShell.getContext().getWorkspace(), androidProfile);
        try {
            this._createAndroidAppConfigXml(af, logger, whiteListedUrlPatterns);
        }
        catch (Exception e) {
            throw new DeployException((Throwable)e);
        }
    }

    private void _createAndroidAppConfigXml(AndroidFileUtils af, Logger logger, Set<WhiteListUrlPattern> whiteListedUrlPatterns) throws DeployException {
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-21516"));
        this._copyTemplateConfigXml(af);
        Node appConfigXmlNode = this._getApplicationConfigXmlNode(af);
        XmlModel model = this._getApplicationConfigXmlModel(appConfigXmlNode);
        this._updateAndroidAppConfigXml(appConfigXmlNode, model, whiteListedUrlPatterns);
    }

    private Node _getApplicationConfigXmlNode(AndroidFileUtils af) throws DeployException {
        try {
            URL appConfigXmlUrl = af.getApplicationConfigXmlUrl();
            return NodeFactory.findOrCreate((URL)appConfigXmlUrl);
        }
        catch (Exception e) {
            throw new DeployException((Throwable)e);
        }
    }

    private void _updateAndroidAppConfigXml(Node appConfigXmlNode, XmlModel model, final Set<WhiteListUrlPattern> whiteListedUrlPatterns) throws DeployException {
        String TRANSACTION_NAME = "Add white list URLs to config xml";
        new FixedNameTransactionTask("Add white list URLs to config xml"){
            static final String ACCESS_ELEM = "access";
            static final String ORIGIN_ATTRIB = "origin";
            static final String SUBDOMAINS_ATTRIB = "subdomains";

            protected void performTask(AbstractModel model) throws XmlCommitException {
                Document configXmlDom = model.getDocument();
                Element cordovaRoot = configXmlDom.getDocumentElement();
                List<org.w3c.dom.Node> accessNodeList = XmlUtils.getNamedChildElements(cordovaRoot, ACCESS_ELEM);
                Set<WhiteListUrlPattern> allUrlPatterns = this._mergeConfigXmlPatterns(accessNodeList, whiteListedUrlPatterns);
                this._writeNewElements(configXmlDom, cordovaRoot, accessNodeList, allUrlPatterns);
                for (org.w3c.dom.Node currNode : accessNodeList) {
                    cordovaRoot.removeChild(currNode);
                }
            }

            private boolean _shouldAddSubDomainAttribute(String whiteListUrlPattern) {
                int indexOfStringToTest;
                String ALL_SUB_DOMAINS_TOKEN = "*.";
                String PROTOCOL_REGEX = "\\.*://";
                String[] urlParts = whiteListUrlPattern.split("\\.*://");
                int n = indexOfStringToTest = urlParts.length == 1 ? 0 : 1;
                if (urlParts[indexOfStringToTest].startsWith("*.")) {
                    if (1 == urlParts.length) {
                        return true;
                    }
                    return _whiteListableProtocols.contains(urlParts[0]);
                }
                return false;
            }

            private void _writeNewElements(Document configXmlDom, Element cordovaRoot, List<org.w3c.dom.Node> accessNodeList, Set<WhiteListUrlPattern> whiteListedUrlPatterns2) {
                String WHITE_LIST_ALL_URLS_PATTERN = "*";
                String ANDROID_WHITE_LIST_ALL_URLS_TOKEN = ".*";
                Element referenceElement = this._getReferenceNode(cordovaRoot);
                for (WhiteListUrlPattern currWhiteListUrlPattern : whiteListedUrlPatterns2) {
                    boolean addSubDomainAttribute;
                    Element currAccessElem = configXmlDom.createElementNS(null, ACCESS_ELEM);
                    String currWhiteListUrlSpec = currWhiteListUrlPattern.getUrlPattern();
                    if (currWhiteListUrlSpec.equals("*")) {
                        currWhiteListUrlSpec = ".*";
                    }
                    if (addSubDomainAttribute = this._shouldAddSubDomainAttribute(currWhiteListUrlSpec)) {
                        int firstDotIdx = currWhiteListUrlSpec.indexOf(".");
                        currWhiteListUrlSpec = currWhiteListUrlSpec.substring(firstDotIdx + 1);
                    }
                    currAccessElem.setAttributeNS(null, ORIGIN_ATTRIB, currWhiteListUrlSpec);
                    if (addSubDomainAttribute || this._doesPatternHaveSubDomainsEnabled(currWhiteListUrlPattern, accessNodeList)) {
                        currAccessElem.setAttributeNS(null, SUBDOMAINS_ATTRIB, "true");
                    }
                    if (null != referenceElement) {
                        cordovaRoot.insertBefore(currAccessElem, referenceElement);
                        continue;
                    }
                    cordovaRoot.appendChild(currAccessElem);
                }
            }

            private Set<WhiteListUrlPattern> _mergeConfigXmlPatterns(List<org.w3c.dom.Node> configXmlAccessNodeList, Set<WhiteListUrlPattern> whiteListedUrlPatterns2) {
                HashSet<WhiteListUrlPattern> mergedPatterns = new HashSet<WhiteListUrlPattern>(whiteListedUrlPatterns2);
                for (org.w3c.dom.Node currNode : configXmlAccessNodeList) {
                    assert (currNode instanceof Element);
                    Element currElement = (Element)currNode;
                    String originAttrValue = this._getOriginAttributeValue(currElement);
                    if (!ModelUtil.hasLength((String)originAttrValue)) continue;
                    mergedPatterns.add(new WhiteListUrlPattern(originAttrValue));
                }
                return mergedPatterns;
            }

            private Element _getReferenceNode(Element cordovaRoot) {
                String LOG_ELEM = "log";
                String PREFERENCE_ELEM = "preference";
                String PLUGINS_ELEM = "plugins";
                ArrayList<String> elementNames = new ArrayList<String>();
                elementNames.add(ACCESS_ELEM);
                elementNames.add("log");
                elementNames.add("preference");
                elementNames.add("plugins");
                for (String currElemName : elementNames) {
                    List<org.w3c.dom.Node> currElementList = XmlUtils.getNamedChildElements(cordovaRoot, currElemName);
                    if (currElementList.isEmpty()) continue;
                    org.w3c.dom.Node referenceNode = currElementList.get(0);
                    assert (referenceNode instanceof Element);
                    return (Element)referenceNode;
                }
                return null;
            }

            private String _getOriginAttributeValue(Element accessElement) {
                return accessElement.getAttributeNS(null, ORIGIN_ATTRIB);
            }

            private String _getSubdomainsAttributeValue(Element accessElement) {
                return accessElement.getAttributeNS(null, SUBDOMAINS_ATTRIB);
            }

            private boolean _doesPatternHaveSubDomainsEnabled(WhiteListUrlPattern pattern, List<org.w3c.dom.Node> accessNodeList) {
                for (org.w3c.dom.Node currNode : accessNodeList) {
                    assert (currNode instanceof Element);
                    Element currElement = (Element)currNode;
                    String originAttrValue = this._getOriginAttributeValue(currElement);
                    if (!ModelUtil.hasLength((String)originAttrValue) || !pattern.getUrlPattern().equals(originAttrValue)) continue;
                    String subDomainsAttrValue = this._getSubdomainsAttributeValue(currElement);
                    if (ModelUtil.hasLength((String)subDomainsAttrValue)) {
                        return subDomainsAttrValue.equals("true");
                    }
                    return false;
                }
                return false;
            }
        }.run((AbstractModel)model);
        try {
            appConfigXmlNode.save();
        }
        catch (IOException e) {
            throw new DeployException((Throwable)e);
        }
    }

    private void _copyTemplateConfigXml(AndroidFileUtils af) throws DeployException {
        URL appConfigXmlUrl = af.getApplicationConfigXmlUrl();
        try {
            FileUtils.copyFile(af.getFrameworkConfigXmlUrl(), URLFileSystem.getParent((URL)appConfigXmlUrl), null);
        }
        catch (IOException e) {
            throw new DeployException((Throwable)e);
        }
    }

    private XmlModel _getApplicationConfigXmlModel(Node appConfigXmlNode) {
        Context ideContext = Context.newIdeContext((Node)appConfigXmlNode);
        JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)ideContext);
        return xmlContext.getModel();
    }

    static {
        _whiteListableProtocols.add(_HTTP_PROTOCOL);
        _whiteListableProtocols.add(_HTTPS_PROTOCOL);
        _whiteListableProtocols.add(_FTP_PROTOCOL);
        _whiteListableProtocols.add(_FTPS_PROTOCOL);
    }
}

