/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core;

import java.util.logging.Logger;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.exec.ExecResults;
import oracle.adfmf.common.util.exec.ExecWrapper;
import oracle.adfmf.framework.dt.deploy.android.core.AaptOptions;
import oracle.adfmf.framework.dt.deploy.android.core.DexOptions;
import oracle.adfmf.framework.dt.deploy.android.core.JarOptions;
import oracle.adfmf.framework.dt.deploy.android.core.JarSignerToolOptions;
import oracle.adfmf.framework.dt.deploy.android.core.JavacOptions;
import oracle.adfmf.framework.dt.deploy.android.core.KeyToolOptions;
import oracle.adfmf.framework.dt.deploy.android.core.ZipAlignOptions;
import oracle.jdeveloper.deploy.DeployException;

public class AndroidPackager {
    public static void createApk(AaptOptions aaptOptions, Logger logger) throws DeployException {
        try {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-20011"));
            ExecResults execResults = ExecWrapper.runTool(aaptOptions.getCommandLineArguments());
            aaptOptions.processExecResults(execResults, logger);
        }
        catch (Exception e) {
            FileUtils.logCommand(logger, null, aaptOptions.getCommandLineArguments());
            throw new DeployException((Throwable)e);
        }
    }

    public static void createDexFromClasses(DexOptions androidDexOptions, Logger logger) throws DeployException {
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-20010"));
        try {
            ExecResults execResults = ExecWrapper.runTool(androidDexOptions.getCommandLineArguments());
            androidDexOptions.processExecResults(execResults, logger);
        }
        catch (Exception e) {
            FileUtils.logCommand(logger, null, androidDexOptions.getCommandLineArguments());
            throw new DeployException((Throwable)e);
        }
    }

    public static void updateApk(JarOptions jarOptions, Logger logger) throws DeployException {
        try {
            ExecResults execResults = ExecWrapper.runTool(jarOptions.getCommandLineArguments());
            jarOptions.processExecResults(execResults, logger);
        }
        catch (Exception e) {
            throw new DeployException((Throwable)e);
        }
    }

    public static void createDebugKeyStore(KeyToolOptions keyToolOptions, Logger logger) throws DeployException {
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-20013"));
        try {
            ExecResults execResults = ExecWrapper.runTool(keyToolOptions.getCommandLineArguments());
            keyToolOptions.processExecResults(execResults, logger);
        }
        catch (Exception e) {
            FileUtils.logCommand(logger, null, keyToolOptions.getCommandLineArguments());
            throw new DeployException((Throwable)e);
        }
    }

    public static void signApk(JarSignerToolOptions jarSignerToolOptions, Logger logger) throws DeployException {
        try {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-20014"));
            ExecResults execResults = ExecWrapper.runTool(jarSignerToolOptions.getCommandLineArguments());
            jarSignerToolOptions.processExecResults(execResults, logger);
        }
        catch (Exception e) {
            FileUtils.logCommand(logger, null, jarSignerToolOptions.getCommandLineArguments());
            throw new DeployException((Throwable)e);
        }
    }

    public static void zipAlignApkFile(ZipAlignOptions zipAlignOptions, Logger logger) throws DeployException {
        try {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-20012"));
            ExecResults execResults = ExecWrapper.runTool(zipAlignOptions.getCommandLineArguments());
            zipAlignOptions.processExecResults(execResults, logger);
        }
        catch (Exception e) {
            FileUtils.logCommand(logger, null, zipAlignOptions.getCommandLineArguments());
            throw new DeployException((Throwable)e);
        }
    }

    public static void compileAndroidJavaFiles(JavacOptions javacOptions, Logger logger) throws DeployException {
        try {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-20018"));
            ExecResults execResults = ExecWrapper.runTool(javacOptions.getCommandLineArguments());
            javacOptions.processExecResults(execResults, logger);
        }
        catch (Exception e) {
            FileUtils.logCommand(logger, null, javacOptions.getCommandLineArguments());
            throw new DeployException((Throwable)e);
        }
    }
}

