/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.xsltransformer.TransformException;
import oracle.adfmf.common.util.xsltransformer.XMLTransformer;
import oracle.adfmf.common.util.xsltransformer.XSLParameter;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.android.AndroidProfile;
import oracle.adfmf.framework.dt.deploy.android.core.AaptOptions;
import oracle.adfmf.framework.dt.deploy.android.core.AndroidPackager;
import oracle.adfmf.framework.dt.deploy.android.core.AndroidXslLocaleData;
import oracle.adfmf.framework.dt.deploy.android.core.DexOptions;
import oracle.adfmf.framework.dt.deploy.android.core.JarOptions;
import oracle.adfmf.framework.dt.deploy.android.core.JarSignerToolOptions;
import oracle.adfmf.framework.dt.deploy.android.core.JavacOptions;
import oracle.adfmf.framework.dt.deploy.android.core.KeyToolOptions;
import oracle.adfmf.framework.dt.deploy.android.core.ZipAlignOptions;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbDevicesCache;
import oracle.adfmf.framework.dt.deploy.android.core.adb.AdbWrapper;
import oracle.adfmf.framework.dt.deploy.android.deployers.AndroidFileUtils;
import oracle.adfmf.framework.dt.deploy.android.ui.editor.options.AndroidOptions;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidImageUtil;
import oracle.adfmf.framework.dt.deploy.common.util.DeployPropertiesFileUtil;
import oracle.adfmf.framework.dt.deploy.common.util.DeployUtil;
import oracle.adfmf.framework.dt.deploy.common.util.EncryptionUtils;
import oracle.adfmf.framework.dt.deploy.editor.options.ImageOptions;
import oracle.adfmf.framework.dt.preferences.PlatformSDKsPrefs;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilenameFilter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import org.w3c.dom.NodeList;

public class AndroidDeployer {
    private static final String _XSL_PARAM_TARGET_DIR_PATH = "XSL_PARAM_targetDirectoryPath";
    private static final String _XSL_PARAM_APPLICATION_PACKAGE = "XSL_PARAM_applicationPackage";
    private static final String _XSL_PARAM_FEATURE_ARCHIVE_URL_NODE_SET = "XSL_PARAM_FeatureArchiveUrlNodeSet";
    private static final String _XSL_PARAM_FEATURE_XML_RELATIVE_PATH_IN_FAR = "XSL_PARAM_FeatureXmlRelativePathInFAR";
    private static final String _XSL_PARAM_APPLICATION_XLIFF_BASE_PATH = "XSL_PARAM_applicationXliffBasePath";
    private static final String _XSL_PARAM_HREF = "XSL_PARAM_href";
    private static final String _PERIOD_REGEX = "\\.";
    private static final String _FAR_URL_XML_ELEMENT_NAME = "FAR_URL";
    private static final String _REPLACE_PARAM_APP_PACKAGE = "$$app.package$$";
    private static final String _REPLACE_PARAM_APP_ICON = "$$app.icon$$";
    private static final String _REPLACE_PARAM_APP_NAME = "$$app.name$$";
    private static final String _REPLACE_PARAM_APP_LABEL = "$$app.label$$";
    private static final String _REPLACE_PARAM_APP_DEBUGGABLE = "$$app.debuggable$$";
    private static final String _DEBUGGABLE_ATTRIBUTE_NAME_VALUE = "android:debuggable=\"$$app.debuggable$$\"";
    private static final String _REPLACE_PARAM_APP_CONFIG_CHANGES = "$$app.configChanges$$";
    private static final String _APP_CONFIG_CHANGES_DEFAULT_VALUE = "mcc|mnc|locale|touchscreen|keyboard|keyboardHidden|navigation|screenLayout|fontScale|uiMode|orientation";
    private static final String _APP_CONFIG_SCREEN_SIZE_VALUE = "screenSize|";
    private static final String _REPLACE_PARAM_APP_URL_SCHEME_INTENT = "$$app.scheme$$";
    private static final String _REPLACE_PARAM_APP_URLSCHEMENAME = "$$app.schemename$$";
    private static final String _APPLICATION_URL_SCHEME_INTENT = "\t <intent-filter>\n\t\t <action android:name=\"android.intent.action.VIEW\" />\n\t\t <category android:name=\"android.intent.category.BROWSABLE\" />\n\t\t <category android:name=\"android.intent.category.DEFAULT\" />\n\t\t <data android:scheme=\"$$app.schemename$$\" />\n\t </intent-filter>\n";
    private static final String _APPLICATION_ICON_REFERENCE = "@drawable/adfmf_icon";
    private static final String _APPLICATION_NAME_REFERENCE = "@string/app_name";
    private static final String _R_JAVA_SOURCE_FILE_NAME = "R.java";
    private static final String _ANDROID_DEFAULT_CHARACTER_ENCODING = "UTF-8";
    private static final String _ANDROID_DEFAULT_VERSION_COMPATIBILITY = "1.6";
    private static final String _DEBUG_KEYSTORE_FILE_NAME = "debug.keystore";
    private static final String _ORACLE_IDM_MOBILE_PACKAGE_NAME = "oracle.idm.mobile";
    private static final List<String> _defaultExtraPackagesList = new ArrayList<String>();

    public static void deployToDevice(AndroidFileUtils af, AndroidOptions androidOptions, Logger logger) throws DeployException {
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-20005"));
        AdbWrapper.uninstallFromAndroidDevice(af.getApplicationPackageName(androidOptions), androidOptions, null);
        AdbWrapper.installToDevice(URLFileSystem.getPlatformPathName((URL)af.getAndroidApplicationURL()), androidOptions, logger);
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-20006"));
    }

    public static void deployToEmulator(AndroidFileUtils af, AndroidOptions androidOptions, Logger logger) throws DeployException {
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-20007"));
        AdbWrapper.uninstallFromAndroidEmulator(af.getApplicationPackageName(androidOptions), androidOptions, null);
        AdbWrapper.installToEmulator(URLFileSystem.getPlatformPathName((URL)af.getAndroidApplicationURL()), androidOptions, logger);
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-20008"));
    }

    public static void copyAdfDirectory(AndroidFileUtils af, Logger logger) throws DeployException {
        try {
            URL applicationAdfFolderUrl = McAppUtils.getApplicationAdfFolderUrl(af.getWorkspace());
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-21504"));
            FileUtils.copyDirectory(applicationAdfFolderUrl, af.getAdfOutputFolderUrl());
        }
        catch (IOException e) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02017"), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02017"), (Throwable)e);
        }
    }

    public static void copyAdfMobileXmlFiles(AndroidFileUtils af, Logger logger) throws DeployException {
        try {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-21503"));
            DeployFileUtils.copyAdfMobileXmlFiles(af);
        }
        catch (IOException e) {
            throw new DeployException((Throwable)e);
        }
    }

    public static void copyAndroidTemplate(AndroidFileUtils af, Logger logger) throws DeployException {
        if (af.doesTemplateExist()) {
            AndroidDeployer._copyTemplateConfigXml(af);
            return;
        }
        try {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-20019"));
            URL androidFrameworkSourceURL = af.getAndroidFrameworkURL();
            URL androidFrameworkOutputURL = af.getAndroidFrameworkOutputURL();
            FileUtils.copyDirectory(androidFrameworkSourceURL, androidFrameworkOutputURL);
        }
        catch (IOException ioe) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00047", ioe.getMessage()));
        }
    }

    public static void copyCustomImages(AndroidFileUtils af, ImageOptions imageOptions, Logger logger) throws DeployException {
        AndroidImageUtil.copyApplicationImages(imageOptions, af, logger);
    }

    public static void copyCvmAndLoggingPropertiesFiles(AndroidFileUtils af, Logger logger) throws DeployException {
        try {
            logger.finest("About to copy cvm.properties and logging.properties to the deployment folder.");
            af.copyCvmAndLoggingPropertiesFiles(af.getJvmLibUrl(), af.getLoggingPropertiesUrl());
            logger.finest("Successfully copied cvm.properties and logging.properties.");
        }
        catch (IOException e) {
            throw new DeployException((Throwable)e);
        }
    }

    public static void copyFrameworkJavaResources(AndroidFileUtils af, Logger logger) throws DeployException {
        try {
            URL frameworkCvmLibsUrl;
            URL deployTypeFrameworkJavaResourceUrl;
            if (af.doesTemplateJavaResourcesExist()) {
                return;
            }
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-21501"));
            URL deploymentFrameworkJavaResourceUrl = af.getFrameworkJavaResourcesOutputURL();
            URL applicationJavaResourceOutputUrl = af.getApplicationJavaResourceURL();
            if (URLFileSystem.exists((URL)deploymentFrameworkJavaResourceUrl)) {
                FileUtils.copyDirectory(deploymentFrameworkJavaResourceUrl, applicationJavaResourceOutputUrl);
            }
            if (URLFileSystem.exists((URL)(deployTypeFrameworkJavaResourceUrl = af.getDeployTypeFrameworkJavaResourcesOutputUrl()))) {
                FileUtils.copyDirectory(deployTypeFrameworkJavaResourceUrl, applicationJavaResourceOutputUrl);
            }
            if (URLFileSystem.exists((URL)(frameworkCvmLibsUrl = af.getApplicationCvmLibsURL()))) {
                URLFileSystem.renameTo((URL)frameworkCvmLibsUrl, (URL)af.getApplicationCvmLibURL());
            }
        }
        catch (IOException ioe) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00048"), (Object)ioe.getMessage());
        }
    }

    public static void copyFrameworkResources(AndroidFileUtils af, Logger logger) throws DeployException {
        try {
            if (af.doesTemplateResourcesExist()) {
                return;
            }
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-21500"));
            FileUtils.copyDirectory(af.getFrameworkResourceOutputURL(), af.getApplicationResourceOutputURL());
        }
        catch (IOException ioe) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00049"), (Object)ioe.getMessage());
        }
    }

    public static void createAndroidManifestXml(AndroidFileUtils af, AndroidProfile androidProfile, Logger logger) throws DeployException {
        FileReader reader = null;
        try {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-21506"));
            URL androidTemplateManifestXmlURL = af.getFrameworkManifestTemplateXmlURL();
            reader = new FileReader(URLFileSystem.getPlatformPathName((URL)androidTemplateManifestXmlURL));
            String packageName = af.getApplicationPackageName(androidProfile.getAndroidOptions());
            if (!AndroidDeployUtil.isValidPackageName(packageName)) {
                throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-01602", packageName));
            }
            String templateManifest = FileUtils.readFileToString(reader);
            templateManifest = templateManifest.replace(_REPLACE_PARAM_APP_PACKAGE, packageName);
            templateManifest = templateManifest.replace(_REPLACE_PARAM_APP_ICON, _APPLICATION_ICON_REFERENCE);
            templateManifest = templateManifest.replace(_REPLACE_PARAM_APP_NAME, _APPLICATION_NAME_REFERENCE);
            templateManifest = templateManifest.replace(_REPLACE_PARAM_APP_LABEL, _APPLICATION_NAME_REFERENCE);
            AndroidOptions androidOptions = androidProfile.getAndroidOptions();
            templateManifest = !androidOptions.getIsDebugMode() ? templateManifest.replace(_DEBUGGABLE_ATTRIBUTE_NAME_VALUE, "") : templateManifest.replace(_REPLACE_PARAM_APP_DEBUGGABLE, "true");
            int targetSdkVersion = Integer.parseInt(androidOptions.getTargetSdkVersion(), 10);
            String configChangesValue = AndroidDeployer.getAndroidManifestConfigChangesValue(targetSdkVersion);
            templateManifest = templateManifest.replace(_REPLACE_PARAM_APP_CONFIG_CHANGES, configChangesValue);
            templateManifest = AndroidDeployer._setURLSchemeInTemplateManifest(af, templateManifest);
            AndroidDeployer._createFile(af.getAndroidManifestXmlURL(), templateManifest, logger);
        }
        catch (IOException e) {
            try {
                throw new DeployException((Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(reader, logger);
                throw throwable;
            }
        }
        FileUtils.closeStream(reader, logger);
    }

    public static void createAndroidGCMIntentServiceJava(AndroidFileUtils af, AndroidProfile androidProfile, Logger logger) throws DeployException {
        if (null == af || null == androidProfile || null == logger) {
            throw new IllegalArgumentException();
        }
        FileReader reader = null;
        try {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-21507"));
            URL templateGcmJavaFileUrl = af.getFrameworkGCMIntentServiceJavaUrl();
            reader = new FileReader(URLFileSystem.getPlatformPathName((URL)templateGcmJavaFileUrl));
            String packageName = af.getApplicationPackageName(androidProfile.getAndroidOptions());
            if (!AndroidDeployUtil.isValidPackageName(packageName)) {
                throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-01602", packageName));
            }
            String templateIntentJavaFile = FileUtils.readFileToString(reader);
            templateIntentJavaFile = templateIntentJavaFile.replace(_REPLACE_PARAM_APP_PACKAGE, packageName);
            String pathFromPackageName = packageName.replaceAll(_PERIOD_REGEX, "/");
            AndroidDeployer._createFile(af.getDeployGCMIntentServiceJavaUrl(pathFromPackageName), templateIntentJavaFile, logger);
        }
        catch (IOException e) {
            try {
                throw new DeployException((Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(reader, logger);
                throw throwable;
            }
        }
        FileUtils.closeStream(reader, logger);
    }

    public static void preparePackaging(AndroidFileUtils af, AndroidOptions androidOptions, Logger logger) throws DeployException {
        try {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-21508"));
            if (!af.doesTemplateExist()) {
                FileUtils.createDirectory(af.getOutputDirectoryURL());
                FileUtils.createDirectory(af.getJavaSourceURL());
                FileUtils.createDirectory(af.getAndroidRClassFileUrl());
                FileUtils.createDirectory(af.getApplicationResourceOutputURL());
                FileUtils.createDirectory(af.getApplicationAssetsOutputURL());
                FileUtils.createDirectory(af.getApplicationJavaResourceURL());
            }
            if (androidOptions.getIsDebugMode()) {
                URL debugKeystoreFileUrl = af.getDebugKeyStoreFileURL(_DEBUG_KEYSTORE_FILE_NAME);
                FileUtils.deleteFile(debugKeystoreFileUrl);
            }
            AndroidDeployer._cleanupApplicationResources(af);
            AndroidDeployer._cleanupRJavaAndClassFiles(af);
            if (af.doesTemplateJavaResourcesExist()) {
                URL applicationsLibCvmFileUrl = af.getApplicationLibCvmFileUrl();
                URL templatesLibCvmFileUrl = af.getDeployTypeFrameworkLibCvmFileUrl();
                URL applicationsVmChannelFileUrl = af.getApplicationsVmChannelFileUrl();
                URL templatesVmChannelFileUrl = af.getDeployTypeFrameworkVmChannelFileUrl();
                if (!FileUtils.areFileSizesEqual(applicationsLibCvmFileUrl, templatesLibCvmFileUrl) || !FileUtils.areFileSizesEqual(applicationsVmChannelFileUrl, templatesVmChannelFileUrl)) {
                    FileUtils.deleteDirectory(af.getApplicationJavaResourceURL());
                    FileUtils.createDirectory(af.getApplicationJavaResourceURL());
                }
            }
        }
        catch (Exception e) {
            throw new DeployException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signApplication(AndroidFileUtils af, AndroidOptions androidOptions, Logger logger) throws DeployException {
        char[] keystorePassword = null;
        char[] keyPassword = null;
        KeyToolOptions keyToolOptions = new KeyToolOptions();
        JarSignerToolOptions jarSignerToolOptions = new JarSignerToolOptions();
        try {
            keyToolOptions.setKeyStoreURL(AndroidDeployer._getKeystoreUrl(androidOptions, af));
            keyToolOptions.setDistinguishedName(AndroidDeployer._getKeyDistinguishedName(androidOptions));
            keyToolOptions.setValidityIdDays(AndroidDeployer._getKeyValidity(androidOptions));
            keyToolOptions.setVerboseMode(androidOptions.getIsVerboseMode());
            keyToolOptions.setJdkBinFolderURL(af.getJDKBinURL());
            keyToolOptions.setKeyAlias(AndroidDeployer._getKeyAlias(androidOptions));
            keyPassword = AndroidDeployer._getKeyPassword(androidOptions);
            keyToolOptions.setKeyPassword(keyPassword);
            keystorePassword = AndroidDeployer._getKeystorePassword(androidOptions);
            keyToolOptions.setKeyStorePassword(keystorePassword);
            if (androidOptions.getIsDebugMode()) {
                AndroidPackager.createDebugKeyStore(keyToolOptions, logger);
            }
            jarSignerToolOptions.setFileToSignURL(af.getAndroidApplicationURL());
            jarSignerToolOptions.setKeyAlias(AndroidDeployer._getKeyAlias(androidOptions));
            jarSignerToolOptions.setKeyPassword(keyPassword);
            jarSignerToolOptions.setKeystorePassword(keystorePassword);
            jarSignerToolOptions.setKeystoreURL(AndroidDeployer._getKeystoreUrl(androidOptions, af));
            jarSignerToolOptions.setVerboseMode(androidOptions.getIsVerboseMode());
            jarSignerToolOptions.setJdkBinFolderURL(af.getJDKBinURL());
            AndroidPackager.signApk(jarSignerToolOptions, logger);
            keyToolOptions.invalidate();
            jarSignerToolOptions.invalidate();
        }
        catch (Throwable throwable) {
            keyToolOptions.invalidate();
            jarSignerToolOptions.invalidate();
            EncryptionUtils.zeroCharBuffer(keystorePassword);
            EncryptionUtils.zeroCharBuffer(keyPassword);
            throw throwable;
        }
        EncryptionUtils.zeroCharBuffer(keystorePassword);
        EncryptionUtils.zeroCharBuffer(keyPassword);
    }

    public static void transformAdfmfXmlFiles(AndroidFileUtils af, AndroidOptions androidOptions, Logger logger) throws DeployException {
        ByteArrayInputStream inputXslStream = null;
        ByteArrayOutputStream androidOutputXsl = null;
        try {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-21505"));
            androidOutputXsl = AndroidDeployer._setXslInclude(af, logger);
            inputXslStream = new ByteArrayInputStream(androidOutputXsl.toByteArray());
            List<XSLParameter> xslParamList = AndroidDeployer._createXslParameterList(af, androidOptions, logger);
            XMLTransformer.transformXml(inputXslStream, af.getDeploymentAdfmfApplicationXmlFileUrl(), xslParamList, logger);
        }
        catch (TransformException e) {
            try {
                throw new DeployException((Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(inputXslStream, logger);
                FileUtils.closeStream(androidOutputXsl, logger);
                throw throwable;
            }
        }
        FileUtils.closeStream(inputXslStream, logger);
        FileUtils.closeStream(androidOutputXsl, logger);
    }

    public static void zipAlignApplication(AndroidFileUtils af, AndroidOptions androidOptions, Logger logger) throws DeployException {
        if (androidOptions.getIsDebugMode()) {
            return;
        }
        ZipAlignOptions zipOptions = new ZipAlignOptions();
        zipOptions.setAlignmentValue(androidOptions.getZipAlignment());
        zipOptions.setVerboseMode(androidOptions.getIsVerboseMode());
        URL unalignedApkUrl = af.getAndroidApplicationURL();
        zipOptions.setPathToUnalignedApplication(URLFileSystem.getPlatformPathName((URL)unalignedApkUrl));
        URL alignedApkUrl = af.getAndroidAlignedApplicationURL();
        zipOptions.setPathToAlignedApplication(URLFileSystem.getPlatformPathName((URL)alignedApkUrl));
        zipOptions.setAlignmentValue(androidOptions.getZipAlignment());
        AndroidPackager.zipAlignApkFile(zipOptions, logger);
        if (URLFileSystem.exists((URL)unalignedApkUrl) && URLFileSystem.exists((URL)alignedApkUrl)) {
            try {
                FileUtils.deleteFile(unalignedApkUrl);
            }
            catch (IOException e) {
                String errMsg = MobileResourceUtils.getMsg("ADF-MBL-01614", URLFileSystem.getPlatformPathName((URL)unalignedApkUrl));
                throw new DeployException(errMsg, (Throwable)e);
            }
            URL applicationUrl = unalignedApkUrl;
            try {
                URLFileSystem.renameEx((URL)alignedApkUrl, (URL)applicationUrl);
            }
            catch (IOException e) {
                String errMsg = MobileResourceUtils.getMsg("ADF-MBL-01613", URLFileSystem.getPlatformPathName((URL)applicationUrl));
                throw new DeployException(errMsg, (Throwable)e);
            }
        }
        String errMsg = MobileResourceUtils.getMsg("ADF-MBL-01613", URLFileSystem.getPlatformPathName((URL)unalignedApkUrl));
        throw new DeployException(errMsg);
    }

    public static void createAndroidApplication(AndroidFileUtils af, AndroidOptions androidOptions, Logger logger) throws DeployException {
        AaptOptions aaptOptions = new AaptOptions();
        aaptOptions.setDebugMode(androidOptions.getIsDebugMode());
        aaptOptions.setVerboseMode(androidOptions.getIsVerboseMode());
        aaptOptions.setPathToAndroidManifestXml(URLFileSystem.getPlatformPathName((URL)af.getAndroidManifestXmlURL()));
        aaptOptions.setPathToResourceConstantsGeneratedFile(URLFileSystem.getPlatformPathName((URL)af.getJavaSourceURL()));
        aaptOptions.setPathToOutputApkArchiveFile(URLFileSystem.getPlatformPathName((URL)af.getAndroidApplicationURL()));
        aaptOptions.setVersionCode(androidOptions.getVersionCode());
        aaptOptions.setMinSdkVersion(androidOptions.getMinimumSdkVersion());
        aaptOptions.setTargetSdkVersion(androidOptions.getTargetSdkVersion());
        String versionName = androidOptions.getVersionName();
        if (!ModelUtil.hasLength((String)versionName)) {
            versionName = AndroidDeployUtil.getVersionNameFromAdfmfApplicationXml(af.getWorkspace());
        }
        aaptOptions.setVersionName(versionName);
        ArrayList<String> rawFileDirList = new ArrayList<String>();
        rawFileDirList.add(URLFileSystem.getPlatformPathName((URL)af.getApplicationJavaResourceURL()));
        aaptOptions.setRawFileDirPathList(rawFileDirList);
        ArrayList<String> resourceDirList = new ArrayList<String>();
        resourceDirList.add(URLFileSystem.getPlatformPathName((URL)af.getApplicationResourceOutputURL()));
        aaptOptions.setPathToResourceDirPathList(resourceDirList);
        ArrayList<String> jarsToIncludeList = new ArrayList<String>();
        jarsToIncludeList.add(URLFileSystem.getPlatformPathName((URL)af.getAndroidPlatformJarURL()));
        aaptOptions.setJarsToIncludeList(jarsToIncludeList);
        Set<String> extraPackages = AndroidDeployer._getAllExtraPackages(logger);
        ArrayList<String> extraPackagesList = new ArrayList<String>(extraPackages);
        aaptOptions.setExtraPackagesList(extraPackagesList);
        if (logger.isLoggable(Level.FINEST)) {
            String NEW_LINE_TAB_TAB = "\n\t\t";
            String appPackageName = af.getApplicationPackageName(androidOptions);
            if (!extraPackagesList.contains(appPackageName)) {
                extraPackagesList.add(af.getApplicationPackageName(androidOptions));
            }
            String extraPackagesAsString = DeployUtil.stringListToString(extraPackagesList, "\n\t\t");
            logger.finest("Deployment will create a Android resource R.java file for the following packages: \n\t\t" + extraPackagesAsString);
        }
        AndroidPackager.createApk(aaptOptions, logger);
    }

    public static void updateAndroidApplication(AndroidFileUtils af, AndroidProfile androidProfile, Logger logger) throws DeployException {
        URL cvmPropertiesURL = URLFactory.newDirURL((URL)af.getOutputDirectoryURL(), (String)"cvm.properties");
        URL logPropertiesURL = URLFactory.newDirURL((URL)af.getOutputDirectoryURL(), (String)"logging.properties");
        JarOptions jarOptions = new JarOptions();
        AndroidOptions androidOptions = androidProfile.getAndroidOptions();
        jarOptions.setDebugMode(androidOptions.getIsDebugMode());
        jarOptions.setVerboseMode(androidOptions.getIsVerboseMode());
        jarOptions.setArchiveFile(af.getAndroidApplicationURL());
        jarOptions.setJdkBinFolderURL(af.getJDKBinURL());
        ArrayList<String> dirOrFileList = new ArrayList<String>();
        URL outputUrl = af.getOutputDirectoryURL();
        String outputPath = URLFileSystem.getPlatformPathName((URL)outputUrl);
        URL deployAdfUrl = af.getAdfOutputFolderUrl();
        boolean adfExists = false;
        if (URLFileSystem.exists((URL)cvmPropertiesURL)) {
            dirOrFileList.add("cvm.properties");
        }
        if (URLFileSystem.exists((URL)logPropertiesURL)) {
            dirOrFileList.add("logging.properties");
        }
        if (null != deployAdfUrl && URLFileSystem.exists((URL)deployAdfUrl)) {
            adfExists = true;
            String deployAdfPath = URLFileSystem.getPlatformPathName((URL)deployAdfUrl);
            String adfFolderName = URLFileSystem.getSuffix((URL)URLFactory.newURL((String)deployAdfPath));
            dirOrFileList.add(adfFolderName);
        }
        if (adfExists) {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-20020"));
        } else {
            logger.info(MobileResourceUtils.getMsg("ADF-MBL-20009"));
        }
        if (!URLFileSystem.exists((URL)af.getAndroidDalvikByteCodeURL())) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00046"));
        }
        dirOrFileList.add(af.getDalvikFileName());
        HashMap<String, List<String>> includedDirMap = new HashMap<String, List<String>>();
        includedDirMap.put(outputPath, dirOrFileList);
        jarOptions.setIncludeDirectoryMap(includedDirMap);
        AndroidPackager.updateApk(jarOptions, logger);
    }

    public static void createAndroidDexFile(AndroidFileUtils af, AndroidOptions androidOptions, Logger logger) throws DeployException {
        DexOptions androidDexOptions = new DexOptions();
        androidDexOptions.setDebugMode(androidOptions.getIsDebugMode());
        androidDexOptions.setVerboseMode(androidOptions.getIsVerboseMode());
        List<String> jarPathList = af.getFrameworkJarFilePaths();
        jarPathList.add(URLFileSystem.getPlatformPathName((URL)af.getAndroidGcmJarUrl()));
        androidDexOptions.setClassJarPathList(jarPathList);
        androidDexOptions.setDexOutputFileName(URLFileSystem.getPlatformPathName((URL)af.getAndroidDalvikByteCodeURL()));
        androidDexOptions.setAndroidRClassFilesPath(URLFileSystem.getPlatformPathName((URL)af.getAndroidRClassFileUrl()));
        AndroidPackager.createDexFromClasses(androidDexOptions, logger);
    }

    public static void compileAndroidJavaFiles(AndroidFileUtils af, AndroidOptions androidOptions, Logger logger) throws DeployException {
        JavacOptions javacOptions = new JavacOptions();
        javacOptions.setDebugMode(androidOptions.getIsDebugMode());
        String applicationPackageName = af.getApplicationPackageName(androidOptions);
        String applicationResourceJavaSourcePath = AndroidDeployer._getJavaSourcePathFromPackageName(af, _R_JAVA_SOURCE_FILE_NAME, applicationPackageName);
        ArrayList<String> javaFileList = new ArrayList<String>();
        javaFileList.add(applicationResourceJavaSourcePath);
        Set<String> extraPackages = AndroidDeployer._getAllExtraPackages(null);
        for (String currPackageName : extraPackages) {
            String extraPackageSrcResourcePath = AndroidDeployer._getJavaSourcePathFromPackageName(af, _R_JAVA_SOURCE_FILE_NAME, currPackageName);
            javaFileList.add(extraPackageSrcResourcePath);
        }
        String gcmIntentServiceJavaPath = AndroidDeployer._getJavaSourcePathFromPackageName(af, af.getFrameworkGcmIntentServiceJavaFileName(), applicationPackageName);
        javaFileList.add(gcmIntentServiceJavaPath);
        javacOptions.setFilesToCompile(javaFileList);
        String sourceJdkVersionCompatibility = androidOptions.getJavaJdkVersionCompatibility();
        if (sourceJdkVersionCompatibility.equals(JavacOptions.getDefaultVersionCompatibility())) {
            javacOptions.setSourceJdkVersionCompatibility(_ANDROID_DEFAULT_VERSION_COMPATIBILITY);
        } else {
            javacOptions.setSourceJdkVersionCompatibility(sourceJdkVersionCompatibility);
        }
        String targetJdkVersionCompatibility = androidOptions.getClassJdkVersionCompatibility();
        if (targetJdkVersionCompatibility.equals(JavacOptions.getDefaultVersionCompatibility())) {
            javacOptions.setTargetJdkVersionCompatibility(_ANDROID_DEFAULT_VERSION_COMPATIBILITY);
        } else {
            javacOptions.setTargetJdkVersionCompatibility(targetJdkVersionCompatibility);
        }
        String characterEncoding = androidOptions.getCharacterEncoding();
        if (characterEncoding.equals(androidOptions.getDefaultCharacterEncoding())) {
            javacOptions.setEncoding(_ANDROID_DEFAULT_CHARACTER_ENCODING);
        } else {
            javacOptions.setEncoding(characterEncoding);
        }
        javacOptions.setVerboseMode(androidOptions.getIsVerboseMode());
        javacOptions.setClassFilesTargetURL(af.getAndroidRClassFileUrl());
        javacOptions.setJdkBinFolderURL(af.getJDKBinURL());
        ArrayList<String> bootClasspath = new ArrayList<String>();
        bootClasspath.add(URLFileSystem.getPlatformPathName((URL)af.getAndroidPlatformJarURL()));
        bootClasspath.add(URLFileSystem.getPlatformPathName((URL)af.getAndroidGcmJarUrl()));
        bootClasspath.addAll(af.getFrameworkJarFilePaths());
        javacOptions.setBootClasspath(bootClasspath);
        AndroidPackager.compileAndroidJavaFiles(javacOptions, logger);
    }

    public static AdbDevicesCache getAndroidDevicesStatus(AndroidOptions androidOptions, Logger logger) throws DeployException {
        return AdbWrapper.getAndroidDevicesStatus(androidOptions, logger);
    }

    public static void validatePreferences(AndroidFileUtils af, AndroidOptions androidOptions) throws DeployException {
        char[] keyPassword = null;
        char[] keyStorePassword = null;
        StringBuilder invalidPreferenceBuilder = new StringBuilder();
        boolean bDebugDeploy = androidOptions.getIsDebugMode();
        try {
            keyPassword = AndroidDeployer._getKeyPassword(androidOptions);
        }
        catch (DeployException e) {
            // empty catch block
        }
        if (!EncryptionUtils.hasLength(keyPassword)) {
            if (bDebugDeploy) {
                invalidPreferenceBuilder.append(AndroidDeployer._getPreferenceConfigLabel("ANDROID_DEBUG_KEY_PASSWORD_FIELD_LABEL"));
            } else {
                invalidPreferenceBuilder.append(AndroidDeployer._getPreferenceConfigLabel("ANDROID_KEY_PASSWORD"));
            }
            invalidPreferenceBuilder.append("\n");
        }
        EncryptionUtils.zeroCharBuffer(keyPassword);
        try {
            keyStorePassword = AndroidDeployer._getKeystorePassword(androidOptions);
        }
        catch (DeployException e) {
            // empty catch block
        }
        if (!EncryptionUtils.hasLength(keyStorePassword) && !bDebugDeploy) {
            invalidPreferenceBuilder.append(AndroidDeployer._getPreferenceConfigLabel("ANDROID_KEYSTORE_PASSWORD"));
            invalidPreferenceBuilder.append("\n");
        }
        EncryptionUtils.zeroCharBuffer(keyStorePassword);
        URL keyStoreFileUrl = AndroidDeployer._getKeystoreUrl(androidOptions, af);
        if (null == keyStoreFileUrl || !bDebugDeploy && !URLFileSystem.exists((URL)keyStoreFileUrl)) {
            invalidPreferenceBuilder.append(AndroidDeployer._getPreferenceConfigLabel("ANDROID_SIGNING_KEYSTORE_LOCATION_LABEL"));
            invalidPreferenceBuilder.append("\n");
        }
        String keyAlias = AndroidDeployer._getKeyAlias(androidOptions);
        if (!bDebugDeploy && !ModelUtil.hasLength((String)keyAlias)) {
            invalidPreferenceBuilder.append(AndroidDeployer._getPreferenceConfigLabel("ANDROID_ALIAS"));
            invalidPreferenceBuilder.append("\n");
        }
        try {
            AndroidDeployUtil.getAndroidSdkPath();
        }
        catch (DeployException de) {
            invalidPreferenceBuilder.append(AndroidDeployer._getPreferenceConfigLabel("ANDROID_SDK_LOCATION_LABEL"));
            invalidPreferenceBuilder.append("\n");
        }
        try {
            String platformPath = AndroidDeployUtil.getAndroidPlatformPath();
            if (!FileUtils.isAndroidPlatformDirValid(platformPath)) {
                throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-10007", platformPath, "9"));
            }
        }
        catch (DeployException de) {
            invalidPreferenceBuilder.append(AndroidDeployer._getPreferenceConfigLabel("ANDROID_PLATFORM_LOCATION_LABEL"));
            invalidPreferenceBuilder.append("\n");
        }
        String invalidPreferenceConfig = invalidPreferenceBuilder.toString();
        if (ModelUtil.hasLength((String)invalidPreferenceConfig)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-01607", invalidPreferenceConfig));
        }
        URL gcmJarUrl = af.getAndroidGcmJarUrl();
        if (!URLFileSystem.exists((URL)gcmJarUrl)) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-01601"));
        }
    }

    public static List<String> getEmulatorCpuInfo(AndroidOptions androidOptions, Logger logger) throws DeployException {
        return AdbWrapper.getEmulatorCpuInfo(androidOptions, logger);
    }

    public static List<String> getDeviceCpuInfo(AndroidOptions androidOptions, Logger logger) throws DeployException {
        return AdbWrapper.getDeviceCpuInfo(androidOptions, logger);
    }

    public static String getAndroidManifestIconReferenceValue() {
        return _APPLICATION_ICON_REFERENCE;
    }

    public static String getAndroidManifestApplicationNameReferenceValue() {
        return _APPLICATION_NAME_REFERENCE;
    }

    public static String getAndroidManifestConfigChangesValue(int targetSdkVersion) {
        int API_LEVEL_13 = 13;
        String configChangesValue = _APP_CONFIG_CHANGES_DEFAULT_VALUE;
        if (13 <= targetSdkVersion) {
            configChangesValue = String.format("%s%s", _APP_CONFIG_SCREEN_SIZE_VALUE, _APP_CONFIG_CHANGES_DEFAULT_VALUE);
        }
        return configChangesValue;
    }

    private static ByteArrayOutputStream _setXslInclude(AndroidFileUtils af, Logger logger) throws DeployException {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream = null;
        try {
            ArrayList<XSLParameter> xslParamList = new ArrayList<XSLParameter>();
            xslParamList.add(new XSLParameter("", _XSL_PARAM_HREF, af.getTransformUtilitiesXslUrl().toExternalForm()));
            inputStream = af.getXslSetIncludesXslUrl().openStream();
            byteArrayOutputStream = XMLTransformer.transformXml(inputStream, af.getAndroidPreferenceXslURL(), xslParamList, logger);
        }
        catch (Exception e) {
            try {
                throw new DeployException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(inputStream, logger);
                throw throwable;
            }
        }
        FileUtils.closeStream(inputStream, logger);
        return byteArrayOutputStream;
    }

    private static List<XSLParameter> _createXslParameterList(AndroidFileUtils af, AndroidOptions androidOptions, Logger logger) throws DeployException {
        ArrayList<XSLParameter> xslParamList = new ArrayList<XSLParameter>();
        xslParamList.add(new XSLParameter("", _XSL_PARAM_TARGET_DIR_PATH, af.getApplicationResourceOutputURL().toExternalForm()));
        xslParamList.add(new XSLParameter("", _XSL_PARAM_APPLICATION_PACKAGE, af.getApplicationPackageName(androidOptions)));
        try {
            XSLParameter xslLocalesParam = AndroidXslLocaleData.getLocaleDataElementsParameter(af, logger);
            xslParamList.add(xslLocalesParam);
            List<URL> farList = af.getFeatureFarExtractionFolderUrls();
            NodeList farUrlNodeList = XSLParameter.createNodeList(_FAR_URL_XML_ELEMENT_NAME, farList, new XSLParameter.ListVisitor(){

                @Override
                public String getStringRepresentation(Object listElement) {
                    if (listElement instanceof URL) {
                        URL farUrl = (URL)listElement;
                        return farUrl.toExternalForm();
                    }
                    return "";
                }
            });
            xslParamList.add(new XSLParameter("", _XSL_PARAM_FEATURE_ARCHIVE_URL_NODE_SET, farUrlNodeList));
        }
        catch (Exception e) {
            throw new DeployException((Throwable)e);
        }
        xslParamList.add(new XSLParameter("", _XSL_PARAM_FEATURE_XML_RELATIVE_PATH_IN_FAR, ADFMobileConstants.FEATURE_XML_FAR_PATH));
        URL applicationBaseXliffUrl = McAppUtils.getApplicationAdfMetaInfUrl(af.getWorkspace());
        xslParamList.add(new XSLParameter("", _XSL_PARAM_APPLICATION_XLIFF_BASE_PATH, applicationBaseXliffUrl.toExternalForm()));
        return xslParamList;
    }

    private static void _createFile(URL fileUrl, String fileContent, Logger logger) throws DeployException {
        ByteArrayInputStream byteArrayIs = null;
        try {
            String platformDependentUrl = URLFileSystem.getPlatformPathName((URL)fileUrl);
            byteArrayIs = new ByteArrayInputStream(fileContent.getBytes());
            URLFileSystem.copy((InputStream)byteArrayIs, (URL)URLFactory.newFileURL((String)platformDependentUrl));
        }
        catch (IOException e) {
            try {
                throw new DeployException(e.getMessage());
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(byteArrayIs, logger);
                throw throwable;
            }
        }
        FileUtils.closeStream(byteArrayIs, logger);
    }

    private static char[] _getKeystorePassword(AndroidOptions androidOptions) throws DeployException {
        char[] paddedEncryptedPassword = null;
        char[] paddedDecryptedPassword = null;
        char[] decryptedPassword = null;
        try {
            Preferences preferences = Preferences.getPreferences();
            PlatformSDKsPrefs platformPrefs = PlatformSDKsPrefs.getInstance((PropertyStorage)preferences);
            paddedEncryptedPassword = androidOptions.getIsDebugMode() ? platformPrefs.getAndroidDebugSigningPassword() : platformPrefs.getAndroidReleaseSigningKeystorePassword();
            decryptedPassword = AndroidDeployer._getDecryptedSigningPassword(platformPrefs, androidOptions, paddedEncryptedPassword);
        }
        catch (DeployException e) {
            try {
                EncryptionUtils.zeroCharBuffer(decryptedPassword);
                throw e;
            }
            catch (Throwable throwable) {
                EncryptionUtils.zeroCharBuffer(paddedEncryptedPassword);
                EncryptionUtils.zeroCharBuffer(paddedDecryptedPassword);
                throw throwable;
            }
        }
        EncryptionUtils.zeroCharBuffer(paddedEncryptedPassword);
        EncryptionUtils.zeroCharBuffer(paddedDecryptedPassword);
        return decryptedPassword;
    }

    private static char[] _getKeyPassword(AndroidOptions androidOptions) throws DeployException {
        char[] paddedEncryptedPassword = null;
        char[] paddedDecryptedPassword = null;
        char[] decryptedPassword = null;
        try {
            Preferences preferences = Preferences.getPreferences();
            PlatformSDKsPrefs platformPrefs = PlatformSDKsPrefs.getInstance((PropertyStorage)preferences);
            paddedEncryptedPassword = androidOptions.getIsDebugMode() ? platformPrefs.getAndroidDebugSigningPassword() : platformPrefs.getAndroidReleaseSigningKeyPassword();
            decryptedPassword = AndroidDeployer._getDecryptedSigningPassword(platformPrefs, androidOptions, paddedEncryptedPassword);
        }
        catch (DeployException e) {
            try {
                EncryptionUtils.zeroCharBuffer(decryptedPassword);
                throw e;
            }
            catch (Throwable throwable) {
                EncryptionUtils.zeroCharBuffer(paddedEncryptedPassword);
                EncryptionUtils.zeroCharBuffer(paddedDecryptedPassword);
                throw throwable;
            }
        }
        EncryptionUtils.zeroCharBuffer(paddedEncryptedPassword);
        EncryptionUtils.zeroCharBuffer(paddedDecryptedPassword);
        return decryptedPassword;
    }

    private static URL _getKeystoreUrl(AndroidOptions androidOptions, AndroidFileUtils af) {
        URL keystoreUrl = null;
        if (androidOptions.getIsDebugMode()) {
            keystoreUrl = URLFactory.newURL((URL)af.getOutputDirectoryURL(), (String)_DEBUG_KEYSTORE_FILE_NAME);
        } else {
            Preferences preferences = Preferences.getPreferences();
            PlatformSDKsPrefs platformPrefs = PlatformSDKsPrefs.getInstance((PropertyStorage)preferences);
            String keystoreFile = platformPrefs.getAndroidReleaseSigningKeystorePath();
            if (ModelUtil.hasLength((String)keystoreFile)) {
                keystoreUrl = URLFactory.newURL((String)keystoreFile);
            }
        }
        return keystoreUrl;
    }

    private static String _getKeyDistinguishedName(AndroidOptions androidOptions) {
        if (androidOptions.getIsDebugMode()) {
            String _DEBUG_KEY_DIST_NAME = "CN=Android Debug, O=Android, C=US";
            return "CN=Android Debug, O=Android, C=US";
        }
        return null;
    }

    private static String _getKeyValidity(AndroidOptions androidOptions) {
        if (androidOptions.getIsDebugMode()) {
            String _DEBUG_KEY_VALIDITY = "1";
            return "1";
        }
        return null;
    }

    private static String _getKeyAlias(AndroidOptions androidOptions) {
        String keyAlias = null;
        if (androidOptions.getIsDebugMode()) {
            String _DEBUG_KEY_ALIAS = "androiddebugkey";
            keyAlias = "androiddebugkey";
        } else {
            Preferences preferences = Preferences.getPreferences();
            PlatformSDKsPrefs platformPrefs = PlatformSDKsPrefs.getInstance((PropertyStorage)preferences);
            keyAlias = platformPrefs.getAndroidReleaseSigningKeyAlias();
        }
        return keyAlias;
    }

    private static String _getPreferenceConfigLabel(String decoratedPreferenceLabel) {
        return DeployFileUtils.stripMnemonicAndColonFromLabel(MobileResourceUtils.getText(decoratedPreferenceLabel));
    }

    private static String _getJavaSourcePathFromPackageName(AndroidFileUtils af, String javaFileName, String packageName) {
        String androidJavaSourcePath = URLFileSystem.getPlatformPathName((URL)af.getJavaSourceURL());
        String pathFromPackageName = packageName.replaceAll(_PERIOD_REGEX, "/");
        StringBuilder pathStringBuilder = new StringBuilder();
        pathStringBuilder.append(androidJavaSourcePath);
        pathStringBuilder.append("/");
        pathStringBuilder.append(pathFromPackageName);
        pathStringBuilder.append("/");
        pathStringBuilder.append(javaFileName);
        URL resourcePathUrl = URLFactory.newFileURL((String)pathStringBuilder.toString());
        return URLFileSystem.getPlatformPathName((URL)resourcePathUrl);
    }

    private static void _cleanupApplicationResources(AndroidFileUtils af) throws IOException {
        FileUtils.deleteFile(af.getApplicationPreferencesXmlUrl());
        FileUtils.deleteFile(af.getApplicationConfigXmlUrl());
        FileUtils.deleteFile(af.getDefaultStringsXmlFileUrl());
        FileUtils.deleteFile(af.getDefaultArraysXmlFileUrl());
        URLFilenameFilter localizedValuesFolderFilter = new URLFilenameFilter(){
            private static final String _VALUES_FOLDER_PREFIX = "values-";

            public boolean accept(URL url, String fileOrFolderName) {
                if (fileOrFolderName.startsWith(_VALUES_FOLDER_PREFIX)) {
                    URL testUrl = URLFactory.newURL((URL)url, (String)fileOrFolderName);
                    return URLFileSystem.isDirectory((URL)testUrl);
                }
                return false;
            }
        };
        URL[] localizedValuesFolderUrlArray = URLFileSystem.list((URL)af.getApplicationResourceOutputURL(), (URLFilenameFilter)localizedValuesFolderFilter);
        if (null != localizedValuesFolderUrlArray) {
            for (int i = 0; i < localizedValuesFolderUrlArray.length; ++i) {
                FileUtils.deleteDirectory(localizedValuesFolderUrlArray[i]);
            }
        }
    }

    private static void _cleanupRJavaAndClassFiles(AndroidFileUtils af) throws IOException {
        URL deployRJavaSrcDirUrl = af.getJavaSourceURL();
        FileUtils.deleteDirectory(deployRJavaSrcDirUrl);
        FileUtils.createDirectory(deployRJavaSrcDirUrl);
        URL deployRClassDirUrl = af.getAndroidRClassFileUrl();
        FileUtils.deleteDirectory(deployRClassDirUrl);
        FileUtils.createDirectory(deployRClassDirUrl);
    }

    private static char[] _getDecryptedSigningPassword(PlatformSDKsPrefs platformPrefs, AndroidOptions androidOptions, char[] paddedEncryptedPassword) throws DeployException {
        char[] paddedDecryptedPassword = null;
        char[] decryptedPassword = null;
        try {
            if (EncryptionUtils.hasLength(paddedEncryptedPassword)) {
                paddedDecryptedPassword = EncryptionUtils.decryptWithPadding(paddedEncryptedPassword);
                if (EncryptionUtils.hasLength(paddedDecryptedPassword)) {
                    decryptedPassword = EncryptionUtils.removeZeroPad(paddedDecryptedPassword);
                }
            } else if (androidOptions.getIsDebugMode()) {
                decryptedPassword = platformPrefs.getAndroidDefaultDebugSigningPassword();
            }
        }
        catch (DeployException e) {
            try {
                EncryptionUtils.zeroCharBuffer(decryptedPassword);
                throw e;
            }
            catch (Throwable throwable) {
                EncryptionUtils.zeroCharBuffer(paddedDecryptedPassword);
                throw throwable;
            }
        }
        EncryptionUtils.zeroCharBuffer(paddedDecryptedPassword);
        return decryptedPassword;
    }

    private static Set<String> _getConfiguredExtraPackages(Logger logger) throws DeployException {
        DeployPropertiesFileUtil properties = new DeployPropertiesFileUtil(logger);
        Set<String> configuredExtraPackages = properties.getMultiValuedProperty("android.aapt.extra.packages", "", ",", true);
        AndroidDeployer._validateConfiguredExtraPackages(properties.getFileUrl(), configuredExtraPackages);
        return configuredExtraPackages;
    }

    private static void _validateConfiguredExtraPackages(URL propertyFileUrl, Set<String> extraPackages) throws DeployException {
        ArrayList<String> invalidPackageNames = new ArrayList<String>();
        for (String currPackage : extraPackages) {
            if (AndroidDeployUtil.isValidPackageName(currPackage)) continue;
            invalidPackageNames.add(currPackage);
        }
        if (!invalidPackageNames.isEmpty()) {
            String invalidPackages = DeployUtil.stringListToString(invalidPackageNames, "\n");
            String errMessage = MobileResourceUtils.getMsg("ADF-MBL-01615", URLFileSystem.getPlatformPathName((URL)propertyFileUrl), "android.aapt.extra.packages", invalidPackages);
            throw new DeployException(errMessage);
        }
    }

    private static Set<String> _getAllExtraPackages(Logger logger) throws DeployException {
        Set<String> completeExtraPackages = AndroidDeployer._getConfiguredExtraPackages(logger);
        completeExtraPackages.addAll(_defaultExtraPackagesList);
        return completeExtraPackages;
    }

    private static String _setURLSchemeInTemplateManifest(AndroidFileUtils af, String templateManifest) {
        String urlScheme = McAppUtils.getApplicationUrlScheme(af.getWorkspace());
        if (ModelUtil.hasLength((String)urlScheme)) {
            templateManifest = templateManifest.replace(_REPLACE_PARAM_APP_URL_SCHEME_INTENT, _APPLICATION_URL_SCHEME_INTENT);
            templateManifest = templateManifest.replace(_REPLACE_PARAM_APP_URLSCHEMENAME, urlScheme);
        } else {
            templateManifest = templateManifest.replace(_REPLACE_PARAM_APP_URL_SCHEME_INTENT, "");
        }
        return templateManifest;
    }

    private static void _copyTemplateConfigXml(AndroidFileUtils af) throws DeployException {
        try {
            URL configXmlUrl = af.getFrameworkConfigXmlUrl();
            FileUtils.deleteFile(configXmlUrl);
            URL androidConfigXmlInTemplateUrl = af.getFrameworkTemplateConfigXmlUrl();
            FileUtils.copyFile(androidConfigXmlInTemplateUrl, URLFileSystem.getParent((URL)configXmlUrl), null);
        }
        catch (IOException e) {
            throw new DeployException((Throwable)e);
        }
    }

    private AndroidDeployer() {
    }

    static {
        _defaultExtraPackagesList.add(_ORACLE_IDM_MOBILE_PACKAGE_NAME);
    }
}

