/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android.core;

import java.util.ArrayList;
import java.util.List;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.android.core.ToolOptionsBase;
import oracle.adfmf.framework.dt.deploy.android.util.AndroidDeployUtil;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;

public class AaptOptions
extends ToolOptionsBase {
    private String m_pathToResourceConstantsGeneratedFile;
    private String m_pathToAndroidManifestXml;
    private final List<String> m_pathToResourceFolderList = new ArrayList<String>();
    private final List<String> m_deviceAssetList = new ArrayList<String>();
    private String m_pathToOutputApkArchiveFile;
    private final List<String> m_jarsToIncludeList = new ArrayList<String>();
    private String m_classJarFilePath;
    private List<String> m_rawAssetDirPathList = new ArrayList<String>();
    private String m_progaurdOptionsFilePath;
    private String m_publicResourceDirectoryPath;
    private String m_minSdkVersion;
    private String m_targetSdkVersion;
    private String m_maxResourceVersion;
    private final List<String> m_rawFileDirPathList = new ArrayList<String>();
    private String m_versionName;
    private String m_versionCode;
    private String m_customPackage;
    private final List<String> m_extraPackagesList = new ArrayList<String>();

    @Override
    protected void buildArgumentList() throws DeployException {
        this.verifyRequiredOptions();
        String androidPlatformToolPath = AndroidDeployUtil.getAndroidBuildToolPath("aapt");
        this.addArgumentValue(androidPlatformToolPath, this.shouldPathsBeQuoted());
        this.addAgumentsForCreateMode();
    }

    private void addArgument(AaptFlags aaptFlag) {
        this.addArgument(aaptFlag.getCommandLineFlag());
    }

    private void addArgumentAndValue(AaptFlags aaptFlag, String value, boolean surroundWithQuotes) {
        this.addArgumentAndValue(aaptFlag.getCommandLineFlag(), value, surroundWithQuotes);
    }

    public void setPathToResourceConstantsGeneratedFile(String pathToResourceConstantsGeneratedFile) {
        this.m_pathToResourceConstantsGeneratedFile = pathToResourceConstantsGeneratedFile;
    }

    public void setPathToAndroidManifestXml(String pathToAndroidManifestXml) {
        this.m_pathToAndroidManifestXml = pathToAndroidManifestXml;
    }

    public void setPathToResourceDirPathList(List<String> pathToResourceFolderList) {
        this.m_pathToResourceFolderList.addAll(pathToResourceFolderList);
    }

    public void setDeviceAssetList(List<String> deviceAssetList) {
        this.m_deviceAssetList.addAll(deviceAssetList);
    }

    public void setPathToOutputApkArchiveFile(String pathToOutputApkArchiveFile) {
        this.m_pathToOutputApkArchiveFile = pathToOutputApkArchiveFile;
    }

    public void setJarsToIncludeList(List<String> jarsToIncludeList) {
        this.m_jarsToIncludeList.addAll(jarsToIncludeList);
    }

    public void setClassJarFilePath(String classJarFilePath) {
        this.m_classJarFilePath = classJarFilePath;
    }

    public void setRawAssetDirPathList(List<String> rawAssetDirPathList) {
        this.m_rawAssetDirPathList.addAll(rawAssetDirPathList);
    }

    public void setRawFileDirPathList(List<String> rawFileDirPathList) {
        this.m_rawFileDirPathList.addAll(rawFileDirPathList);
    }

    public void setProgaurdOptionsFilePath(String progaurdOptionsFilePath) {
        this.m_progaurdOptionsFilePath = progaurdOptionsFilePath;
    }

    public void setPublicResourceDirectoryPath(String publicResourceDirectoryPath) {
        this.m_publicResourceDirectoryPath = publicResourceDirectoryPath;
    }

    public void setMinSdkVersion(String minSdkVersion) {
        this.m_minSdkVersion = minSdkVersion;
    }

    public void setMaxResourceVersion(String maxResourceVersion) {
        this.m_maxResourceVersion = maxResourceVersion;
    }

    public void setVersionName(String versionName) {
        this.m_versionName = versionName;
    }

    public void setVersionCode(String versionCode) {
        this.m_versionCode = versionCode;
    }

    public void setCustomPackage(String customPackage) {
        this.m_customPackage = customPackage;
    }

    public void setTargetSdkVersion(String targetSdkVersion) {
        this.m_targetSdkVersion = targetSdkVersion;
    }

    public void setExtraPackagesList(List<String> extraPackagesList) {
        this.m_extraPackagesList.addAll(extraPackagesList);
    }

    private void verifyRequiredOptions() throws DeployException {
        if (!ModelUtil.hasLength((String)this.m_pathToOutputApkArchiveFile)) {
            String exceptionMsg = MobileResourceUtils.getMsg("ADF-MBL-00039", "aapt", AaptFlags.OUTPUT_APK_ARCHIVE_FILE_PATH.getCommandLineFlag());
            throw new DeployException(exceptionMsg);
        }
    }

    private void addAgumentsForCreateMode() {
        this.addArgument(AaptFlags.PACKAGE);
        if (this.getIsVerboseMode()) {
            this.addArgument(AaptFlags.VERBOSE);
        }
        if (this.getIsDebugMode()) {
            this.addArgument(AaptFlags.DEBUG_MODE);
        }
        this.addArgumentAsDelimitedList(AaptFlags.DEVICE_ASSETS.getCommandLineFlag(), ",", this.m_deviceAssetList, this.shouldPathsBeQuoted());
        this.addArgument(AaptFlags.OVERWRITE_EXISTING_FILES);
        if (ModelUtil.hasLength((String)this.m_pathToResourceConstantsGeneratedFile)) {
            this.addArgument(AaptFlags.MAKE_PACKAGE_DIRECTORIES_FOR_GENERATED_RESOURCE_CONSTANT_DEFINITION_FILE);
            this.addArgumentAndValue(AaptFlags.DIRECTORY_FOR_GENERATED_RESOURCE_CONSTANT_DEFINITION_FILE, this.m_pathToResourceConstantsGeneratedFile, this.shouldPathsBeQuoted());
        }
        this.addArgumentAndValue(AaptFlags.ANDROID_MANIFEST_FILE_PATH, this.m_pathToAndroidManifestXml, this.shouldPathsBeQuoted());
        this.addArgumentAndValue(AaptFlags.INCLUDE_CLASS_JAR_FILE, this.m_classJarFilePath, this.shouldPathsBeQuoted());
        this.addArgumentAndValue(AaptFlags.OUTPUT_PROGAURD_OPTIONS_FILE_PATH, this.m_progaurdOptionsFilePath, this.shouldPathsBeQuoted());
        this.addArgumentAndValue(AaptFlags.OUTPUT_PUBLIC_RESOURCE_DIRECTORY, this.m_publicResourceDirectoryPath, this.shouldPathsBeQuoted());
        this.addArgumentAndValue(AaptFlags.MIN_SDK_VERSION, this.m_minSdkVersion, false);
        this.addArgumentAndValue(AaptFlags.TARGET_SDK_VERSION, this.m_targetSdkVersion, false);
        this.addArgumentAndValue(AaptFlags.MAX_RESOURCE_VERSION, this.m_maxResourceVersion, false);
        this.addArgumentAndValue(AaptFlags.VERSION_NAME, this.m_versionName, false);
        this.addArgumentAndValue(AaptFlags.VERSION_CODE, this.m_versionCode, false);
        if (!this.m_extraPackagesList.isEmpty()) {
            StringBuilder extraPackagesStringBuilder = new StringBuilder();
            int listSize = this.m_extraPackagesList.size();
            int currListIdx = 0;
            for (String currExtraPackage : this.m_extraPackagesList) {
                extraPackagesStringBuilder.append(currExtraPackage);
                if (++currListIdx >= listSize) continue;
                extraPackagesStringBuilder.append(":");
            }
            this.addArgumentAndValue(AaptFlags.EXTRA_PACKAGES, extraPackagesStringBuilder.toString(), false);
        }
        this.addArgumentAndValue(AaptFlags.CUSTOM_PACKAGE, this.m_customPackage, false);
        this.addArgumentAndValue(AaptFlags.OUTPUT_APK_ARCHIVE_FILE_PATH, this.m_pathToOutputApkArchiveFile, this.shouldPathsBeQuoted());
        for (String currJar : this.m_jarsToIncludeList) {
            this.addArgumentAndValue(AaptFlags.INCLUDE_EXISTING_PACKAGE, currJar, this.shouldPathsBeQuoted());
        }
        for (String currRawAssetDir : this.m_rawAssetDirPathList) {
            this.addArgumentAndValue(AaptFlags.RAW_ASSET_DIRECTORY, currRawAssetDir, this.shouldPathsBeQuoted());
        }
        for (String currResourceDir : this.m_pathToResourceFolderList) {
            this.addArgumentAndValue(AaptFlags.RESOURCE_DIRECTORY, currResourceDir, this.shouldPathsBeQuoted());
        }
        for (String currRawFileDir : this.m_rawFileDirPathList) {
            this.addArgumentValue(currRawFileDir, this.shouldPathsBeQuoted());
        }
    }

    private static enum AaptFlags {
        PACKAGE("p"),
        ADD_FILES("a"),
        DEVICE_ASSETS("-d"),
        OVERWRITE_EXISTING_FILES("-f"),
        PIXEL_TOLERANCE("-g"),
        VERBOSE("-v"),
        INCLUDE_CLASS_JAR_FILE("-j"),
        MAKE_PACKAGE_DIRECTORIES_FOR_GENERATED_RESOURCE_CONSTANT_DEFINITION_FILE("-m"),
        DIRECTORY_FOR_GENERATED_RESOURCE_CONSTANT_DEFINITION_FILE("-J"),
        ANDROID_MANIFEST_FILE_PATH("-M"),
        RESOURCE_DIRECTORY("-S"),
        INCLUDE_EXISTING_PACKAGE("-I"),
        RAW_ASSET_DIRECTORY("-A"),
        OUTPUT_APK_ARCHIVE_FILE_PATH("-F"),
        OUTPUT_PROGAURD_OPTIONS_FILE_PATH("-G"),
        OUTPUT_PUBLIC_RESOURCE_DIRECTORY("-P"),
        DEBUG_MODE("--debug-mode"),
        MIN_SDK_VERSION("--min-sdk-version"),
        TARGET_SDK_VERSION("--target-sdk-version"),
        MAX_RESOURCE_VERSION("--max-res-version"),
        VERSION_NAME("--version-name"),
        VERSION_CODE("--version-code"),
        CUSTOM_PACKAGE("--custom-package"),
        EXTRA_PACKAGES("--extra-packages");

        private final String m_flagValue;

        private AaptFlags(String flag) {
            this.m_flagValue = flag;
        }

        public String getCommandLineFlag() {
            return this.m_flagValue;
        }
    }
}

