/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.android;

import oracle.adfmf.common.util.McTechnologyUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.McProfile;
import oracle.adfmf.framework.dt.deploy.android.ui.editor.options.AndroidOptions;
import oracle.adfmf.framework.dt.deploy.editor.options.ImageOptions;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.Namespace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.LinkedDirtyable;
import oracle.jdeveloper.deploy.PlatformDeployable;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.deploy.shell.JavaDeployment;
import oracle.jdevimpl.deploy.dt.jar.ArchiveEditor;

public final class AndroidProfile
extends McProfile
implements PlatformDeployable {
    private static final Platform _PLATFORM_ANDROID = new Platform(PlatformType.JSE, "1.5", MobileResourceUtils.getText("ANDROID_TARGET_PLATFORM_LABEL"), null);
    private Workspace _workspace;

    public AndroidProfile() {
    }

    public static AndroidProfile newAndroidProfile(Workspace workspace) {
        if (null == workspace) {
            throw new IllegalArgumentException();
        }
        AndroidProfile androidProfile = new AndroidProfile();
        androidProfile._initialize(workspace);
        return androidProfile;
    }

    public static AndroidProfile newAndroidProfile(Namespace namespace) {
        if (null == namespace) {
            throw new IllegalArgumentException();
        }
        ArchiveProfile archiveProfile = ArchiveEditor.getArchiveProfile((Namespace)namespace);
        if (null == archiveProfile || !(archiveProfile instanceof AndroidProfile)) {
            throw new IllegalArgumentException();
        }
        AndroidProfile androidProfile = (AndroidProfile)archiveProfile;
        assert (null != androidProfile._workspace);
        assert (null != androidProfile.getDataContainer());
        return androidProfile;
    }

    public static AndroidProfile newAndroidProfile(DeployShell deployShell) throws DeployException {
        if (null == deployShell) {
            throw new IllegalArgumentException();
        }
        JavaDeployment d = JavaDeployment.getInstance((DeployShell)deployShell);
        Profile profile = d.getProfile();
        assert (profile != null);
        if (!(profile instanceof AndroidProfile)) {
            throw new DeployException("Deployment Profile is not a subclass of AndroidProfile.");
        }
        AndroidProfile androidProfile = (AndroidProfile)profile;
        assert (null != androidProfile._workspace);
        assert (null != androidProfile.getDataContainer());
        return androidProfile;
    }

    public static AndroidProfile newAndroidProfile(HashStructure hash, Workspace workspace) {
        if (null == workspace || null == hash) {
            throw new IllegalArgumentException();
        }
        AndroidProfile androidProfile = new AndroidProfile(hash);
        androidProfile._initialize(workspace);
        return androidProfile;
    }

    public Object copyTo(Object target) {
        this._verifyState();
        if (null != target && !(target instanceof AndroidProfile)) {
            throw new IllegalArgumentException();
        }
        boolean copyIntoNewInstance = null == target;
        Object copy = super.copyTo(target);
        this._copyToImpl(copy, copyIntoNewInstance);
        return copy;
    }

    public AndroidOptions getAndroidOptions() {
        this._verifyState();
        String optionsHashKey = AndroidOptions.getHashStructureKeyName();
        HashStructure optionsHash = this._hash.getOrCreateHashStructure(optionsHashKey);
        AndroidOptions androidOptions = AndroidOptions.newAndroidOptions(optionsHash, this._workspace);
        return androidOptions;
    }

    public void setAndroidOptions(AndroidOptions androidOptions) {
        this._verifyState();
        if (ModelUtil.areDifferent((Object)((Object)this.getAndroidOptions()), (Object)((Object)androidOptions))) {
            this._setAndroidOptionsImpl(androidOptions);
            this.markDirty(true);
        }
    }

    public ImageOptions getImageOptions() {
        String imageOptionsKey = "mnfImageOptions";
        HashStructure imageHash = this._hash.getOrCreateHashStructure("mnfImageOptions");
        return new ImageOptions(imageHash);
    }

    public void setImageOptions(ImageOptions imageOptions) {
        if (imageOptions == null) {
            throw new IllegalArgumentException();
        }
        if (ModelUtil.areDifferent((Object)((Object)this.getImageOptions()), (Object)((Object)imageOptions))) {
            this._setImageOptionsImpl(imageOptions);
            this.markDirty(true);
        }
    }

    public Platform getPlatform() {
        return _PLATFORM_ANDROID;
    }

    public void setPlatform(Platform platform) {
        assert (false);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        this._verifyState();
        return this._equalsImpl((AndroidProfile)((Object)o));
    }

    public int hashCode() {
        this._verifyState();
        int PRIME = 31;
        int result = 17;
        result = 31 * result + ModelUtil.hashCodeFor((Object)this._hash);
        result = 31 * result + ModelUtil.hashCodeFor((Object)this._workspace);
        return result;
    }

    @Override
    protected Workspace getWorkspace() {
        return this._workspace;
    }

    private AndroidProfile(HashStructure hashStructure) {
        super(hashStructure);
    }

    private void _initialize(Workspace workspace) {
        if (null == workspace) {
            throw new IllegalArgumentException();
        }
        if (null != this._workspace) {
            throw new IllegalStateException();
        }
        this._workspace = workspace;
        Project project = McTechnologyUtils.findFirstUIProjectInWorkspace(this._workspace);
        this.setDataContainer((DataContainer)project);
    }

    private void _setAndroidOptionsImpl(AndroidOptions androidOptions) {
        this.unlinkEmbeddedDirtyable((LinkedDirtyable)this.getAndroidOptions());
        this.getHashStructure().putHashStructure(AndroidOptions.getHashStructureKeyName(), androidOptions.getHashStructure());
        this.linkEmbeddedDirtyable((LinkedDirtyable)this.getAndroidOptions());
    }

    private void _setImageOptionsImpl(ImageOptions imageOptions) {
        this.unlinkEmbeddedDirtyable((LinkedDirtyable)this.getImageOptions());
        this._hash.putHashStructure("mnfImageOptions", imageOptions.getHashStructure());
        this.linkEmbeddedDirtyable((LinkedDirtyable)this.getImageOptions());
    }

    private void _copyToImpl(Object copyTarget, boolean copyIntoNewInstance) {
        assert (copyTarget instanceof AndroidProfile);
        AndroidProfile androidProfile = (AndroidProfile)((Object)copyTarget);
        if (!copyIntoNewInstance) {
            androidProfile._workspace = null;
        }
        androidProfile._initialize(this._workspace);
    }

    private boolean _equalsImpl(AndroidProfile otherProfile) {
        return super.equals((Object)otherProfile) && ModelUtil.areEqual((Object)this._workspace, (Object)otherProfile._workspace);
    }

    private void _verifyState() {
        if (null == this._workspace || null == this.getDataContainer()) {
            throw new IllegalStateException();
        }
    }
}

