/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy;

import java.net.URL;
import java.util.Iterator;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.deploy.McPackagingOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.LinkedDirtyable;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;

public abstract class McProfile
extends ArchiveProfile {
    public McProfile(HashStructure hashStructure) {
        super(hashStructure);
    }

    public McProfile() {
    }

    public void setJarURL(URL jarURL) {
        URL adfmfJarUrl = this.createAdfMobileJarUrl(jarURL);
        super.setJarURL(adfmfJarUrl);
    }

    public McPackagingOptions getMcPackagingOptions() {
        HashStructure mcPackagingOptionsHash = this._hash.getOrCreateHashStructure("packagingOptions");
        return new McPackagingOptions(mcPackagingOptionsHash);
    }

    public void setMcPackagingOptions(McPackagingOptions mcPackagingOptions) {
        if (mcPackagingOptions == null) {
            throw new IllegalArgumentException();
        }
        if (ModelUtil.areDifferent((Object)((Object)this.getMcPackagingOptions()), (Object)((Object)mcPackagingOptions))) {
            this._setMcPackagingOptionsImpl(mcPackagingOptions);
            this.markDirty(true);
        }
    }

    public Iterator<Element> getChildren() {
        return null;
    }

    protected abstract Workspace getWorkspace();

    protected URL createAdfMobileJarUrl(URL jarUrl) {
        URL appRootUrl = URLFactory.newDirURL((URL)McAppUtils.getAppRootURL(this.getWorkspace()), (String)"deploy");
        URL deployProfileFolder = URLFactory.newDirURL((URL)appRootUrl, (String)this.getName());
        URL newJarURL = URLFactory.newDirURL((URL)deployProfileFolder, (String)URLFileSystem.getFileName((URL)jarUrl));
        return newJarURL;
    }

    private void _setMcPackagingOptionsImpl(McPackagingOptions mcPackagingOptions) {
        this.unlinkEmbeddedDirtyable((LinkedDirtyable)this.getMcPackagingOptions());
        if (mcPackagingOptions != null) {
            this._hash.putHashStructure("packagingOptions", mcPackagingOptions.getHashStructure());
        } else {
            this._hash.putHashStructure("packagingOptions", null);
        }
        this.linkEmbeddedDirtyable((LinkedDirtyable)this.getMcPackagingOptions());
    }
}

