/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.McTechnologyUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.McProfile;
import oracle.adfmf.framework.dt.deploy.editor.options.ImageOptions;
import oracle.adfmf.framework.dt.deploy.features.FeatureArchiveProfile;
import oracle.adfmf.framework.dt.deploy.features.FeatureArchiveProfileFactory;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.Context;
import oracle.ide.file.FileTable;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DependableFactory;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeploymentProfiles;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.common.LibraryDependencies;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.model.ApplicationContent;
import oracle.jdeveloper.model.JavaProject;

public abstract class DeployFileUtils {
    private final Workspace m_workspace;
    private Project m_project = null;
    private final McProfile m_profile;
    private String m_deploymentProfileName = null;
    private URL m_outputDirectoryURL;
    private URL m_jarURL;
    private URL m_applicationAdfUrl;
    private static final String TRANSFORM_UTILITIES_XSL_JAR_ENTRY_PATH = "oracle/adfmf/framework/dt/deploy/common/transform/TransformUtilities.xsl";
    private static final String SET_INCLUDES_XSL_JAR_ENTRY_PATH = "oracle/adfmf/framework/dt/deploy/common/transform/SetIncludes.xsl";
    protected static final String ADF_CONFIGURATION_XML_DEPLOYMENT_DIRECTORY_NAME = "Configuration";

    public DeployFileUtils(Workspace workspace, McProfile profile) {
        assert (null != profile);
        assert (null != workspace);
        this.m_workspace = workspace;
        this.m_profile = profile;
    }

    public URL getAdfmfApplicationXmlFileUrl() {
        return McAppUtils.getApplicationXmlURL(this.getWorkspace());
    }

    public URL getCacertsFileUrl() {
        return McAppUtils.getCacertsFileUrl(this.getWorkspace());
    }

    public URL getProjectAdfmfFeatureXmlFileUrl() {
        return McAppUtils.getProjectFeatureXmlUrl(this.getProject());
    }

    public URL getAdfmfJarEntryUrl(String jarEntryPath) {
        return this.getClass().getClassLoader().getResource(jarEntryPath);
    }

    public Workspace getWorkspace() {
        return this.m_workspace;
    }

    public Project getProject() {
        if (null == this.m_project) {
            this.m_project = McTechnologyUtils.findFirstUIProjectInWorkspace(this.m_workspace);
        }
        return this.m_project;
    }

    public URL getApplicationControllerDeployDirURL() {
        URL farsDeployURL = this.getDeploymentFARsURL();
        return URLFactory.newDirURL((URL)farsDeployURL, (String)McAppUtils.getApplicationControllerFolderName(this.getWorkspace()));
    }

    public McProfile getProfile() {
        return this.m_profile;
    }

    protected String getDeploymentProfileName() {
        if (!ModelUtil.hasLength((String)this.m_deploymentProfileName)) {
            this.m_deploymentProfileName = this.m_profile.getName();
        }
        return this.m_deploymentProfileName;
    }

    public abstract URL getDeploymentAdfmfApplicationXmlFileUrl();

    public abstract URL getDeploymentCacertsFileUrl();

    public abstract URL getDeploymentAdfmfFeatureXmlFileUrl();

    public abstract boolean doesTemplateExist();

    public static void copyAdfMobileXmlFiles(DeployFileUtils deployFileUtils) throws IOException {
        URL adfmfAppXmlFileUrl = deployFileUtils.getAdfmfApplicationXmlFileUrl();
        URL destinationFileUrl = deployFileUtils.getDeploymentAdfmfApplicationXmlFileUrl();
        URLFileSystem.copy((URL)adfmfAppXmlFileUrl, (URL)destinationFileUrl);
    }

    public static void copyCacertsFile(DeployFileUtils deployFileUtils) throws IOException {
        URL appCacertsFileUrl = deployFileUtils.getCacertsFileUrl();
        URL destinationCacertsFileUrl = deployFileUtils.getDeploymentCacertsFileUrl();
        if (URLFileSystem.exists((URL)appCacertsFileUrl)) {
            URLFileSystem.copy((URL)appCacertsFileUrl, (URL)destinationCacertsFileUrl);
        }
    }

    public abstract void copyPlatformSpecificSecurityFiles() throws IOException;

    public void copyCvmAndLoggingPropertiesFiles(URL destinationURLforCVM, URL destinationURLforLogging) throws IOException {
        URL metaInfURL = McAppUtils.getApplicationSrcMetaInfDirURL(this.m_workspace);
        URL cvmPropertiesURL = URLFactory.newDirURL((URL)metaInfURL, (String)"cvm.properties");
        URL logPropertiesURL = URLFactory.newDirURL((URL)metaInfURL, (String)"logging.properties");
        if (URLFileSystem.exists((URL)cvmPropertiesURL)) {
            URLFileSystem.copy((URL)cvmPropertiesURL, (URL)URLFactory.newDirURL((URL)destinationURLforCVM, (String)"cvm.properties"));
        }
        if (URLFileSystem.exists((URL)logPropertiesURL)) {
            URLFileSystem.copy((URL)logPropertiesURL, (URL)URLFactory.newDirURL((URL)destinationURLforLogging, (String)"logging.properties"));
        }
    }

    public URL getOutputDirectoryURL() {
        if (this.m_outputDirectoryURL == null) {
            URL rootUrl = URLFactory.newDirURL((URL)this._getAppRootURL(), (String)"deploy");
            this.m_outputDirectoryURL = URLFactory.newDirURL((URL)rootUrl, (String)this.getDeploymentProfileName());
        }
        return this.m_outputDirectoryURL;
    }

    public URL getJarURL() throws DeployException {
        if (null == this.m_jarURL) {
            this.m_jarURL = this.m_profile.getJarURL();
            if (null == this.m_jarURL) {
                throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00051"), (Object)this.m_profile.getName());
            }
        }
        return this.m_jarURL;
    }

    public static String createProjectFarName(Project project) {
        return URLFileSystem.getName((URL)project.getURL());
    }

    public static String getProjectFarFileName(Project project) {
        String farName = DeployFileUtils.createProjectFarName(project);
        return farName + ".jar";
    }

    public URL getApplicationAdfFolderUrl() {
        if (null == this.m_applicationAdfUrl) {
            ApplicationContent appContent = ApplicationContent.getInstance((Workspace)this.getWorkspace());
            URL adfSourceDirectoryUrl = appContent.getADFSourceURL();
            boolean adfDirectoryExists = URLFileSystem.exists((URL)adfSourceDirectoryUrl);
            boolean isDirectory = URLFileSystem.isDirectory((URL)adfSourceDirectoryUrl);
            if (adfDirectoryExists && isDirectory) {
                this.m_applicationAdfUrl = adfSourceDirectoryUrl;
            }
        }
        return this.m_applicationAdfUrl;
    }

    public URL getTransformUtilitiesXslUrl() {
        return this.getAdfmfJarEntryUrl(TRANSFORM_UTILITIES_XSL_JAR_ENTRY_PATH);
    }

    public URL getXslSetIncludesXslUrl() {
        return this.getAdfmfJarEntryUrl(SET_INCLUDES_XSL_JAR_ENTRY_PATH);
    }

    public abstract URL getDeploymentAdfmfConfigURL();

    public URL getDeploymentAdfmfSkinsURL() {
        URL deployedAppControllerFarUrl = this.getApplicationControllerDeployDirURL();
        URL configDirectory = URLFactory.newDirURL((URL)deployedAppControllerFarUrl, (String)"META-INF");
        return FileUtils.newFileUrl(configDirectory, "adfmf-skins.xml");
    }

    public URL getAmxCssURL() {
        URL cssURL = URLFactory.newDirURL((URL)this.getApplicationWebContentURL(), (String)"css");
        return URLFactory.newDirURL((URL)cssURL, (String)"amx.css");
    }

    public URL getAppDeployerSkinsURL(URL appControllerWebContentURL) {
        return URLFactory.newDirURL((URL)appControllerWebContentURL, (String)"skins");
    }

    public URL getJavaScriptSourceZipURL() {
        URL zipFileUrl = null;
        URL supportFilesDirectoryURL = FileUtils.getSupportFilesDirectoryUrl();
        URL javascriptSrcDir = URLFactory.newDirURL((URL)supportFilesDirectoryURL, (String)"javascript");
        zipFileUrl = this.isDebugMode() ? URLFactory.newDirURL((URL)javascriptSrcDir, (String)"ADFmf_AmxJavascript_debug.zip") : URLFactory.newDirURL((URL)javascriptSrcDir, (String)"ADFmf_AmxJavascript_release.zip");
        return URLFactory.newJarURL((URL)zipFileUrl, null);
    }

    public abstract URL getPlatformSpecificJavaScriptSourceZipURL();

    public static List<XMLSourceNode> getProjectXmlSourceNodesFromIndex(Workspace workspace, Project project, QueryCriteria queryCriteria, Logger logger) throws DeployException, IllegalArgumentException {
        Index projectIndex = null;
        List<XMLSourceNode> xmlFileList = null;
        if (null == workspace || null == project || null == queryCriteria || null == logger) {
            throw new IllegalArgumentException();
        }
        try {
            projectIndex = IndexManager.getIndexManager().getIndex(workspace, project);
            if (null != projectIndex) {
                projectIndex.lock();
                URL[] urlArray = projectIndex.blockingQuery(queryCriteria);
                ArrayList<URL> invalidFileUrlList = new ArrayList<URL>();
                URL projectOutputDirUrl = JavaProject.getInstance((Project)project).getOutputDirectory();
                xmlFileList = DeployFileUtils._createProjectXmlSourceNodes(Arrays.asList(urlArray), invalidFileUrlList, projectOutputDirUrl);
                if (!invalidFileUrlList.isEmpty()) {
                    DeployFileUtils._invalidateDirectories(invalidFileUrlList, URLFileSystem.getName((URL)project.getURL()), logger);
                    URL[] updatedUrlArray = projectIndex.blockingQuery(queryCriteria);
                    invalidFileUrlList.clear();
                    xmlFileList = DeployFileUtils._createProjectXmlSourceNodes(Arrays.asList(updatedUrlArray), invalidFileUrlList, projectOutputDirUrl);
                    if (!invalidFileUrlList.isEmpty()) {
                        throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02010", URLFileSystem.getName((URL)project.getURL())));
                    }
                }
            }
            if (null == xmlFileList) {
                xmlFileList = new ArrayList<XMLSourceNode>();
            }
        }
        catch (Exception e) {
            throw new DeployException((Throwable)e);
        }
        finally {
            if (null != projectIndex) {
                projectIndex.unlock();
                projectIndex.release();
                projectIndex = null;
            }
        }
        return xmlFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilesToExistingZip(URL zipFileURL, URL newFilesBasePathURL, Logger logger) throws IOException, IllegalArgumentException {
        File zipFile = new File(zipFileURL.getFile());
        File tempFile = File.createTempFile(zipFile.getName(), null);
        File basePathDir = new File(newFilesBasePathURL.getPath());
        if (!basePathDir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        File[] filesToAdd = basePathDir.listFiles();
        if (!tempFile.delete() || !zipFile.renameTo(tempFile)) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01009", zipFile.getAbsolutePath());
            throw new IOException(msg);
        }
        byte[] buf = new byte[1024];
        ZipInputStream zIn = null;
        ZipOutputStream zOut = null;
        try {
            zIn = new ZipInputStream(new FileInputStream(tempFile));
            zOut = new ZipOutputStream(new FileOutputStream(zipFile));
            ZipEntry entry = zIn.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                boolean notInFiles = true;
                for (File file : filesToAdd) {
                    if (!file.getName().equals(name) || !file.exists()) continue;
                    notInFiles = false;
                    break;
                }
                if (notInFiles) {
                    int len;
                    zOut.putNextEntry(new ZipEntry(name));
                    while ((len = zIn.read(buf)) > 0) {
                        zOut.write(buf, 0, len);
                    }
                }
                entry = zIn.getNextEntry();
            }
            for (int index = 0; index < filesToAdd.length; ++index) {
                FileInputStream inStream = null;
                try {
                    int len;
                    inStream = new FileInputStream(filesToAdd[index]);
                    zOut.putNextEntry(new ZipEntry(filesToAdd[index].getName()));
                    while ((len = ((InputStream)inStream).read(buf)) > 0) {
                        zOut.write(buf, 0, len);
                    }
                    zOut.closeEntry();
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(inStream, logger);
                    throw throwable;
                }
                FileUtils.closeStream(inStream, logger);
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeStream(zIn, logger);
            FileUtils.closeStream(zOut, logger);
            throw throwable;
        }
        FileUtils.closeStream(zIn, logger);
        FileUtils.closeStream(zOut, logger);
        if (!tempFile.delete()) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-21024", tempFile.getAbsolutePath());
            logger.info(msg);
        }
    }

    public static String stripMnemonicAndColonFromLabel(String label) {
        String newLabel = StringUtils.stripMnemonic((String)label);
        if (newLabel.endsWith(":")) {
            newLabel = newLabel.substring(0, newLabel.length() - 1);
        }
        return newLabel;
    }

    public static String getTrimmedStringValue(String value) {
        String valueTrimmed = value;
        if (null != valueTrimmed) {
            valueTrimmed = valueTrimmed.trim();
        }
        return valueTrimmed;
    }

    public static String getFeatureArchiveProfileName(Project project) {
        String farProfileNameSuffix = MobileResourceUtils.getText("FEATURE_ARCHIVE_NATIVE_DEFAULT_PROFILE_NAME_PREFIX");
        URL projectRootUrl = McAppUtils.getProjectRootURL(project);
        String farProfileNamePrefix = URLFileSystem.getName((URL)projectRootUrl);
        String fullProfileNamePrefix = String.format("%s_%s", farProfileNamePrefix, farProfileNameSuffix);
        int maxProfileNumber = 0;
        DeploymentProfiles currDeploymentProfiles = DeploymentProfiles.getInstance((DataContainer)project);
        Set profileNameSet = currDeploymentProfiles.getProfileNames();
        for (String currProfileName : profileNameSet) {
            String currProjectNumber;
            if (!currProfileName.startsWith(fullProfileNamePrefix) || !ModelUtil.hasLength((String)(currProjectNumber = currProfileName.substring(fullProfileNamePrefix.length())))) continue;
            try {
                int currProjectInt = Integer.valueOf(currProjectNumber, 10);
                if (currProjectInt <= maxProfileNumber) continue;
                maxProfileNumber = currProjectInt;
            }
            catch (NumberFormatException nfe) {}
        }
        String currProfileName = String.format("%s_%s%d", farProfileNamePrefix, farProfileNameSuffix, ++maxProfileNumber);
        return currProfileName;
    }

    public static void addFarProfilesToAppProfile(Collection<Project> projectCollection, Context context, McProfile appProfile) {
        FeatureArchiveProfileFactory farFactory = new FeatureArchiveProfileFactory();
        Project acProject = McAppUtils.getApplicationControllerProject(context.getWorkspace(), null);
        for (Project currProject : projectCollection) {
            URL featureXmlUrl = McAppUtils.getProjectFeatureXmlUrl(currProject);
            if (null == featureXmlUrl || !URLFileSystem.exists((URL)featureXmlUrl) && !acProject.equals((Object)currProject)) continue;
            String newProfileName = DeployFileUtils.getFeatureArchiveProfileName(currProject);
            FeatureArchiveProfile currFarProfile = (FeatureArchiveProfile)farFactory.create(newProfileName, (DataContainer)currProject, context);
            DeploymentProfiles profiles = DeploymentProfiles.getInstance((DataContainer)currProject);
            profiles.addProfile((Profile)currFarProfile);
            DeployFileUtils.addArchiveProfileAsDependency(appProfile, (ArchiveProfile)currFarProfile);
        }
    }

    public static URL getApplicationControllerFarUrl(Workspace workspace, McProfile appProfile, Logger logger) throws FileNotFoundException, DeployException {
        URL appControllerFarUrl = null;
        String appControllerFolderName = McAppUtils.getApplicationControllerFolderName(workspace);
        Project appControllerProject = McAppUtils.findApplicationControllerProject(workspace, logger, appControllerFolderName);
        if (null == appControllerProject) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00079"));
        }
        int appControllerFarCount = 0;
        List<FeatureArchiveProfile> farProfileList = DeployFileUtils.getDependentFarProfiles(appProfile);
        for (FeatureArchiveProfile currFarProfile : farProfileList) {
            if (!DeployFileUtils._isFarProfileInProject(currFarProfile, appControllerProject)) continue;
            URL currFarJarUrl = currFarProfile.getJarURL();
            if (null == appControllerFarUrl && URLFileSystem.exists((URL)currFarJarUrl)) {
                appControllerFarUrl = currFarJarUrl;
            }
            ++appControllerFarCount;
        }
        if (null == appControllerFarUrl) {
            String errMsg = MobileResourceUtils.getMsg("ADF-MBL-02009", URLFileSystem.getName((URL)appControllerProject.getURL()));
            throw new FileNotFoundException(errMsg);
        }
        if (appControllerFarCount > 1) {
            URL appControllerProjectDirUrl = URLFileSystem.getParent((URL)appControllerProject.getURL());
            String projectName = URLFileSystem.getName((URL)appControllerProjectDirUrl);
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02018", projectName));
        }
        return appControllerFarUrl;
    }

    public static void addArchiveProfileAsDependency(ArchiveProfile parentProfile, ArchiveProfile childProfile) {
        Dependable[] dependables = DeployFileUtils._createProfileDependables(childProfile);
        for (int index = 0; index < dependables.length; ++index) {
            parentProfile.addDependency(dependables[index]);
        }
    }

    public static List<FeatureArchiveProfile> getDependentFarProfiles(McProfile appProfile) {
        Object[] unselectedLibObjectArray;
        ArrayList<FeatureArchiveProfile> farProfileList = new ArrayList<FeatureArchiveProfile>();
        LibraryDependencies libDeps = appProfile.getLibraryDependencies();
        ArrayList<String> unselectedFarJarNameList = new ArrayList<String>();
        if (null != libDeps && null != (unselectedLibObjectArray = libDeps.getUnselectedLibraryNames())) {
            for (int i = 0; i < unselectedLibObjectArray.length; ++i) {
                assert (unselectedLibObjectArray[i] instanceof String);
                String currLibName = (String)unselectedLibObjectArray[i];
                unselectedFarJarNameList.add(currLibName);
            }
        }
        Iterator profileIter = appProfile.getDependencies();
        while (profileIter.hasNext()) {
            FeatureArchiveProfile currProfile;
            String farLibraryDependencyName;
            Dependable currDependable = (Dependable)profileIter.next();
            Element source = currDependable.getSource();
            if (!(source instanceof FeatureArchiveProfile) || unselectedFarJarNameList.contains(farLibraryDependencyName = (currProfile = (FeatureArchiveProfile)source).getName())) continue;
            farProfileList.add((FeatureArchiveProfile)source);
        }
        return farProfileList;
    }

    public static List<URL> getViewControllerAndFarUrlList(Workspace workspace, McProfile appProfile) throws DeployException {
        List<URL> importedFarUrlList = McAppUtils.getFeatureArchiveURLs(workspace);
        List<URL> viewControllerFarUrlList = DeployFileUtils._getViewControllerFarUrlList(workspace, appProfile);
        ArrayList<URL> completeList = new ArrayList<URL>(importedFarUrlList);
        completeList.addAll(viewControllerFarUrlList);
        return completeList;
    }

    public List<URL> getFeatureFarExtractionFolderUrls() throws DeployException {
        ArrayList<URL> farExtractionFolderUrlList = new ArrayList<URL>();
        List<URL> farJarUrlList = DeployFileUtils.getViewControllerAndFarUrlList(this.getWorkspace(), this.getProfile());
        for (URL currFarJarUrl : farJarUrlList) {
            URL farExtractionUrl = this._toExtractedFarUrl(currFarJarUrl);
            farExtractionFolderUrlList.add(farExtractionUrl);
        }
        return farExtractionFolderUrlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashStructure getDeviceTypeHash(ImageOptions imageOptions, String deviceTypeName) {
        ListStructure deviceTypes = null;
        deviceTypes = imageOptions.getImageList("deviceTypes");
        if (null == deviceTypes) {
            deviceTypes = ListStructure.newInstance();
            imageOptions.setImageList("deviceTypes", deviceTypes);
        }
        Object object = deviceTypes.iteratorLock();
        synchronized (object) {
            Iterator imageHashStructure = deviceTypes.iterator();
            HashStructure hash = null;
            while (imageHashStructure.hasNext()) {
                HashStructure currentHash = (HashStructure)imageHashStructure.next();
                String currDeviceTypeName = currentHash.getString("deviceTypeName");
                if (null == currDeviceTypeName || currDeviceTypeName.compareTo(deviceTypeName) != 0) continue;
                hash = currentHash;
                break;
            }
            if (null == hash) {
                hash = HashStructure.newInstance();
                hash.putString("deviceTypeName", deviceTypeName);
                deviceTypes.add((Object)hash);
            }
            return hash;
        }
    }

    public static void copyImage(URL applicationResourceOutputUrl, URL defaultResourcesRootFolderUrl, String configuredValue, String defaultSrcImageName, String destImageName) throws IOException, DeployException {
        URL targetUrl = null;
        boolean configuredImageExists = FileUtils.doesFileExist(configuredValue);
        targetUrl = URLFactory.newDirURL((URL)applicationResourceOutputUrl, (String)destImageName);
        URL sourceUrl = null;
        sourceUrl = configuredImageExists ? URLFactory.newFileURL((String)configuredValue) : URLFactory.newDirURL((URL)defaultResourcesRootFolderUrl, (String)defaultSrcImageName);
        if (null == sourceUrl || null == targetUrl) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00025"));
        }
        URLFileSystem.copy((URL)sourceUrl, (URL)targetUrl);
    }

    private static void _invalidateDirectories(List<URL> invalidFileUrlList, String projectName, Logger logger) {
        URL firstMissingFileUrl = invalidFileUrlList.get(0);
        String firstMissingFileName = URLFileSystem.getFileName((URL)firstMissingFileUrl);
        logger.info(MobileResourceUtils.getMsg("ADF-MBL-22006", firstMissingFileName, projectName));
        ArrayList<URL> directoryUrlList = new ArrayList<URL>();
        for (URL currUrl : invalidFileUrlList) {
            URL currDirUrl = URLFileSystem.getParent((URL)currUrl);
            if (directoryUrlList.contains(currDirUrl)) continue;
            directoryUrlList.add(currDirUrl);
        }
        for (URL currDirUrl : directoryUrlList) {
            FileTable.invalidateDirectory((URL)currDirUrl, (boolean)false);
        }
    }

    private static List<XMLSourceNode> _createProjectXmlSourceNodes(List<URL> urlList, List<URL> invalidUrlList, URL projectOutputUrl) throws IllegalArgumentException, DeployException {
        if (null == urlList || null == invalidUrlList || null == projectOutputUrl) {
            throw new IllegalArgumentException();
        }
        ArrayList<XMLSourceNode> xmlSourceNodeList = new ArrayList<XMLSourceNode>();
        try {
            invalidUrlList.clear();
            for (URL currUrl : urlList) {
                Node node;
                if (!URLFileSystem.exists((URL)currUrl)) {
                    invalidUrlList.add(currUrl);
                    continue;
                }
                if (URLFileSystem.isBaseURLFor((URL)projectOutputUrl, (URL)currUrl) || !((node = NodeFactory.findOrCreate((URL)currUrl)) instanceof XMLSourceNode)) continue;
                XMLSourceNode xmlNode = (XMLSourceNode)node;
                xmlSourceNodeList.add(xmlNode);
            }
        }
        catch (Exception e) {
            throw new DeployException((Throwable)e);
        }
        return xmlSourceNodeList;
    }

    public abstract URL getApplicationWebContentURL();

    public abstract URL getDeploymentFARsURL();

    public abstract boolean isDebugMode();

    protected abstract URL getFarsExtractionParentFolderUrl();

    private URL _toExtractedFarUrl(URL farJarUrl) {
        String currFarFolderName = URLFileSystem.getName((URL)farJarUrl);
        URL farsExtractionFolderUrl = this._getFarsDeploymentExtractionFolderUrl();
        return URLFactory.newDirURL((URL)farsExtractionFolderUrl, (String)currFarFolderName);
    }

    private URL _getFarsDeploymentExtractionFolderUrl() {
        URL farsParentFolderUrl = this.getFarsExtractionParentFolderUrl();
        return URLFactory.newDirURL((URL)farsParentFolderUrl, (String)"FARs");
    }

    private URL _getAppRootURL() {
        URL oWorkspaceURL;
        URL oAppRootURL = null;
        if (null != this.getWorkspace() && null != (oWorkspaceURL = this.getWorkspace().getURL())) {
            oAppRootURL = URLFileSystem.getParent((URL)oWorkspaceURL);
        }
        return oAppRootURL;
    }

    private static final Dependable[] _createProfileDependables(ArchiveProfile profile) {
        DataContainer parent = profile.getDataContainer();
        DependableFactory df = DependableFactory.getInstance();
        Context ctx = Context.newIdeContext();
        new DependableFactory.Parms(ctx).setParent((Element)parent);
        return df.create((Element)profile, ctx);
    }

    private static List<URL> _getViewControllerFarUrlList(Workspace workspace, McProfile appProfile) throws DeployException {
        ArrayList<URL> vcArrayList = new ArrayList<URL>();
        List<FeatureArchiveProfile> farProfileList = DeployFileUtils.getDependentFarProfiles(appProfile);
        Project appControllerProject = McAppUtils.getApplicationControllerProject(workspace, null);
        if (null == appControllerProject) {
            throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-00079"));
        }
        ArrayList<URL> projectUrlList = new ArrayList<URL>();
        for (FeatureArchiveProfile currFarProfile : farProfileList) {
            if (DeployFileUtils._isFarProfileInProject(currFarProfile, appControllerProject)) continue;
            URL currJarUrl = currFarProfile.getJarURL();
            DataContainer currDataContainer = currFarProfile.getDataContainer();
            assert (currDataContainer instanceof Project);
            Project project = (Project)currDataContainer;
            URL currProjectUrl = project.getURL();
            if (projectUrlList.contains(currProjectUrl)) {
                URL currProjectDirUrl = URLFileSystem.getParent((URL)currProjectUrl);
                String projectName = URLFileSystem.getName((URL)currProjectDirUrl);
                throw new DeployException(MobileResourceUtils.getMsg("ADF-MBL-02018", projectName));
            }
            projectUrlList.add(currProjectUrl);
            if (!URLFileSystem.exists((URL)currJarUrl)) continue;
            vcArrayList.add(currJarUrl);
        }
        return Collections.unmodifiableList(vcArrayList);
    }

    private static boolean _isFarProfileInProject(FeatureArchiveProfile farProfile, Project project) {
        if (null == farProfile || null == project) {
            throw new IllegalArgumentException();
        }
        DataContainer farProfileDataContainer = farProfile.getDataContainer();
        if (null != farProfileDataContainer && farProfileDataContainer instanceof Project) {
            Project farProject = (Project)farProfileDataContainer;
            return URLFileSystem.equals((URL)project.getURL(), (URL)farProject.getURL());
        }
        return false;
    }
}

