/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.connection.dialogs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;

public class SimpleStringTable {
    private DefaultTableModel _tableModel = new DefaultTableModel(0, 1);
    private GenericTable _table = new GenericTable((TableModel)this._tableModel);
    private JScrollPane _tableScrollPane = new JScrollPane((Component)this._table, 20, 30);
    private ReorderableTableWithTitleBar _tablePanel = new ReorderableTableWithTitleBar((JTable)this._table, (JComponent)this._tableScrollPane, false, true);

    public SimpleStringTable() {
        this._initTable();
    }

    public void setData(List<String> list) {
        int numItems = list.size();
        this._tableModel.setColumnCount(1);
        this._tableModel.setRowCount(numItems);
        for (int x = 0; x < numItems; ++x) {
            this._tableModel.setValueAt(list.get(x), x, 0);
        }
        this._tableModel.fireTableChanged(new TableModelEvent(this._tableModel));
    }

    public List<String> getData() {
        this._stopCellEditing();
        ArrayList<String> datalist = new ArrayList<String>();
        int numItems = this._tableModel.getRowCount();
        for (int x = 0; x < numItems; ++x) {
            datalist.add((String)this._tableModel.getValueAt(x, 0));
        }
        return Collections.unmodifiableList(datalist);
    }

    public JPanel getTablePanel() {
        return this._tablePanel;
    }

    public void setLabel(String label) {
        this._tablePanel.getTableToolbar().setLabel(label);
    }

    private void _initTable() {
        this._table.setTableHeader(null);
        this._table.setPreferredVisibleRowCount(5);
        this._table.setSelectionMode(0);
        SelectionListener listener = new SelectionListener();
        this._table.getSelectionModel().addListSelectionListener(listener);
        AbstractAction addAction = new AbstractAction("", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleStringTable.this._stopCellEditing();
                SimpleStringTable.this._tableModel.addRow(new Object[]{""});
                int newRowNumber = SimpleStringTable.this._tableModel.getRowCount() - 1;
                SimpleStringTable.this._table.requestFocus();
                SimpleStringTable.this._table.changeSelection(newRowNumber, 0, false, false);
                SimpleStringTable.this._table.editCellAt(newRowNumber, 0);
                SimpleStringTable.this._table.getEditorComponent().addFocusListener(new TableCellEditorFocusLostListener());
                SimpleStringTable.this._table.getEditorComponent().requestFocus();
            }
        };
        this._tablePanel.getTableToolbar().setDefaultAddAction((Action)addAction);
        AbstractAction deleteAction = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowCount;
                int row = SimpleStringTable.this._table.getSelectedRow();
                if (row != -1) {
                    SimpleStringTable.this._tableModel.removeRow(row);
                }
                if ((rowCount = SimpleStringTable.this._table.getRowCount()) == 0) {
                    SimpleStringTable.this._tablePanel.getTableToolbar().setDeleteEnabled(false);
                } else {
                    SimpleStringTable.this._tablePanel.getTableToolbar().setDeleteEnabled(true);
                    SimpleStringTable.this._table.setRowSelectionInterval(rowCount - 1, rowCount - 1);
                }
            }
        };
        this._tablePanel.getTableToolbar().setDefaultDeleteAction((Action)deleteAction);
        this._tablePanel.getTableToolbar().setToolMask(5);
        this._tablePanel.getTableToolbar().setDeleteEnabled(false);
    }

    private void _stopCellEditing() {
        if (this._table.isEditing()) {
            this._table.getCellEditor().stopCellEditing();
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = SimpleStringTable.this._table.getSelectedRow();
            if (row != -1) {
                SimpleStringTable.this._tablePanel.getTableToolbar().setDeleteEnabled(true);
            } else {
                SimpleStringTable.this._tablePanel.getTableToolbar().setDeleteEnabled(false);
            }
        }
    }

    private class TableCellEditorFocusLostListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            SimpleStringTable.this._stopCellEditing();
        }
    }
}

