/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.connection.dialogs;

import java.awt.Component;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.connection.dialogs.ConnectionController;
import oracle.adfmf.framework.dt.connection.dialogs.ConnectionPanel;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.wizard.Wizard;

public final class LoginConnectionWizard
extends Wizard {
    private ConnectionController _controller;
    private boolean _radioButtonEnabled = true;
    private Icon _icon = null;
    private static final String _ICON_FILE = "oracle/adfmf/framework/dt/connection/images/loginserverconn_header.png";

    public boolean isAvailable(Context context) {
        return true;
    }

    public void setCreateInChoiceEnabled(boolean enabled) {
        this._radioButtonEnabled = enabled;
    }

    public String getConnectionId() {
        String connId = null;
        if (this._controller != null) {
            connId = this._controller.getConnectionId();
        }
        return connId;
    }

    public boolean invoke(Context ideContext) {
        this._controller = new ConnectionController(ideContext);
        this._controller.setRbEnabled(this._radioButtonEnabled);
        return this.runDialog(new ConnectionPanel(this._controller));
    }

    public boolean runDialog(ConnectionPanel panel) {
        JEWTDialog dialog = JEWTDialog.createDialog((Component)Ide.getMainWindow(), (String)MobileResourceUtils.getText("CONNECTION_CR_TITLE"), (int)7);
        dialog.setContent((Component)panel);
        ImageIcon icon = new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource(_ICON_FILE));
        Image image = icon.getImage();
        dialog.setDialogHeader((Component)new DialogHeader(MobileResourceUtils.getText("CONNECTION_DLG_DESCRIPTION"), image));
        this._controller.register(dialog);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_adfmf_login_connection_wizard_html");
        return dialog.runDialog();
    }

    public String getShortLabel() {
        return MobileResourceUtils.getText("LOGIN_CONNECTION_WIZARD_SHORTLABEL");
    }

    public String getLongLabel() {
        return MobileResourceUtils.getText("LOGIN_CONNECTION_WIZARD_LONGLABEL");
    }

    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource(_ICON_FILE));
        }
        return this._icon;
    }
}

