/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.connection.dialogs;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.ProtocolNotSuppException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import oracle.adf.model.connection.adfmf.LoginConnection;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.connection.dialogs.ConnectionController;
import oracle.adfmf.framework.dt.connection.dialogs.SimpleStringTable;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controls.DescriptionScrollPane;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.Colors;

public final class ConnectionPanel
extends JPanel
implements ItemListener {
    public static final String DO_TEST_CONNECTION = "doTestConnection";
    private final GridBagLayout _panelLayout = new GridBagLayout();
    private final JLabel _labelCreateIn = new JLabel();
    private final JRadioButton _radioButtonApplication = new JRadioButton();
    private final JRadioButton _radioButtonPalette = new JRadioButton();
    private final JLabel _labelConnName = new JLabel();
    private final JTextField _fieldConnName = new JTextField();
    private JLabel _labelLoginUrl = new JLabel();
    private JTextField _fieldLoginUrl = new JTextField();
    private JLabel _labelLogoutUrl = new JLabel();
    private JTextField _fieldLogoutUrl = new JTextField();
    private JLabel _labelIdleTimeout = new JLabel();
    private JLabel _labelIdleSeconds = new JLabel();
    private JPanel _timeoutPanel = new JPanel();
    private JTextField _fieldIdleTimeout = new JTextField(9);
    private JLabel _labelSessionTimeout = new JLabel();
    private JTextField _fieldSessionTimeout = new JTextField(9);
    private JLabel _labelSessionSeconds = new JLabel();
    private transient SimpleStringTable _cookiesTable = new SimpleStringTable();
    private JCheckBox _checkIsLoginServerCookieIncluded = new JCheckBox();
    private JTabbedPane _tabbedPane = new JTabbedPane();
    private JPanel _authenticationPanel = new JPanel();
    private JPanel _authorizationPanel = new JPanel();
    private JPanel _multiTenantPanel = new JPanel();
    private JLabel _labelAccessControlUrl = new JLabel();
    private JTextField _fieldAccessControlUrl = new JTextField();
    private transient SimpleStringTable _rolesTable = new SimpleStringTable();
    private transient SimpleStringTable _privilegesTable = new SimpleStringTable();
    private final JButton _buttonTest = new JButton();
    private final JLabel _labelStatus = new JLabel();
    private final DescriptionScrollPane _descriptionStatus = new DescriptionScrollPane();
    private JCheckBox _checkIsMultiTenantAware = new JCheckBox();
    private JLabel _labelMultiTenantHeaderName = new JLabel();
    private JTextField _fieldMultiTenantHeaderName = new JTextField();
    private int _timeout = 30000;
    private static final int _TIMEOUT_FIELD_WIDTH = 9;
    private static final Insets _FIELD_INSETS = new Insets(0, 5, 5, 5);
    private static final Insets _BUTTON_INSETS = new Insets(2, 5, 3, 5);
    private static final Insets _LABEL_INSETS = new Insets(2, 5, 3, 5);
    private static final Insets _TIMEOUT_INSETS = new Insets(0, 0, 0, 80);
    private static final Insets _SECONDS_INSETS = new Insets(2, 0, 3, 0);
    private static final Insets _AWARE_LABEL_INSETS = new Insets(10, 10, 5, 5);
    private static final Insets _TENANT_FIELD_INSETS = new Insets(0, 26, 5, 5);
    private static final Insets _TENANT_LABEL_INSETS = new Insets(2, 26, 3, 5);
    private static final int _TEST_CONN_TIMEOUT_LIMIT = 30;

    public ConnectionPanel(ConnectionController controller) {
        controller.register(this);
        this._layoutComponents();
        this._initComponents(controller);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.validate();
        this.repaint();
    }

    public void setEditMode(String connectionName, LoginConnection connInfo) {
        this._fieldConnName.setEditable(false);
        this._fieldConnName.setText(connectionName);
        this._fieldLoginUrl.setText(connInfo.getLoginUrl());
        this._fieldLogoutUrl.setText(connInfo.getLogoutUrl());
        this._fieldIdleTimeout.setText(Integer.toString(connInfo.getIdleTimeout()));
        this._fieldSessionTimeout.setText(Integer.toString(connInfo.getSessionTimeout()));
        this._cookiesTable.setData(connInfo.getCookies());
        boolean isLoginServerCookieIncluded = connInfo.isLoginServerCookieIncluded();
        this._checkIsLoginServerCookieIncluded.setSelected(isLoginServerCookieIncluded);
        this._fieldAccessControlUrl.setText(connInfo.getAccessControlUrl());
        this._rolesTable.setData(connInfo.getRoles());
        this._privilegesTable.setData(connInfo.getPrivileges());
        boolean isMultiTenantAware = connInfo.isMultiTenantAware();
        this._checkIsMultiTenantAware.setSelected(isMultiTenantAware);
        this._fieldMultiTenantHeaderName.setText(connInfo.getMultiTenantHeaderName());
        if (isMultiTenantAware) {
            this._labelMultiTenantHeaderName.setEnabled(true);
            this._fieldMultiTenantHeaderName.setEnabled(true);
        }
        ResourceUtils.resLabel((JLabel)this._labelCreateIn, (Component)this._radioButtonApplication, (String)MobileResourceUtils.getText("CONNECTION_EXISTS_IN"));
        this._radioButtonApplication.setEnabled(false);
        this._radioButtonPalette.setEnabled(false);
        this._labelCreateIn.setEnabled(false);
    }

    public void setCreateMode() {
        this._radioButtonPalette.setEnabled(false);
        this._fieldIdleTimeout.setText(Integer.toString(300));
        this._fieldSessionTimeout.setText(Integer.toString(28800));
    }

    public void setCreateInChoiceEnabled(boolean enabled) {
        this._radioButtonApplication.setEnabled(enabled);
        this._radioButtonPalette.setEnabled(enabled);
        this._labelCreateIn.setEnabled(enabled);
    }

    public void setTestEnabled(boolean enabled) {
        this._descriptionStatus.setEnabled(enabled);
        this._labelStatus.setEnabled(enabled);
        this._buttonTest.setEnabled(enabled);
        if (!enabled) {
            this._descriptionStatus.setText("");
        }
    }

    public void updateStatus(String status) {
        this._descriptionStatus.setText(status);
        this._descriptionStatus.getAccessibleContext().setAccessibleName(this._labelStatus.getText());
        this._descriptionStatus.getAccessibleContext().setAccessibleDescription(status);
    }

    public void requestFocusInStatus() {
        this._descriptionStatus.getLabelComponent().requestFocusInWindow();
    }

    public JTextField getConnectionField() {
        return this._fieldConnName;
    }

    public JTextField getLoginUrlField() {
        return this._fieldLoginUrl;
    }

    public JTextField getLogoutUrlField() {
        return this._fieldLogoutUrl;
    }

    public String getConnectionName() {
        return this._fieldConnName.getText();
    }

    public void setConnectionName(String name) {
        this._fieldConnName.setText(name);
    }

    public boolean isAppicationEnabled() {
        return this._radioButtonApplication.isEnabled();
    }

    public void setApplicationEnabled(boolean enabled) {
        this._radioButtonApplication.setEnabled(enabled);
    }

    public boolean isApplicationSelected() {
        return this._radioButtonApplication.isSelected();
    }

    public void setApplicationSelected(boolean selected) {
        this._radioButtonApplication.setSelected(selected);
    }

    public boolean isResourcePaletteEnabled() {
        return this._radioButtonPalette.isEnabled();
    }

    public void setResourcePaletteEnabled(boolean enabled) {
        this._radioButtonPalette.setEnabled(enabled);
    }

    public boolean isResourcePaletteSelected() {
        return this._radioButtonPalette.isSelected();
    }

    public void setResourcePaletteSelected(boolean selected) {
        this._radioButtonPalette.setSelected(selected);
    }

    public String getLoginUrl() {
        return this._fieldLoginUrl.getText();
    }

    public String getLogoutUrl() {
        return this._fieldLogoutUrl.getText();
    }

    public String getAccessControlUrl() {
        return this._fieldAccessControlUrl.getText();
    }

    public int getIdleTimeout() {
        return Integer.parseInt(this._fieldIdleTimeout.getText());
    }

    public int getSessionTimeout() {
        return Integer.parseInt(this._fieldSessionTimeout.getText());
    }

    public boolean isLoginServerCookieIncluded() {
        return this._checkIsLoginServerCookieIncluded.isSelected();
    }

    public boolean isMultiTenantAware() {
        return this._checkIsMultiTenantAware.isSelected();
    }

    public String getMultiTenantHeaderName() {
        return this._fieldMultiTenantHeaderName.getText();
    }

    public List<String> getCookies() {
        return this._cookiesTable.getData();
    }

    public List<String> getRoles() {
        return this._rolesTable.getData();
    }

    public List<String> getPrivileges() {
        return this._privilegesTable.getData();
    }

    public String checkConnection() {
        URL testAccessControlUrl;
        String loginUrl = this.getLoginUrl();
        if (loginUrl == null || loginUrl.trim().length() == 0) {
            return MobileResourceUtils.getText("TEST_MISSING_LOGIN_URL");
        }
        String logoutUrl = this.getLogoutUrl();
        if (logoutUrl == null || logoutUrl.trim().length() == 0) {
            return MobileResourceUtils.getText("TEST_MISSING_LOGOUT_URL");
        }
        URL testLoginUrl = URLFactory.newURL((String)loginUrl.trim());
        if (testLoginUrl == null) {
            return MobileResourceUtils.getText("TEST_INVALID_LOGIN_URL");
        }
        URL testLogoutUrl = URLFactory.newURL((String)logoutUrl.trim());
        if (testLogoutUrl == null) {
            return MobileResourceUtils.getText("TEST_INVALID_LOGOUT_URL");
        }
        String accessControlUrl = this.getAccessControlUrl();
        if (accessControlUrl != null && accessControlUrl.trim().length() > 0 && (testAccessControlUrl = URLFactory.newURL((String)accessControlUrl.trim())) == null) {
            return MobileResourceUtils.getText("TEST_INVALID_ACCESS_CONTROL_URL");
        }
        return "";
    }

    public String testConnection() {
        String checkURLresult = this.checkConnection();
        if (checkURLresult != null && checkURLresult.length() > 0) {
            return checkURLresult;
        }
        URL testLoginUrl = URLFactory.newURL((String)this.getLoginUrl().trim());
        if (!this._openURLTest(testLoginUrl)) {
            return MobileResourceUtils.getText("TEST_LOGIN_URL_NOT_ACCESSIBLE");
        }
        URL testLogoutUrl = URLFactory.newURL((String)this.getLogoutUrl().trim());
        if (!this._openURLTest(testLogoutUrl)) {
            return MobileResourceUtils.getText("TEST_LOGOUT_URL_NOT_ACCESSIBLE");
        }
        String accessControlUrl = this.getAccessControlUrl();
        if (accessControlUrl != null && accessControlUrl.trim().length() > 0) {
            URL testAccessControlUrl = URLFactory.newURL((String)accessControlUrl.trim());
            if (!this._openURLTest(testAccessControlUrl)) {
                return MobileResourceUtils.getText("TEST_ACCESS_CONTROL_URL_NOT_ACCESSIBLE");
            }
            return MobileResourceUtils.getText("TEST_URLCONN_VALID1");
        }
        return MobileResourceUtils.getText("TEST_URLCONN_VALID2");
    }

    private boolean _openURLTest(URL url) {
        HTTPConnection httpConn = null;
        try {
            httpConn = new HTTPConnection(url);
            httpConn.setAllowUserInteraction(false);
            httpConn.setTimeout(this._timeout);
            this._setProxy(httpConn);
            httpConn.connect();
            String path = url.getPath();
            HTTPResponse resp = httpConn.Get(path);
            int statusCode = resp.getStatusCode();
            if (statusCode < 400 || statusCode == 401 || statusCode == 405) {
                return true;
            }
        }
        catch (ProtocolNotSuppException e) {
        }
        catch (IOException e) {
        }
        catch (ModuleException moduleException) {
            // empty catch block
        }
        return false;
    }

    private void _layoutComponents() {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._radioButtonApplication);
        bg.add(this._radioButtonPalette);
        this.setLayout(this._panelLayout);
        this._timeoutPanel.setLayout(new GridBagLayout());
        this._authenticationPanel.setLayout(new GridBagLayout());
        this._authorizationPanel.setLayout(new GridBagLayout());
        this._multiTenantPanel.setLayout(new GridBagLayout());
        this._tabbedPane.addTab(StringUtils.stripMnemonic((String)MobileResourceUtils.getText("TAB_AUTHENTICATION")), this._authenticationPanel);
        this._tabbedPane.addTab(StringUtils.stripMnemonic((String)MobileResourceUtils.getText("TAB_AUTHORIZATION")), this._authorizationPanel);
        int row = 0;
        this.add((Component)this._labelCreateIn, new GridBagConstraints(0, row, 1, 1, 0.3, 1.0, 18, 0, _LABEL_INSETS, 0, 0));
        this.add((Component)this._radioButtonApplication, new GridBagConstraints(1, row, 1, 1, 0.2, 0.0, 17, 0, _LABEL_INSETS, 0, 0));
        this.add((Component)this._radioButtonPalette, new GridBagConstraints(2, row, 1, 1, 0.2, 0.0, 17, 0, _LABEL_INSETS, 0, 0));
        this.add((Component)this._tabbedPane, new GridBagConstraints(0, ++row, 3, 1, 0.0, 1.0, 17, 1, _FIELD_INSETS, 0, 0));
        int rowAuthenPanel = 0;
        this._authenticationPanel.add((Component)this._labelConnName, new GridBagConstraints(0, rowAuthenPanel, 1, 1, 0.0, 0.0, 18, 0, _LABEL_INSETS, 0, 0));
        this._authenticationPanel.add((Component)this._fieldConnName, new GridBagConstraints(0, ++rowAuthenPanel, 2, 1, 1.0, 0.0, 17, 2, _FIELD_INSETS, 0, 0));
        this._authenticationPanel.add((Component)this._labelLoginUrl, new GridBagConstraints(0, ++rowAuthenPanel, 1, 1, 0.0, 0.0, 17, 0, _LABEL_INSETS, 0, 0));
        this._authenticationPanel.add((Component)this._fieldLoginUrl, new GridBagConstraints(0, ++rowAuthenPanel, 2, 1, 1.0, 0.0, 17, 2, _FIELD_INSETS, 0, 0));
        this._authenticationPanel.add((Component)this._labelLogoutUrl, new GridBagConstraints(0, ++rowAuthenPanel, 1, 1, 0.0, 0.0, 17, 0, _LABEL_INSETS, 0, 0));
        this._authenticationPanel.add((Component)this._fieldLogoutUrl, new GridBagConstraints(0, ++rowAuthenPanel, 2, 1, 1.0, 0.0, 17, 2, _FIELD_INSETS, 0, 0));
        this._timeoutPanel.add((Component)this._labelIdleTimeout, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, _LABEL_INSETS, 0, 0));
        this._timeoutPanel.add((Component)this._labelSessionTimeout, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, _LABEL_INSETS, 0, 0));
        this._timeoutPanel.add((Component)this._fieldIdleTimeout, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, _FIELD_INSETS, 0, 0));
        this._timeoutPanel.add((Component)this._labelIdleSeconds, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, _SECONDS_INSETS, 0, 0));
        this._timeoutPanel.add((Component)this._fieldSessionTimeout, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, _FIELD_INSETS, 0, 0));
        this._timeoutPanel.add((Component)this._labelSessionSeconds, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 0, _SECONDS_INSETS, 0, 0));
        this._authenticationPanel.add((Component)this._timeoutPanel, new GridBagConstraints(0, ++rowAuthenPanel, 2, 1, 0.0, 0.0, 17, 2, _TIMEOUT_INSETS, 0, 0));
        this._authenticationPanel.add((Component)this._cookiesTable.getTablePanel(), new GridBagConstraints(0, ++rowAuthenPanel, 2, 1, 1.0, 1.0, 17, 1, _FIELD_INSETS, 0, 0));
        this._authenticationPanel.add((Component)this._checkIsLoginServerCookieIncluded, new GridBagConstraints(0, ++rowAuthenPanel, 2, 1, 1.0, 0.0, 17, 2, _FIELD_INSETS, 0, 0));
        int rowAuthorPanel = 0;
        this._authorizationPanel.add((Component)this._labelAccessControlUrl, new GridBagConstraints(0, rowAuthorPanel, 1, 1, 0.0, 0.0, 18, 0, _LABEL_INSETS, 0, 0));
        this._authorizationPanel.add((Component)this._fieldAccessControlUrl, new GridBagConstraints(0, ++rowAuthorPanel, 1, 1, 0.0, 0.0, 17, 2, _FIELD_INSETS, 0, 0));
        this._authorizationPanel.add((Component)this._rolesTable.getTablePanel(), new GridBagConstraints(0, ++rowAuthorPanel, 1, 1, 1.0, 1.0, 17, 1, _FIELD_INSETS, 0, 0));
        this._authorizationPanel.add((Component)this._privilegesTable.getTablePanel(), new GridBagConstraints(0, ++rowAuthorPanel, 1, 1, 1.0, 1.0, 17, 1, _FIELD_INSETS, 0, 0));
        int rowTenantPanel = 0;
        this._multiTenantPanel.add((Component)this._checkIsMultiTenantAware, new GridBagConstraints(0, rowTenantPanel, 1, 1, 0.0, 0.0, 18, 0, _AWARE_LABEL_INSETS, 0, 0));
        this._multiTenantPanel.add((Component)this._labelMultiTenantHeaderName, new GridBagConstraints(0, ++rowTenantPanel, 1, 1, 0.0, 0.0, 18, 0, _TENANT_LABEL_INSETS, 0, 0));
        this._multiTenantPanel.add((Component)this._fieldMultiTenantHeaderName, new GridBagConstraints(0, ++rowTenantPanel, 1, 1, 1.0, 1.0, 18, 2, _TENANT_FIELD_INSETS, 0, 0));
        this.add((Component)this._buttonTest, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, _BUTTON_INSETS, 0, 0));
        this.add((Component)this._labelStatus, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, _LABEL_INSETS, 0, 0));
        this.add((Component)this._descriptionStatus, new GridBagConstraints(0, ++row, 3, 1, 0.0, 1.0, 17, 1, _FIELD_INSETS, 400, 40));
    }

    private void _initComponents(ConnectionController controller) {
        this._labelLoginUrl.setEnabled(false);
        this._labelLogoutUrl.setEnabled(false);
        this._labelIdleTimeout.setEnabled(false);
        this._labelSessionTimeout.setEnabled(false);
        this._timeoutPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        ResourceUtils.resLabel((JLabel)this._labelCreateIn, (Component)this._radioButtonApplication, (String)MobileResourceUtils.getText("CONNECTION_CREATE_IN"));
        ResourceUtils.resButton((AbstractButton)this._radioButtonApplication, (String)MobileResourceUtils.getText("CONNECTION_APPLICATION"));
        ResourceUtils.resButton((AbstractButton)this._radioButtonPalette, (String)MobileResourceUtils.getText("CONNECTION_PALETTE"));
        ResourceUtils.resLabel((JLabel)this._labelConnName, (Component)this._fieldConnName, (String)MobileResourceUtils.getText("CONNECTION_NAME"));
        ResourceUtils.resLabel((JLabel)this._labelLoginUrl, (Component)this._fieldLoginUrl, (String)MobileResourceUtils.getText("CONNECTION_LOGIN_URL"));
        ResourceUtils.resLabel((JLabel)this._labelLogoutUrl, (Component)this._fieldLogoutUrl, (String)MobileResourceUtils.getText("CONNECTION_LOGOUT_URL"));
        ResourceUtils.resLabel((JLabel)this._labelIdleTimeout, (Component)this._fieldIdleTimeout, (String)MobileResourceUtils.getText("CONNECTION_IDLE_TIMEOUT"));
        this._labelIdleSeconds.setText(MobileResourceUtils.getText("SECONDS"));
        this._labelIdleSeconds.setForeground(Colors.HINT_TEXT);
        ResourceUtils.resLabel((JLabel)this._labelSessionTimeout, (Component)this._fieldSessionTimeout, (String)MobileResourceUtils.getText("CONNECTION_SESSION_TIMEOUT"));
        this._labelSessionSeconds.setText(MobileResourceUtils.getText("SECONDS"));
        this._labelSessionSeconds.setForeground(Colors.HINT_TEXT);
        this._cookiesTable.setLabel(StringUtils.stripMnemonic((String)MobileResourceUtils.getText("CONNECTION_COOKIES")));
        ResourceUtils.resButton((AbstractButton)this._checkIsLoginServerCookieIncluded, (String)MobileResourceUtils.getText("CHECK_INCLUDE_COOKIE"));
        ResourceUtils.resLabel((JLabel)this._labelAccessControlUrl, (Component)this._fieldAccessControlUrl, (String)MobileResourceUtils.getText("ACCESS_CONTROL_URL"));
        this._rolesTable.setLabel(StringUtils.stripMnemonic((String)MobileResourceUtils.getText("FILTER_LIST_ROLES")));
        this._privilegesTable.setLabel(StringUtils.stripMnemonic((String)MobileResourceUtils.getText("FILTER_LIST_PRIVILEGES")));
        ResourceUtils.resButton((AbstractButton)this._buttonTest, (String)MobileResourceUtils.getText("BUTTON_TEST"));
        ResourceUtils.resLabel((JLabel)this._labelStatus, (Component)this._descriptionStatus, (String)MobileResourceUtils.getText("CONNECTION_STATUS"));
        ResourceUtils.resButton((AbstractButton)this._checkIsMultiTenantAware, (String)MobileResourceUtils.getText("CHECK_MULTI_TENANT"));
        this._checkIsMultiTenantAware.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean enableTenantheander = itemEvent.getStateChange() == 1;
                ConnectionPanel.this._labelMultiTenantHeaderName.setEnabled(enableTenantheander);
                ConnectionPanel.this._fieldMultiTenantHeaderName.setEnabled(enableTenantheander);
            }
        });
        ResourceUtils.resLabel((JLabel)this._labelMultiTenantHeaderName, (Component)this._fieldMultiTenantHeaderName, (String)MobileResourceUtils.getText("LABEL_TENANT_HEADER_PROPERTY"));
        this._labelMultiTenantHeaderName.setEnabled(false);
        this._fieldMultiTenantHeaderName.setEnabled(false);
        this._buttonTest.setActionCommand(DO_TEST_CONNECTION);
        this._buttonTest.addActionListener(controller);
        this._descriptionStatus.setBackground(this.getBackground());
    }

    private void _setProxy(HTTPConnection httpConn) {
        String proxyHostProp = "http.proxyHost";
        String proxyPortProp = "http.proxyPort";
        String proxyNonProxyHosts = "http.nonProxyHosts";
        String localHost = "localhost";
        String localIP = "127.0.0.1";
        String proxyHost = System.getProperty("http.proxyHost");
        int port = 80;
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyPort != null) {
            port = Integer.parseInt(proxyPort);
        }
        if (proxyHost != null) {
            String nonProxyHostsStr = System.getProperty("http.nonProxyHosts");
            ArrayList<String> nonProxyHostsList = new ArrayList<String>();
            if (!nonProxyHostsStr.isEmpty()) {
                try {
                    String[] nonProxyHosts;
                    for (String str : nonProxyHosts = nonProxyHostsStr.split("\\|")) {
                        String trimmedStr = str.trim();
                        if (trimmedStr.isEmpty()) continue;
                        nonProxyHostsList.add(trimmedStr);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!nonProxyHostsList.contains("localhost") && !nonProxyHostsList.contains("127.0.0.1")) {
                    nonProxyHostsList.add("localhost");
                }
            } else {
                nonProxyHostsList.add("localhost");
            }
            HTTPConnection.setProxyServer((String)proxyHost, (int)port);
            HTTPConnection.dontProxyFor((String[])nonProxyHostsList.toArray(new String[nonProxyHostsList.size()]));
        }
    }
}

