/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.connection.dialogs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.adf.model.connection.adfmf.LoginConnection;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.connection.dialogs.ConnectionPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.feedback.FeedbackManager;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.rescat2.model.registry.RescatContext;
import oracle.jdeveloper.rescat2.model.registry.RescatContextRegistry;

public final class ConnectionController
implements ActionListener {
    private Context _ideContext;
    private JEWTDialog _dialog;
    private ConnectionPanel _panel;
    private OKButtonUpdater _listener;
    private LoginConnection _loginConnection;
    private VetoableChangeListener _dialogListener;
    private boolean _bEditMode = false;
    private boolean _bRbEnabled = true;

    public ConnectionController(Context ideContext) {
        this._ideContext = ideContext;
        this._loginConnection = new LoginConnection();
    }

    public void setRbEnabled(boolean isRbEnabled) {
        this._bRbEnabled = isRbEnabled;
    }

    public void register(ConnectionPanel panel) {
        this._panel = panel;
    }

    public void register(JEWTDialog dialog) {
        this._dialog = dialog;
        this._initDialog();
    }

    public String getConnectionId() {
        String connId = null;
        if (this._loginConnection != null) {
            connId = this._loginConnection.getConnectionId();
        }
        return connId;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action != null) {
            if (action.equals("doTestConnection")) {
                String feedback = this._panel.testConnection();
                this._panel.updateStatus(feedback);
                this._panel.requestFocusInStatus();
            }
        }
    }

    private void _initDialog() {
        this._dialogListener = this._createDialogListener();
        this._dialog.addVetoableChangeListener(this._dialogListener);
        this._listener = new OKButtonUpdater();
        this._listener.attach(this._panel.getLoginUrlField());
        this._listener.attach(this._panel.getLogoutUrlField());
        this._listener.attach(this._panel.getConnectionField());
        this._setupRequiredFields();
        this._setConnectionSource();
        String targetConnId = (String)this._ideContext.getProperty("oracle.jdeveloper.rescat2.connectionId");
        if (targetConnId == null || targetConnId.length() == 0) {
            this._bEditMode = false;
            this._panel.setCreateMode();
        } else {
            this._bEditMode = true;
            try {
                this._loginConnection = this._findConnection(this._getRescatContext(this._isForPalette()), targetConnId);
            }
            catch (Exception cnfe) {
                FeedbackManager.reportException((Throwable)cnfe);
            }
            this._panel.setEditMode(targetConnId, this._loginConnection);
            this._dialog.setTitle(MobileResourceUtils.getText("CONNECTION_EDIT_TITLE"));
        }
    }

    private boolean _isForPalette() {
        return this._panel.isResourcePaletteSelected();
    }

    private void _setConnectionSource() {
        RescatContextRegistry registry = RescatContextRegistry.getInstance();
        RescatContext sourceCtx = registry.getRescatContext(this._ideContext);
        if (sourceCtx == null || registry.getActiveWorkspaceContext() == null) {
            this._panel.setApplicationEnabled(false);
            this._panel.setResourcePaletteSelected(true);
        } else if (registry.isResourcePaletteContext(sourceCtx)) {
            this._panel.setResourcePaletteSelected(true);
        } else {
            this._panel.setApplicationSelected(true);
        }
        if (!this._bRbEnabled) {
            this._panel.setCreateInChoiceEnabled(false);
        }
    }

    private void _setupRequiredFields() {
        this._dialog.setOKButtonEnabled(this._canFinish());
        this._panel.setTestEnabled(this._canFinish());
    }

    private boolean _canFinish() {
        boolean canFinish = false;
        canFinish = this._panel.getLoginUrl().trim().length() > 0 && this._panel.getLogoutUrl().trim().length() > 0 && this._panel.getConnectionName().trim().length() > 0;
        return canFinish;
    }

    private boolean _validate(boolean forPalette, String name) {
        boolean result = true;
        String message = null;
        String errorTitle = MobileResourceUtils.getText("CONNECTION_ERROR_TITLE");
        if (!this._validateNameSyntax(forPalette, name)) {
            message = MobileResourceUtils.getText("INVALID_CONNECTION_NAME");
            MessageDialog.error((Component)this._panel, (Object)message, (String)errorTitle, null);
            result = false;
        } else if (!this._bEditMode && this._nameExists(forPalette, name)) {
            message = MobileResourceUtils.getText("CONNECTION_DUPLICATE_NAME");
            MessageDialog.error((Component)this._panel, (Object)message, (String)errorTitle, null);
            result = false;
        }
        if (result && (message = this._panel.checkConnection()) != null && message.length() > 0) {
            MessageDialog.error((Component)this._panel, (Object)message, (String)errorTitle, null);
            result = false;
        }
        return result;
    }

    private VetoableChangeListener _createDialogListener() {
        return new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                ConnectionController.this._dialog;
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    String name = ConnectionController.this._panel.getConnectionName();
                    ConnectionController.this._loginConnection.setConnectionId(name);
                    ConnectionController.this._loginConnection.setCredKey(name);
                    ConnectionController.this._loginConnection.setLoginUrl(ConnectionController.this._panel.getLoginUrl());
                    ConnectionController.this._loginConnection.setLogoutUrl(ConnectionController.this._panel.getLogoutUrl());
                    ConnectionController.this._loginConnection.setIdleTimeout(ConnectionController.this._panel.getIdleTimeout());
                    ConnectionController.this._loginConnection.setSessionTimeout(ConnectionController.this._panel.getSessionTimeout());
                    ConnectionController.this._loginConnection.setCookies(ConnectionController.this._panel.getCookies());
                    ConnectionController.this._loginConnection.setIsLoginServerCookieIncluded(ConnectionController.this._panel.isLoginServerCookieIncluded());
                    ConnectionController.this._loginConnection.setAccessControlUrl(ConnectionController.this._panel.getAccessControlUrl());
                    ConnectionController.this._loginConnection.setRoles(ConnectionController.this._panel.getRoles());
                    ConnectionController.this._loginConnection.setPrivileges(ConnectionController.this._panel.getPrivileges());
                    ConnectionController.this._loginConnection.setIsMultiTenantAware(ConnectionController.this._panel.isMultiTenantAware());
                    ConnectionController.this._loginConnection.setMultiTenantHeaderName(ConnectionController.this._panel.getMultiTenantHeaderName());
                    boolean forPalette = ConnectionController.this._isForPalette();
                    if (ConnectionController.this._validate(forPalette, name)) {
                        RescatContext rescatCtx = ConnectionController.this._getRescatContext(forPalette);
                        if (ConnectionController.this._bEditMode) {
                            try {
                                ConnectionController.this._getNamingContext(rescatCtx).rebind(name, (Object)ConnectionController.this._loginConnection);
                                rescatCtx.flushChanges();
                            }
                            catch (NamingException e) {
                                FeedbackManager.reportException((Throwable)e);
                            }
                        } else {
                            try {
                                ConnectionController.this._getNamingContext(rescatCtx).bind(name, (Object)ConnectionController.this._loginConnection);
                                rescatCtx.flushChanges();
                            }
                            catch (NameAlreadyBoundException nbe) {
                                String errorTitle = MobileResourceUtils.getText("CONNECTION_ERROR_TITLE");
                                String message = MobileResourceUtils.getText("CONNECTION_DUPLICATE_NAME");
                                MessageDialog.error((Component)ConnectionController.this._panel, (Object)message, (String)errorTitle, null);
                                throw new PropertyVetoException("", evt);
                            }
                            catch (NamingException e) {
                                FeedbackManager.reportException((Throwable)e);
                            }
                        }
                        ConnectionController.this._dialog.removeVetoableChangeListener(ConnectionController.this._dialogListener);
                        ConnectionController.this._dialogListener = null;
                        ConnectionController.this._dialog.closeDialog(false);
                    }
                    throw new PropertyVetoException("", evt);
                }
            }
        };
    }

    private LoginConnection _findConnection(RescatContext rescatCtx, String connName) {
        LoginConnection connInfo = null;
        try {
            javax.naming.Context c = this._getNamingContext(rescatCtx);
            Object obj = c.lookup(connName);
            if (obj instanceof LoginConnection) {
                connInfo = (LoginConnection)obj;
                return connInfo;
            }
        }
        catch (NameNotFoundException nnfe) {
            connInfo = null;
        }
        catch (NamingException ne) {
            FeedbackManager.reportException((Throwable)ne);
        }
        return connInfo;
    }

    private javax.naming.Context _getNamingContext(RescatContext rescatCtx) {
        return rescatCtx.getConnectionContext();
    }

    private RescatContext _getRescatContext(boolean forPalette) {
        RescatContext ctx = null;
        RescatContextRegistry registry = RescatContextRegistry.getInstance();
        ctx = forPalette ? registry.getResourcePaletteContext() : registry.getActiveWorkspaceContext();
        return ctx;
    }

    private boolean _validateNameSyntax(boolean forPalette, String id) {
        RescatContext rescatCtx = this._getRescatContext(forPalette);
        try {
            NameParser parser = this._getNamingContext(rescatCtx).getNameParser("");
            try {
                parser.parse(id);
            }
            catch (InvalidNameException ine) {
                return false;
            }
        }
        catch (NamingException ne) {
            return false;
        }
        return true;
    }

    private boolean _nameExists(boolean forPalette, String id) {
        RescatContext rescatCtx = this._getRescatContext(forPalette);
        boolean exists = false;
        exists = this._findConnection(rescatCtx, id) != null;
        return exists;
    }

    private class OKButtonUpdater
    implements DocumentListener {
        OKButtonUpdater() {
        }

        private void update() {
            ConnectionController.this._dialog.setOKButtonEnabled(ConnectionController.this._canFinish());
            ConnectionController.this._panel.setTestEnabled(ConnectionController.this._canFinish());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        void attach(JTextComponent tc) {
            tc.getDocument().addDocumentListener(this);
        }
    }
}

