/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.audit.analyzer;

import java.util.List;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.ProjectUtils;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.extension.ExtensionResource;

public class ProjectAnalyzer
extends Analyzer {
    @ExtensionResource(value="oracle.adfmf.invalid-project-dependency-found")
    private Rule _errorInvalidProjectDependencyRule;

    public void enter(AuditContext context, Project project) {
        List<Project> featureProjectList;
        Rule rule = this._errorInvalidProjectDependencyRule;
        Workspace workspace = context.getWorkspace();
        if (null != project && null != workspace && rule.isEnabled() && (ProjectUtils.projectIsAppController(project, workspace) || ProjectUtils.projectIsMobileViewController(project)) && !ProjectUtils.hasValidDependencies(project, featureProjectList = McAppUtils.findProjectsWithFeatures(workspace))) {
            context.report(rule, (Object)project);
        }
    }
}

