/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.audit.analyzer;

import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.editor.feature.FeatureXmlSourceNode;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.extension.ExtensionResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class FeatureAnalyzer
extends Analyzer {
    @ExtensionResource(value="oracle.adfmf.feature-url-references-not-within-public_html")
    private Rule _urlInPublicHtmlRule;

    public void enter(AuditContext context, Document document) {
        Node node = context.getModel().getNode();
        if (!(node instanceof FeatureXmlSourceNode) || !this._urlInPublicHtmlRule.isEnabled()) {
            this.setEnabled(false);
        }
    }

    public void enter(AuditContext context, Element element) {
        this._checkInPublicHtml(context, element);
    }

    private void _checkUrlAttribute(AuditContext context, Element element, String attrName) {
        String value = element.getAttributeNS(null, attrName);
        Project project = context.getIdeContext().getProject();
        if (!McAppUtils.canFileBeInProjectPublicHtmlDir(project, value)) {
            context.report(this._urlInPublicHtmlRule, (Object)element.getAttributeNodeNS(null, attrName));
        }
    }

    private void _checkInPublicHtml(AuditContext context, Element element) {
        String localName = element.getLocalName();
        if ("feature".equals(localName)) {
            this._checkUrlAttribute(context, element, "icon");
            this._checkUrlAttribute(context, element, "image");
        } else if ("content".equals(localName)) {
            this._checkUrlAttribute(context, element, "icon");
            this._checkUrlAttribute(context, element, "image");
        } else if ("localHTML".equals(localName)) {
            this._checkUrlAttribute(context, element, "url");
        } else if ("include".equals(localName) || "amx".equals(localName)) {
            this._checkUrlAttribute(context, element, "file");
        }
    }
}

