/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.audit.analyzer;

import java.util.HashSet;
import java.util.Set;
import oracle.adf.model.connection.adfmf.LoginConnection;
import oracle.adf.model.connection.url.HttpURLConnection;
import oracle.adf.model.connection.webservice.impl.WebServiceConnectionImpl;
import oracle.adf.share.dt.ConnectionXmlNode;
import oracle.adfmf.common.util.McAppUtils;
import oracle.ide.model.Node;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.extension.ExtensionResource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConnectionsAnalyzer
extends Analyzer {
    @ExtensionResource(value="oracle.adfmf.connection-adfcredentialkey-not-match-login-connection-adfcredentialkey")
    private Rule _rule;
    private static final String _REFERENCE = "Reference";
    private static final String _CLASSNAME = "className";
    private static final String _ADF_CREDSTOREKEY = "adfCredentialStoreKey";
    private static final String _loginConnectionClassName = LoginConnection.class.getName();
    private static final String _wsConnectionClassName = WebServiceConnectionImpl.class.getName();
    private static final String _urlConnectionClassName = HttpURLConnection.class.getName();
    private Set<String> _loginConnAdfCredentialStoreKeySet = new HashSet<String>();

    public void enter(AuditContext context, Document document) {
        Node node = context.getModel().getNode();
        Workspace workspace = context.getIdeContext().getWorkspace();
        if (!(node instanceof ConnectionXmlNode && McAppUtils.isMobileApp(workspace) && this._rule.isEnabled())) {
            this.setEnabled(false);
        } else {
            NodeList nodelist = document.getElementsByTagNameNS(null, _REFERENCE);
            int count = nodelist != null ? nodelist.getLength() : 0;
            for (int i = 0; i < count; ++i) {
                String keyValue;
                Element refElement = (Element)nodelist.item(i);
                if (!_loginConnectionClassName.equals(refElement.getAttributeNS(null, _CLASSNAME)) || (keyValue = refElement.getAttributeNS(null, _ADF_CREDSTOREKEY)) == null || keyValue.length() <= 0) continue;
                this._loginConnAdfCredentialStoreKeySet.add(keyValue);
            }
        }
    }

    public void enter(AuditContext context, Element element) {
        if (_REFERENCE.equals(element.getLocalName()) && (_wsConnectionClassName.equals(element.getAttributeNS(null, _CLASSNAME)) || _urlConnectionClassName.equals(element.getAttributeNS(null, _CLASSNAME)))) {
            Attr attr = element.getAttributeNodeNS(null, _ADF_CREDSTOREKEY);
            String keyValue = element.getAttributeNS(null, _ADF_CREDSTOREKEY);
            if (attr != null && !this._loginConnAdfCredentialStoreKeySet.contains(keyValue)) {
                context.report(this._rule, (Object)element.getAttributeNodeNS(null, _ADF_CREDSTOREKEY));
            }
        }
    }

    public boolean isApplicationContentSupported() {
        return true;
    }

    public void exit(AuditContext context, Document document) {
        this._loginConnAdfCredentialStoreKeySet.clear();
    }
}

