/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.audit.analyzer;

import java.util.HashSet;
import java.util.Set;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.editor.FrameworkXmlSourceNode;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.extension.ExtensionResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ApplicationAnalyzer
extends Analyzer {
    @ExtensionResource(value="oracle.adfmf.application-url-references-not-within-public_html")
    private Rule _urlInPublicHtmlRule;
    @ExtensionResource(value="oracle.adfmf.custom-springboard-feature-reference-in-application-feature-references")
    private Rule _spbdFeatureReferenceRule;
    private String _spbdFeatureReferenceId = null;
    private Set<String> _appFeatureReferencesSet = new HashSet<String>();

    public void enter(AuditContext context, Document document) {
        Node node = context.getModel().getNode();
        if (!(node instanceof FrameworkXmlSourceNode) || !this._urlInPublicHtmlRule.isEnabled() && !this._spbdFeatureReferenceRule.isEnabled()) {
            this.setEnabled(false);
        }
    }

    public void enter(AuditContext context, Element element) {
        if (this._urlInPublicHtmlRule.isEnabled()) {
            this._checkInPublicHtml(context, element);
        }
        if (this._spbdFeatureReferenceRule.isEnabled()) {
            this._checkFeatureReference(context, element);
        }
    }

    public boolean isApplicationContentSupported() {
        return true;
    }

    private void _checkInPublicHtml(AuditContext context, Element element) {
        String localName = element.getLocalName();
        if ("localHTML".equals(localName)) {
            this._checkUrlAttribute(context, element, "url");
        } else if ("amx".equals(localName)) {
            this._checkUrlAttribute(context, element, "file");
        }
    }

    private void _checkUrlAttribute(AuditContext context, Element element, String attrName) {
        Workspace workspace = context.getIdeContext().getWorkspace();
        Project project = McAppUtils.getApplicationControllerProject(workspace, null);
        if (project == null) {
            return;
        }
        String value = element.getAttributeNS(null, attrName);
        if (!McAppUtils.canFileBeInProjectPublicHtmlDir(project, value)) {
            context.report(this._urlInPublicHtmlRule, (Object)element.getAttributeNodeNS(null, attrName));
        }
    }

    private void _checkFeatureReference(AuditContext context, Element element) {
        if ("springboardFeatureReference".equals(element.getLocalName())) {
            this._spbdFeatureReferenceId = element.getAttributeNS(null, "id");
            if (this._appFeatureReferencesSet.contains(this._spbdFeatureReferenceId)) {
                context.report(this._spbdFeatureReferenceRule, (Object)element.getAttributeNodeNS(null, "id"));
            }
        } else if ("featureReference".equals(element.getLocalName())) {
            boolean showInSB;
            String featureRefId = element.getAttributeNS(null, "id");
            boolean showInNB = !"false".equalsIgnoreCase(element.getAttributeNS(null, "showOnNavigationBar"));
            boolean bl = showInSB = !"false".equalsIgnoreCase(element.getAttributeNS(null, "showOnNavigationBar"));
            if (featureRefId != null && featureRefId.length() > 0 && (showInNB || showInSB)) {
                if (featureRefId.equals(this._spbdFeatureReferenceId)) {
                    context.report(this._spbdFeatureReferenceRule, (Object)element.getAttributeNodeNS(null, "id"));
                }
                this._appFeatureReferencesSet.add(featureRefId);
            }
        }
    }
}

