/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.customization;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.model.ApplicationContent;
import oracle.mds.config.CustClassListMapping;
import oracle.mds.config.CustConfig;
import oracle.mds.config.MDSConfigurationException;
import oracle.mds.cust.CustClassList;
import oracle.mds.dt.MDSDesignTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class CustomizationUtils {
    private static final Logger _sLogger = Logger.getLogger(CustomizationUtils.class.getName());
    private static final String _MDS_DIR = "mdssys/";
    private static final String _CUST_CONFIG_TAG = "cust-config";
    private static final String _MDS_CONFIG_NS = "http://xmlns.oracle.com/mds/config";
    private static final String _ADF_CONFIG_FILE = "adf-config.xml";

    private CustomizationUtils() {
    }

    public static boolean isCustomizationsEnabled(Workspace workspace) {
        return MDSDesignTime.getInstance().isCustomizationsEnabled(workspace);
    }

    public static boolean isEligibleForCustomization(URL fileOrDirectory) {
        String absolutePath = fileOrDirectory.getFile();
        return absolutePath.endsWith(".amx") || absolutePath.endsWith(".cpx") || absolutePath.endsWith(".dcx") || absolutePath.endsWith(".xml") && !absolutePath.contains(_MDS_DIR);
    }

    public static boolean isMDSRepositoryDir(URL url) {
        return url.getPath().endsWith(_MDS_DIR);
    }

    public static CustClassList getCustClass(Workspace workspace) {
        return (CustClassList)MDSDesignTime.getInstance().getCustomizationManager().getCurrentCustomizationContext(workspace);
    }

    public static boolean hasCustClass(Workspace workspace) {
        CustClassList custClassList = CustomizationUtils.getCustClass(workspace);
        return custClassList != null && custClassList.size() != 0;
    }

    public static ArrayList<String> getCustClassNames(Workspace workspace) {
        CustConfig custConfig;
        ArrayList<String> custClassNameList = new ArrayList<String>();
        URL adfConfigURL = CustomizationUtils._getAdfConfigURL(workspace);
        if (adfConfigURL != null && (custConfig = CustomizationUtils._parseADFConfigForCustomization(adfConfigURL)) != null) {
            CustClassListMapping[] mappings = custConfig.getMappings();
            CustClassList custClassList = null;
            if (mappings != null && mappings.length > 0) {
                for (CustClassListMapping mapping : mappings) {
                    custClassList = mapping.getCustClassList();
                    CustomizationUtils._addCustClassName(custClassNameList, custClassList);
                }
            }
        }
        return custClassNameList;
    }

    public static CustConfig getCustConfigFromAdfConfig(Workspace workspace) {
        URL adfConfigURL = CustomizationUtils._getAdfConfigURL(workspace);
        return CustomizationUtils._parseADFConfigForCustomization(adfConfigURL);
    }

    private static URL _getAdfConfigURL(Workspace workspace) {
        ApplicationContent appContent = ApplicationContent.getInstance((Workspace)workspace);
        return URLFactory.newURL((URL)appContent.getADFMetaInfURL(), (String)_ADF_CONFIG_FILE);
    }

    private static CustConfig _parseADFConfigForCustomization(URL adfConfigURL) {
        CustConfig custConfig = null;
        try {
            Document domDoc = CustomizationUtils._parseADFConfig(adfConfigURL);
            if (domDoc != null) {
                NodeList nodeList = domDoc.getElementsByTagNameNS(_MDS_CONFIG_NS, _CUST_CONFIG_TAG);
                Element configElem = null;
                if (nodeList != null && nodeList.getLength() > 0) {
                    configElem = (Element)nodeList.item(0);
                }
                if (configElem != null) {
                    custConfig = new CustConfig(configElem);
                }
            }
        }
        catch (MDSConfigurationException e) {
            _sLogger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-01504"));
        }
        catch (Exception e) {
            _sLogger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-01505"));
        }
        return custConfig;
    }

    private static Document _parseADFConfig(URL url) throws ParserConfigurationException, IOException, SAXException, URISyntaxException {
        Document dom = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder parser = factory.newDocumentBuilder();
        dom = parser.parse(url.toURI().toString());
        return dom;
    }

    private static void _addCustClassName(ArrayList<String> custClassNameList, CustClassList custClassList) {
        if (custClassList != null && custClassList.size() != 0) {
            for (int i = 0; i < custClassList.size(); ++i) {
                String custClassName = custClassList.item(i).getClass().getName();
                custClassNameList.add(custClassName);
            }
        }
    }
}

