/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.customization;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import oracle.adfmf.common.MobileException;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.customization.CustomizationUtils;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.mds.config.CustClassListMapping;
import oracle.mds.config.CustConfig;
import oracle.mds.config.MDSConfig;
import oracle.mds.config.MDSConfigurationException;
import oracle.mds.config.NamespaceConfig;
import oracle.mds.config.PConfig;
import oracle.mds.core.MDSInstance;
import oracle.mds.core.MDSSession;
import oracle.mds.core.MetadataObject;
import oracle.mds.core.SessionOptions;
import oracle.mds.cust.CustClassList;
import oracle.mds.exception.MDSException;
import oracle.mds.internal.dt.config.MDSDTConfigManager;
import oracle.mds.mopart.MOPart;
import oracle.mds.naming.Namespace;
import oracle.mds.persistence.MetadataStore;
import oracle.mds.persistence.stores.file.FileMetadataStore;
import oracle.xml.parser.v2.XMLDocument;

public final class CustomizationMerger {
    private static final CustomizationMerger _sMerger = new CustomizationMerger();
    private Logger _logger = null;
    private Workspace _workspace = null;
    private URL _parentUrl = null;

    private CustomizationMerger() {
    }

    public static CustomizationMerger getCustomizationMerger() {
        return _sMerger;
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public void setURL(URL url) {
        this._parentUrl = url;
    }

    public void setWorkspace(Workspace workspace) {
        this._workspace = workspace;
    }

    public boolean isCustomizationsEnabled() {
        if (this._workspace != null) {
            return CustomizationUtils.isCustomizationsEnabled(this._workspace);
        }
        return false;
    }

    public void mergeCustomization() throws MobileException {
        MDSInstance mdsInstance = this.getOrCreateMDSInstance();
        mdsInstance.clearCache();
        MDSSession mdsSession = this.createMDSSession(mdsInstance);
        this.doMerge(mdsSession, this._parentUrl);
    }

    public void removeMDSRepository() throws IOException {
        this._doRemoveMDSRepository(this._parentUrl);
    }

    private MDSInstance getOrCreateMDSInstance() throws MobileException {
        String mdsMetadataPath = URLFileSystem.getPath((URL)this._parentUrl);
        String normalizedMdsMetadataPath = FileUtils.stripSuffixFromString(mdsMetadataPath, "/");
        String mdsInstanceName = this._createMdsInstanceName(normalizedMdsMetadataPath);
        try {
            Namespace namespace = Namespace.create((String)"/");
            FileMetadataStore metadataStore = new FileMetadataStore(normalizedMdsMetadataPath);
            NamespaceConfig namespaceConfig = new NamespaceConfig(namespace, (MetadataStore)metadataStore);
            PConfig pConfig = new PConfig(new NamespaceConfig[]{namespaceConfig});
            MDSConfig mdsConfig = MDSDTConfigManager.getInstance().getMDSConfig(this._workspace, pConfig, true);
            return MDSInstance.getOrCreateInstance((String)mdsInstanceName, (MDSConfig)mdsConfig);
        }
        catch (MDSException e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01500", mdsInstanceName, mdsMetadataPath);
            throw new MobileException(msg, e);
        }
    }

    private MDSSession createMDSSession(MDSInstance mdsInstance) throws MobileException {
        try {
            CustClassList custClassList = CustomizationUtils.getCustClass(this._workspace);
            CustClassListMapping custClassListMapping = new CustClassListMapping("/", null, null, custClassList);
            CustConfig custConfig = new CustConfig(new CustClassListMapping[]{custClassListMapping});
            SessionOptions sessionOptions = new SessionOptions(null, null, custConfig);
            return mdsInstance.createSession(sessionOptions, null);
        }
        catch (MDSConfigurationException e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01501");
            throw new MobileException(msg, e);
        }
    }

    private void doMerge(MDSSession mdsSession, URL baseUrl) throws MobileException {
        URL[] children;
        for (URL child : children = URLFileSystem.list((URL)baseUrl)) {
            XMLDocument mergedDoc;
            if (URLFileSystem.isDirectory((URL)child)) {
                this.doMerge(mdsSession, child);
                continue;
            }
            if (!CustomizationUtils.isEligibleForCustomization(child) || (mergedDoc = this.maybeGetCustomizedFileContent(child, mdsSession)) == null) continue;
            this._replaceFile(child, mergedDoc);
        }
    }

    private XMLDocument maybeGetCustomizedFileContent(URL fileUrl, MDSSession mdsSession) throws MobileException {
        try {
            boolean MUST_CONSUME_BASE = true;
            String relativePathToFile = URLFileSystem.toRelativeSpec((URL)fileUrl, (URL)this._parentUrl, (boolean)true);
            MetadataObject mergedMetadata = mdsSession.getMetadataObject("/" + relativePathToFile);
            if (mergedMetadata == null) {
                String msg = MobileResourceUtils.getMsg("ADF-MBL-01502", fileUrl.toExternalForm());
                throw new MobileException(msg);
            }
            if (this._isCustomizedMetadataObject(mergedMetadata)) {
                return (XMLDocument)mergedMetadata.getDocument(true);
            }
            return null;
        }
        catch (MDSException e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01502", fileUrl.toExternalForm());
            throw new MobileException(msg, e);
        }
    }

    private boolean _isCustomizedMetadataObject(MetadataObject mergedMetadata) {
        List moParts = mergedMetadata.getParts();
        for (MOPart moPart : moParts) {
            MOPart.MOPartType moPartType = moPart.getPartType();
            if (MOPart.MOPartType.CUSTOMIZATION != moPartType) continue;
            return true;
        }
        return false;
    }

    private void _replaceFile(URL fileToReplace, XMLDocument mergedDoc) throws MobileException {
        OutputStream out = null;
        try {
            out = URLFileSystem.openOutputStream((URL)fileToReplace);
            mergedDoc.print(out, "UTF-8");
        }
        catch (Throwable e) {
            String msg = MobileResourceUtils.getMsg("ADF-MBL-01503", fileToReplace.toExternalForm());
            throw new MobileException(msg, e);
        }
        finally {
            FileUtils.closeStream(out, this._logger);
        }
    }

    private void _doRemoveMDSRepository(URL url) throws IOException {
        URL[] children;
        for (URL child : children = URLFileSystem.list((URL)url)) {
            if (!URLFileSystem.isDirectory((URL)child)) continue;
            if (CustomizationUtils.isMDSRepositoryDir(child)) {
                FileUtils.deleteDirectory(child);
                continue;
            }
            this._doRemoveMDSRepository(child);
        }
    }

    private String _createMdsInstanceName(String mdsMetadataPath) {
        String prefix = "AdfMobileMdsInstanceName-";
        StringBuilder mdsInstanceName = new StringBuilder("AdfMobileMdsInstanceName-");
        String mdsPathNoForwardSlash = mdsMetadataPath.replace('/', '_');
        mdsInstanceName.append(mdsPathNoForwardSlash);
        return mdsInstanceName.toString();
    }
}

