/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util.xsltransformer;

import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XSLParameter {
    private String m_namespace;
    private String m_parameterName;
    private Object m_parameterValue;

    public XSLParameter(String namespace, String parameterName, String parameterValue) {
        if (!ModelUtil.hasLength((String)parameterName) || !ModelUtil.hasLength((String)parameterValue) || null == namespace) {
            throw new IllegalArgumentException();
        }
        this.m_namespace = namespace;
        this.m_parameterName = parameterName;
        this.m_parameterValue = XSLParameter.toXsltString(parameterValue);
    }

    public XSLParameter(String namespace, String parameterName, NodeList parameterValue) {
        if (!ModelUtil.hasLength((String)parameterName) || parameterValue == null || null == namespace) {
            throw new IllegalArgumentException();
        }
        this.m_namespace = namespace;
        this.m_parameterName = parameterName;
        this.m_parameterValue = parameterValue;
    }

    String getNamespace() {
        return this.m_namespace;
    }

    String getParameterName() {
        return this.m_parameterName;
    }

    Object getParameterValue() {
        return this.m_parameterValue;
    }

    public static <T> NodeList createNodeList(String elementName, List<T> list, ListVisitor visitor) throws ParserConfigurationException, IllegalArgumentException {
        if (!ModelUtil.hasLength((String)elementName) || null == list || null == visitor) {
            throw new IllegalArgumentException();
        }
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        String TEMP_DOCUMENT_ROOT_NAME = "Root";
        Element rootElement = document.createElementNS(null, "Root");
        document.appendChild(rootElement);
        for (T currObject : list) {
            String stringRep = visitor.getStringRepresentation(currObject);
            Element element = document.createElementNS(null, elementName);
            element.appendChild(document.createTextNode(stringRep));
            rootElement.appendChild(element);
        }
        return rootElement.getChildNodes();
    }

    public static String toXsltString(String unNormalizedString) {
        if (!ModelUtil.hasLength((String)unNormalizedString)) {
            throw new IllegalArgumentException();
        }
        if (unNormalizedString.contains("\"") || unNormalizedString.contains("'")) {
            throw new IllegalArgumentException();
        }
        return String.format("%s%s%s", "'", unNormalizedString, "'");
    }

    public static interface ListVisitor {
        public String getStringRepresentation(Object var1);
    }
}

