/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util.exec;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.adfmf.common.util.exec.CollectStreamThread;
import oracle.adfmf.common.util.exec.ExecResults;

public class ExecWrapper {
    private static final int _WAIT_INFINITELY = 0;

    public static ExecResults runTool(List<String> cmdList, String[] envArray, File directory) throws IOException, InterruptedException {
        ExecResults execResults = ExecWrapper._executeImpl(cmdList, envArray, directory, 0);
        return execResults;
    }

    public static ExecResults runTool(List<String> cmdList) throws IOException, InterruptedException {
        return ExecWrapper.runTool(cmdList, null, null);
    }

    public static ExecResults runTool(List<String> cmdList, int readerThreadTimeoutMs) throws IOException, InterruptedException {
        return ExecWrapper._executeImpl(cmdList, null, null, readerThreadTimeoutMs);
    }

    private static ExecResults _executeImpl(List<String> cmdList, String[] envArray, File directory, int readerThreadTimeoutMs) throws IOException, InterruptedException {
        ArrayList<String> stdOut = new ArrayList<String>();
        ArrayList<String> stdErr = new ArrayList<String>();
        ArrayList<CollectStreamThread> trackedThreads = new ArrayList<CollectStreamThread>();
        Runtime runtime = Runtime.getRuntime();
        String[] cmdArray = cmdList.toArray(new String[0]);
        Process process = runtime.exec(cmdArray, envArray, directory);
        trackedThreads.add(new CollectStreamThread(process.getInputStream(), stdOut));
        trackedThreads.add(new CollectStreamThread(process.getErrorStream(), stdErr));
        for (Thread thread : trackedThreads) {
            thread.start();
        }
        process.waitFor();
        for (Thread thread : trackedThreads) {
            thread.join(readerThreadTimeoutMs);
        }
        ExecResults execResults = new ExecResults(cmdList, directory, process.exitValue(), stdErr, stdOut);
        return execResults;
    }
}

