/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.exec.ExecResults;
import oracle.javatools.util.ModelUtil;

public class ExecResultsLogger {
    private boolean _logCommandLine = true;
    private boolean _logStandardOutput = true;
    private boolean _logStandardError = true;
    private boolean _logReturnCode = true;
    private final Logger _logger;
    private final ExecResults _execResults;
    private final ArrayList<String> _errorTokenList;
    private final ArrayList<String> _warningTokenList;

    public ExecResultsLogger(Logger logger, ExecResults execResults, List<String> errorTokenList, List<String> warningTokenList) {
        if (null == logger || null == execResults) {
            throw new IllegalArgumentException();
        }
        this._logger = logger;
        this._execResults = new ExecResults(execResults.getCommandList(), execResults.getWorkingDirectory(), execResults.getReturnCode(), execResults.getStandardError(), execResults.getStandardOutput());
        this._errorTokenList = null != errorTokenList ? new ArrayList<String>(errorTokenList) : new ArrayList();
        this._warningTokenList = null != warningTokenList ? new ArrayList<String>(warningTokenList) : new ArrayList();
    }

    public void setLogCommandLine(boolean logCommandLine) {
        this._logCommandLine = logCommandLine;
    }

    public void setLogStandardOutput(boolean logStandardOutput) {
        this._logStandardOutput = logStandardOutput;
    }

    public void setLogStandardError(boolean logStandardError) {
        this._logStandardError = logStandardError;
    }

    public void setLogReturnCode(boolean logReturnCode) {
        this._logReturnCode = logReturnCode;
    }

    public void logExecResults(Level verboseMessageLogLevel, String successMessageKey, String errorMessageKey) {
        this._maybeLogCommandLine();
        this._maybeLogStandardError(verboseMessageLogLevel);
        this._maybeLogStandardOutput(verboseMessageLogLevel);
        this._maybeLogReturnCode(successMessageKey, errorMessageKey);
    }

    public void logExecResults() {
        this.logExecResults(Level.INFO, null, null);
    }

    public void logExecResults(Level verboseMessageLogLevel) {
        this.logExecResults(verboseMessageLogLevel, null, null);
    }

    private void _maybeLogStandardError(Level verboseMessageLogLevel) {
        if (!this._logStandardError) {
            return;
        }
        this._logMessages(verboseMessageLogLevel, this._execResults.getStandardError(), this._execResults.getStandardErrorErrorMessages(this._errorTokenList), this._execResults.getStandardErrorWarningMessages(this._warningTokenList));
    }

    private void _maybeLogStandardOutput(Level verboseMessageLogLevel) {
        if (!this._logStandardOutput) {
            return;
        }
        this._logMessages(verboseMessageLogLevel, this._execResults.getStandardOutput(), this._execResults.getStandardOutputErrorMessages(this._errorTokenList), this._execResults.getStandardOutputWarningMessages(this._warningTokenList));
    }

    private void _maybeLogReturnCode(String successMessageKey, String errorMessageKey) {
        if (!this._logReturnCode) {
            return;
        }
        if (this._execResults.returnCodeOK()) {
            if (!this._execResults.completedOK(this._errorTokenList)) {
                this._logger.info(this._execResults.getReturnCodeErrorMessage());
            } else {
                this._logger.info(this._getSuccessReturnCodeMessage(successMessageKey));
            }
        } else {
            this._logger.warning(this._getErrorReturnCodeMessage(errorMessageKey));
        }
    }

    private void _maybeLogCommandLine() {
        if (!this._logCommandLine) {
            return;
        }
        File workingDir = this._execResults.getWorkingDirectory();
        List<String> commandLineList = this._execResults.getCommandList();
        String commandLine = commandLineList.toString();
        if (null != workingDir) {
            commandLine = "[" + workingDir.getAbsolutePath() + "]";
            commandLine = commandLine.concat(commandLineList.toString());
        }
        this._logger.info(MobileResourceUtils.getMsg("ADF-MBL-20002", commandLine));
    }

    private String _getSuccessReturnCodeMessage(String successMessageKey) {
        String returnCodeSuccessMessage = "";
        returnCodeSuccessMessage = ModelUtil.hasLength((String)successMessageKey) ? MobileResourceUtils.getMsg(successMessageKey) : MobileResourceUtils.getMsg("ADF-MBL-20003");
        return returnCodeSuccessMessage;
    }

    private String _getErrorReturnCodeMessage(String errorMessageKey) {
        String returnCodeErrorMessage = "";
        if (!ModelUtil.hasLength((String)errorMessageKey)) {
            returnCodeErrorMessage = this._execResults.getReturnCodeErrorMessage();
        } else {
            String returnCodeInfo = MobileResourceUtils.getMsg("ADF-MBL-10001", this._execResults.getReturnCode());
            returnCodeErrorMessage = MobileResourceUtils.getMsg(errorMessageKey, returnCodeInfo);
        }
        return returnCodeErrorMessage;
    }

    private void _logMessages(Level verboseMessageLogLevel, List<String> messageList, List<String> errorMessages, List<String> warningMessages) {
        for (String currMessage : messageList) {
            Level logLevel = verboseMessageLogLevel;
            if (errorMessages.contains(currMessage)) {
                logLevel = Level.SEVERE;
            } else if (warningMessages.contains(currMessage)) {
                logLevel = Level.WARNING;
            }
            this._logger.log(logLevel, currMessage);
        }
    }
}

