/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.adfmf.common.util.MobileResourceUtils;

public class ExecResults {
    private final List<String> _cmdList = new ArrayList<String>();
    private final File _workingDirectory;
    private final List<String> _stdOutList = new ArrayList<String>();
    private final List<String> _stdErrList = new ArrayList<String>();
    private final int _returnCode;
    private static final int _SUCCESS = 0;

    public ExecResults(List<String> commandList, File workingDirectory, int returnCode, List<String> stdErrList, List<String> stdOutList) {
        this._cmdList.addAll(commandList);
        this._workingDirectory = workingDirectory;
        this._returnCode = returnCode;
        this._stdErrList.addAll(stdErrList);
        this._stdOutList.addAll(stdOutList);
    }

    public String getCommandLineFullyQualifiedPath() {
        String cmdLineExecutable = this._cmdList.get(0);
        cmdLineExecutable = cmdLineExecutable.replaceAll("\"", "");
        return cmdLineExecutable;
    }

    public List<String> getCommandList() {
        return new ArrayList<String>(this._cmdList);
    }

    public File getWorkingDirectory() {
        return this._workingDirectory;
    }

    public List<String> getStandardOutput() {
        return new ArrayList<String>(this._stdOutList);
    }

    public List<String> getStandardError() {
        return new ArrayList<String>(this._stdErrList);
    }

    public int getReturnCode() {
        return this._returnCode;
    }

    public String getReturnCodeErrorMessage() {
        String returnCodeInfo = MobileResourceUtils.getMsg("ADF-MBL-10001", this._returnCode);
        String returnCodeErrorMessage = MobileResourceUtils.getMsg("ADF-MBL-10002", returnCodeInfo);
        return returnCodeErrorMessage;
    }

    public boolean completedOK(List<String> errorTokenList) {
        List<String> errorMessages = this.getStandardErrorErrorMessages(errorTokenList);
        errorMessages.addAll(this.getStandardOutputErrorMessages(errorTokenList));
        return this._returnCode == 0 && errorMessages.isEmpty();
    }

    public String getErrorMessagesAsString(List<String> errorTokenList) {
        ArrayList<String> errorMessageList = new ArrayList<String>();
        if (!this.returnCodeOK()) {
            errorMessageList.add(this.getReturnCodeErrorMessage());
        }
        errorMessageList.addAll(this.getStandardErrorErrorMessages(errorTokenList));
        errorMessageList.addAll(this.getStandardOutputErrorMessages(errorTokenList));
        StringBuilder sb = new StringBuilder();
        int listSize = errorMessageList.size();
        for (String currError : errorMessageList) {
            sb.append(currError);
            if (listSize > 1) {
                sb.append("\n");
            }
            --listSize;
        }
        return sb.toString();
    }

    public String getMessageContentAsString() {
        ArrayList<String> errorMessageList = new ArrayList<String>();
        if (!this.returnCodeOK()) {
            errorMessageList.add(this.getReturnCodeErrorMessage());
        }
        String standardErrorHeader = MobileResourceUtils.getMsg("ADF-MBL-20026");
        String standardErrorFooter = MobileResourceUtils.getMsg("ADF-MBL-20027");
        errorMessageList.add(standardErrorHeader);
        errorMessageList.addAll(this.getStandardError());
        errorMessageList.add(standardErrorFooter);
        String standardOutputHeader = MobileResourceUtils.getMsg("ADF-MBL-20028");
        String standardOutputFooter = MobileResourceUtils.getMsg("ADF-MBL-20029");
        errorMessageList.add(standardOutputHeader);
        errorMessageList.addAll(this.getStandardOutput());
        errorMessageList.add(standardOutputFooter);
        StringBuilder sb = new StringBuilder();
        int listSize = errorMessageList.size();
        for (String currError : errorMessageList) {
            sb.append(currError);
            if (listSize > 1) {
                sb.append("\n");
            }
            --listSize;
        }
        return sb.toString();
    }

    public List<String> getStandardOutputErrorMessages(List<String> errorTokenList) {
        return this._getMessages(this.getStandardOutput(), errorTokenList);
    }

    public List<String> getStandardOutputWarningMessages(List<String> warningTokenList) {
        return this._getMessages(this.getStandardOutput(), warningTokenList);
    }

    public List<String> getStandardErrorErrorMessages(List<String> errorTokenList) {
        return this._getMessages(this.getStandardError(), errorTokenList);
    }

    public List<String> getStandardErrorWarningMessages(List<String> warningTokenList) {
        return this._getMessages(this.getStandardError(), warningTokenList);
    }

    public boolean returnCodeOK() {
        return this._returnCode == 0;
    }

    private boolean _messageContainsToken(String message, List<String> tokenList) {
        if (null == tokenList || tokenList.isEmpty()) {
            return false;
        }
        String messageLowerCase = message.toLowerCase();
        for (String currToken : tokenList) {
            String currTokenLowerCase = currToken.toLowerCase();
            if (!messageLowerCase.contains(currTokenLowerCase)) continue;
            return true;
        }
        return false;
    }

    private List<String> _getMessages(List<String> messageList, List<String> tokenList) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (String currMessage : messageList) {
            if (!this._messageContainsToken(currMessage, tokenList)) continue;
            returnList.add(currMessage);
        }
        return returnList;
    }
}

