/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.webapp.model.content.dom.util.XmlDomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlUtils {
    private XmlUtils() {
    }

    public static String toXmlString(Document doc) throws Exception {
        StringWriter stringWriter = new StringWriter();
        TransformerFactory transformerFactory = null;
        try {
            transformerFactory = TransformerFactory.newInstance();
        }
        catch (TransformerFactoryConfigurationError error) {
            throw new Exception(error);
        }
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(stringWriter);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        return stringWriter.toString();
    }

    public static Set<String> gatherIds(AbstractModel model) {
        return XmlUtils.gatherIds(model, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> gatherIds(AbstractModel model, String parentNodeName) {
        HashSet<String> idSet = new HashSet<String>();
        model.acquireReadLock();
        try {
            TreeTraversal traversal = model.getTreeTraversal();
            Element root = model.getDocument().getDocumentElement();
            Element parent = null;
            if (parentNodeName == null || parentNodeName.equals(root.getLocalName())) {
                parent = root;
            } else {
                NodeList nodeList = root.getElementsByTagNameNS("*", parentNodeName);
                if (nodeList == null || nodeList.getLength() == 0) {
                    HashSet<String> hashSet = idSet;
                    return hashSet;
                }
                parent = (Element)nodeList.item(0);
            }
            String parentId = null;
            if (1 == parent.getNodeType()) {
                parentId = parent.getAttributeNS(null, "id");
            }
            XmlUtils._gatherIdsHelper(parent, idSet, traversal);
            if (parentId != null && !parentId.trim().isEmpty()) {
                idSet.remove(parentId.trim());
            }
            HashSet<String> hashSet = idSet;
            return hashSet;
        }
        finally {
            model.releaseReadLock();
        }
    }

    public static boolean isAttributeSupported(XmlMetadataResolver xmlResolver, Element element, String attributeName) {
        if (element == null) {
            return false;
        }
        ElementDef elemDef = (ElementDef)xmlResolver.getGrammarComponent((Node)element);
        return elemDef != null && elemDef.getAttributeDefByName(attributeName) != null;
    }

    public static boolean isAttributeRequired(XmlMetadataResolver xmlResolver, Element element, String attributeName) {
        if (element == null) {
            return false;
        }
        ElementDef elemDef = (ElementDef)xmlResolver.getGrammarComponent((Node)element);
        if (elemDef == null) {
            return false;
        }
        AttributeDef attrDef = elemDef.getAttributeDefByName(attributeName);
        if (attrDef != null) {
            return attrDef.isRequired();
        }
        return false;
    }

    public static List<Node> getNamedChildElements(Element parent, String childName) {
        ArrayList<Node> childrenList = new ArrayList<Node>();
        NodeList children = parent.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node child = children.item(index);
            if (!childName.equals(child.getLocalName())) continue;
            childrenList.add(child);
        }
        return Collections.unmodifiableList(childrenList);
    }

    public static List<Node> getNamedChildElementsByNS(Element parentElem, String childNamespaceUri, String childLocalName) {
        if (null == parentElem || !ModelUtil.hasLength((String)childNamespaceUri) || !ModelUtil.hasLength((String)childLocalName)) {
            throw new IllegalArgumentException();
        }
        ArrayList<Node> childList = new ArrayList<Node>();
        NodeList nodeList = parentElem.getElementsByTagNameNS(childNamespaceUri, childLocalName);
        for (int elemIdx = 0; elemIdx < nodeList.getLength(); ++elemIdx) {
            childList.add(nodeList.item(elemIdx));
        }
        return Collections.unmodifiableList(childList);
    }

    public static Node getFirstChildNode(Element parent, String childName) {
        Node firstChild = null;
        if (parent == null || childName == null) {
            return firstChild;
        }
        List<Node> childNodes = XmlUtils.getNamedChildElements(parent, childName);
        if (!childNodes.isEmpty()) {
            firstChild = childNodes.get(0);
        }
        return firstChild;
    }

    public static Node getFirstNamedChildElement(Document document, String namespace, String childName) {
        Node firstChild = null;
        if (document == null || childName == null || childName.isEmpty()) {
            return firstChild;
        }
        NodeList children = document.getElementsByTagNameNS(namespace, childName);
        if (children != null && children.getLength() > 0) {
            firstChild = children.item(0);
        }
        return firstChild;
    }

    public static void setDefaultSelection(AbstractModel model) {
        new NonDomMutationTransactionTask(){

            protected void performTask(AbstractModel model) {
                Node childNodeToSelect = XmlUtils.getFirstNamedChildElement(model.getDocument(), "http://xmlns.oracle.com/adf/mf/amx", "panelPage");
                if (childNodeToSelect != null) {
                    XmlDomUtils.setSelection((AbstractModel)model, (Node)childNodeToSelect);
                }
            }
        }.run(model);
    }

    private static void _gatherIdsHelper(Node parent, Set<String> idSet, TreeTraversal traversal) {
        String id;
        if (1 == parent.getNodeType() && (id = ((Element)parent).getAttributeNS(null, "id")) != null && !(id = id.trim()).isEmpty()) {
            idSet.add(id);
        }
        Node child = traversal.getFirstChild(parent);
        while (child != null) {
            XmlUtils._gatherIdsHelper(child, idSet, traversal);
            child = traversal.getNextSibling(child);
        }
    }
}

