/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util;

import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import oracle.adfmf.common.util.McAppUtils;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resourcebundle.ResourceBundleOptions;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdevimpl.compiler.CompilerOptionManager;
import oracle.jdevimpl.compiler.JavacCompilerDescription;

public final class ProjectUtils {
    private static final String _CVM_JDK_NAME = "CVM_JDK";
    private static final String[] _EXTS_TO_ADD = new String[]{".db", ".sql"};
    private static final String _REMOTE_DEBUG_PORT_NUMBER = "8000";

    public static void setDefaultJDK(Project project) {
        JProjectLibraries jprLibs = JProjectLibraries.getInstance((PropertyStorage)project);
        JDK cvmJdk = JLibraryManager.getAddinLibraries().findJDK((Object)_CVM_JDK_NAME);
        jprLibs.setJDK(cvmJdk);
    }

    public static void setCurrentCompilerJavac(Project project) {
        CompilerOptionManager compilerOptionManager = CompilerOptionManager.getInstance((PropertyStorage)project);
        compilerOptionManager.setCurrentCompiler(new JavacCompilerDescription().getCompilerName());
        BuildSystemConfiguration buildConfig = BuildSystemConfiguration.getInstance((PropertyStorage)project);
        for (String ext : _EXTS_TO_ADD) {
            buildConfig.addCopyResExtension(ext);
        }
    }

    public static void setJdkVerSource(Project project, String version) {
        BuildSystemConfiguration bsc = BuildSystemConfiguration.getInstance((PropertyStorage)project);
        bsc.setSource(version);
    }

    public static void setJdkVerTarget(Project project, String version) {
        BuildSystemConfiguration bsc = BuildSystemConfiguration.getInstance((PropertyStorage)project);
        bsc.setTarget(version);
    }

    public static void setProjectDefaultBundleTypeToXliff(Project project) {
        ResourceBundleOptions projectBundleOptions = ResourceBundleOptions.getInstance((PropertyStorage)project);
        ListStructure supportedBundleTypes = ListStructure.newInstance();
        supportedBundleTypes.add((Object)".xlf");
        projectBundleOptions.setAvailableBundleTypeList(supportedBundleTypes);
        projectBundleOptions.setDefaultBundleTypeId("xliffResourceBundleId");
    }

    public static String[] getExtsToAdd() {
        return (String[])_EXTS_TO_ADD.clone();
    }

    public static void enableRemoteDebugging(Project project) {
        RunConfiguration runConfiguration = RunConfigurations.getActiveRunConfiguration((Project)project);
        runConfiguration.setRemoteDebuggingProfiling(true);
        runConfiguration.setJavaRemoteDebugPort(_REMOTE_DEBUG_PORT_NUMBER);
    }

    public static void addProjectLibrary(final Project project, final URL libraryJarUrl) {
        project.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                URLPath existingClassPath;
                String projectLibraryName;
                JProjectLibraries projectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
                JProjectLibraryList projectLibraryList = projectLibraries.getProjectLibraryList();
                JLibrary existingLibrary = projectLibraryList.findLibrary((Object)(projectLibraryName = URLFileSystem.getFileName((URL)libraryJarUrl)));
                if (existingLibrary != null && (existingClassPath = existingLibrary.getClassPath()).contains(libraryJarUrl)) {
                    return;
                }
                JLibrary projectLibrary = projectLibraryList.addLibrary(projectLibraryName);
                projectLibrary.setLocked(true);
                URLPath path = new URLPath();
                path.add(libraryJarUrl);
                projectLibrary.setClassPath(path);
                projectLibrary.setDeployedByDefault(Boolean.TRUE);
                projectLibraries.setProjectLibraryList(projectLibraryList);
                projectLibraries.addLibrary(projectLibrary.getID());
            }
        });
    }

    public static boolean validateAppControllerProjectDependencies(Workspace workspace, Logger logger) {
        Project appControllerProject = McAppUtils.getApplicationControllerProject(workspace, logger);
        List<Project> featureProjectList = McAppUtils.findProjectsWithFeatures(workspace);
        return ProjectUtils.hasValidDependencies(appControllerProject, featureProjectList);
    }

    public static boolean hasValidDependencies(Project project, List<Project> invalidProjectList) {
        DependencyConfiguration projectDepends = DependencyConfiguration.getInstance((Project)project);
        List projectDependList = projectDepends.getDependencyList();
        if (null != projectDependList && null != invalidProjectList) {
            for (Dependable dependable : projectDependList) {
                Project dependentProject = (Project)dependable.getSource();
                if (!invalidProjectList.contains(dependentProject)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean projectIsAppController(Project project, Workspace workspace) {
        Project appControllerProject = McAppUtils.getApplicationControllerProject(workspace, null);
        return null != project && project.equals((Object)appControllerProject);
    }

    public static boolean projectIsMobileViewController(Project project) {
        return URLFileSystem.exists((URL)McAppUtils.getProjectFeatureXmlUrl(project));
    }
}

