/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.exec.ExecResults;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.VersionNumber;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;

public class PreferenceUtils {
    public static final String SDK_PATH_USER_NAME_DIR_TOKEN = MobileResourceUtils.getText("SDK_PATH_USER_NAME_DIR_TOKEN");
    public static final String SDK_PATH_WINDOWS_PROGRAM_FILES_TOKEN = MobileResourceUtils.getText("SDK_PATH_WINDOWS_PROGRAM_FILES_TOKEN");
    public static final String SDK_PATH_WINDOWS_X86_TOKEN = MobileResourceUtils.getText("SDK_PATH_WINDOWS_PROGRAM_FILES_X86_TOKEN");

    public static String getAndroidSdkPathExample() {
        return MobileResourceUtils.getText("SDK_PATH_EXAMPLE_STRING", PreferenceUtils.getAndroidDefaultSdkPath());
    }

    public static String getAndroidDefaultSdkPath() {
        if (PlatformUtils.isMac()) {
            String oldSdkLocation;
            String sdkLocation = MobileResourceUtils.getText("ANDROID_SDK_LOCATION_MAC");
            if (!PreferenceUtils._doesPathExist(sdkLocation) && PreferenceUtils._doesPathExist(oldSdkLocation = MobileResourceUtils.getText("ANDROID_SDK_HISTORIC_LOCATION_MAC"))) {
                sdkLocation = oldSdkLocation;
            }
            return sdkLocation;
        }
        if (PlatformUtils.isLinux()) {
            String oldSdkLocation;
            String sdkLocation = MobileResourceUtils.getText("ANDROID_SDK_LOCATION_LINUX", PreferenceUtils.getUserSubFolderName());
            if (!PreferenceUtils._doesPathExist(sdkLocation) && PreferenceUtils._doesPathExist(oldSdkLocation = MobileResourceUtils.getText("ANDROID_SDK_HISTORIC_LOCATION_LINUX"))) {
                sdkLocation = oldSdkLocation;
            }
            return sdkLocation;
        }
        assert (PlatformUtils.isWindows());
        return PreferenceUtils.getCorrectWindowsProgramFilesPath(MobileResourceUtils.getText("ANDROID_SDK_LOCATION_WINDOWS"));
    }

    public static String getAndroidPlatformPathExample() {
        return MobileResourceUtils.getText("SDK_PATH_EXAMPLE_STRING", PreferenceUtils.getAndroidDefaulPlatformPath());
    }

    public static String getAndroidDefaulPlatformPath() {
        String sdkPath = PreferenceUtils.getAndroidDefaultSdkPath();
        if (PlatformUtils.isMac() || PlatformUtils.isLinux()) {
            return sdkPath.concat(MobileResourceUtils.getText("ANDROID_PLATFORM_MAC_LINUX_SUBFOLDER"));
        }
        assert (PlatformUtils.isWindows());
        return sdkPath.concat(MobileResourceUtils.getText("ANDROID_PLATFORM_WINDOWS_SUBFOLDER"));
    }

    public static String getAndroidBuildToolsPathExample() {
        return MobileResourceUtils.getText("SDK_PATH_EXAMPLE_STRING", PreferenceUtils.getCorrectedAndroidBuildToolsDir(null));
    }

    public static String getAndroidDefaultBuildToolsPath() {
        String tempPath;
        String sdkPath = PreferenceUtils.getAndroidDefaultSdkPath();
        String buildToolsSubfolder = MobileResourceUtils.getText("ANDROID_BUILD_TOOLS_WINDOWS_SUBFOLDER");
        String buildToolsHistoricalSubfolder = MobileResourceUtils.getText("ANDROID_BUILD_TOOLS_HISTORICAL_WINDOWS_SUBFOLDER");
        if (PlatformUtils.isMac() || PlatformUtils.isLinux()) {
            buildToolsSubfolder = sdkPath.concat(MobileResourceUtils.getText("ANDROID_BUILD_TOOLS_MAC_LINUX_SUBFOLDER"));
            buildToolsHistoricalSubfolder = sdkPath.concat(MobileResourceUtils.getText("ANDROID_BUILD_TOOLS_HISTORICAL_MAC_LINUX_SUBFOLDER"));
        }
        if (PreferenceUtils._doesPathExist(tempPath = sdkPath.concat(buildToolsSubfolder))) {
            File dir = new File(tempPath);
            File[] subDirs = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            VersionNumber currentHighVersion = new VersionNumber("0.0");
            for (File subDir : subDirs) {
                URL currentURL = URLFactory.newFileURL((File)subDir);
                String buildToolsVersionFolder = PreferenceUtils._getLastFolderFromUrl(currentURL.getPath());
                VersionNumber buildToolsVersionNumber = new VersionNumber(buildToolsVersionFolder);
                if (!currentHighVersion.isBefore(buildToolsVersionNumber)) continue;
                currentHighVersion = buildToolsVersionNumber;
            }
            tempPath = tempPath.concat(currentHighVersion.toString());
        } else {
            tempPath = sdkPath.concat(buildToolsHistoricalSubfolder);
        }
        return tempPath;
    }

    public static String getCorrectedAndroidBuildToolsDir(String storedBuildToolsDir) {
        String buildToolsPath = null != storedBuildToolsDir && !storedBuildToolsDir.isEmpty() ? storedBuildToolsDir : PreferenceUtils.getAndroidDefaultBuildToolsPath();
        return buildToolsPath;
    }

    public static String getIosSdkDirExample() {
        return MobileResourceUtils.getText("SDK_PATH_EXAMPLE_STRING", PreferenceUtils.getIosSdkDir());
    }

    public static String getIosSdkDir() {
        if (PreferenceUtils._useXcode42Examples()) {
            return MobileResourceUtils.getText("IOS_SDK_DEVELOPER_DIR");
        }
        return MobileResourceUtils.getText("IOS_SDK_DIR");
    }

    public static String getIosXcodebuildDirExample() {
        return MobileResourceUtils.getText("SDK_PATH_EXAMPLE_STRING", PreferenceUtils.getIosXcodebuildDir());
    }

    public static String getIosXcodebuildDir() {
        if (PreferenceUtils._useXcode42Examples()) {
            return MobileResourceUtils.getText("IOS_XCODEBUILD_42_DIR");
        }
        return MobileResourceUtils.getText("IOS_XCODEBUILD_DIR");
    }

    public static String getUserIosItunesDirExample() {
        return MobileResourceUtils.getText("SDK_PATH_EXAMPLE_STRING", PreferenceUtils.getUserIosItunesDir());
    }

    public static String getUserIosItunesDir() {
        String userFolderName = SDK_PATH_USER_NAME_DIR_TOKEN;
        if (PlatformUtils.isMac()) {
            userFolderName = PreferenceUtils.getUserSubFolderName();
        }
        return MobileResourceUtils.getText("IOS_ITUNES_DIR", userFolderName);
    }

    public static String getUserSubFolderName() {
        String userName = ADFMobileConstants.USER_NAME;
        if (!ModelUtil.hasLength((String)userName)) {
            userName = SDK_PATH_USER_NAME_DIR_TOKEN;
        }
        return userName;
    }

    public static String getCorrectWindowsProgramFilesPath(String windowsPath) {
        assert (PlatformUtils.isWindows());
        if (PreferenceUtils._doesPathExist(windowsPath)) {
            return windowsPath;
        }
        String windowsX86Path = MobileResourceUtils.getText("ANDROID_SDK_LOCATION_WINDOWS_X86");
        if (PreferenceUtils._doesPathExist(windowsX86Path)) {
            return windowsX86Path;
        }
        String windowsHistoricPath = MobileResourceUtils.getText("ANDROID_SDK_HISTORIC_LOCATION_WINDOWS");
        if (PreferenceUtils._doesPathExist(windowsHistoricPath)) {
            return windowsHistoricPath;
        }
        String windowsHistoricX86Path = MobileResourceUtils.getText("ANDROID_SDK_HISTORIC_LOCATION_WINDOWS_X86");
        if (PreferenceUtils._doesPathExist(windowsHistoricX86Path)) {
            return windowsHistoricX86Path;
        }
        return windowsPath;
    }

    private static boolean _doesPathExist(String urlPath) {
        URL url = URLFactory.newDirURL((String)urlPath);
        return null != url && URLFileSystem.isDirectory((URL)url);
    }

    private static String _getLastFolderFromUrl(String url) {
        return url.replaceFirst(".*/([^/?]+).*", "$1");
    }

    private static boolean _useXcode42Examples() {
        boolean useXCode42Examples;
        block6: {
            useXCode42Examples = false;
            Logger logger = Logger.getLogger("oracle.adfmf.framework.dt");
            try {
                if (!PlatformUtils.isMac()) break block6;
                ExecResults versionResults = IosDeployUtil.invokeXcodebuildVersion(logger, null);
                String xcode = "Xcode";
                for (String message : versionResults.getStandardOutput()) {
                    int lastIndex = message.lastIndexOf("Xcode");
                    if (lastIndex == -1 || message.length() <= lastIndex + "Xcode".length()) continue;
                    String xcodeVersion = message.substring(lastIndex + "Xcode".length()).trim();
                    if (null != xcodeVersion) {
                        String xcode43 = "4.3";
                        VersionNumber thisVersionNumber = new VersionNumber(xcodeVersion);
                        VersionNumber versionNumber43 = new VersionNumber("4.3");
                        if (thisVersionNumber.isBefore(versionNumber43)) {
                            useXCode42Examples = true;
                        }
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                logger.finest("Failed to get the XCode version.  Encountered IOException: " + ioe.getMessage());
            }
            catch (InterruptedException ie) {
                logger.finest("Failed to get the XCode version.  Encountered InterruptedException: " + ie.getMessage());
            }
        }
        return useXCode42Examples;
    }
}

