/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.framework.dt.editor.resource.EditorUIBundle;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.share.FastMessageFormat;

public final class MobileResourceUtils {
    private static final String LOG_MESSAGE_BUNDLE = "oracle.adfmf.common.resource.LogMessageBundle";
    private static final String UI_TEXT_BUNDLE = "oracle.adfmf.common.resource.UITextBundle";
    private static final ResourceBundle m_oLogMsgBundle = MobileResourceUtils.getBundle("oracle.adfmf.common.resource.LogMessageBundle");
    private static final ResourceBundle m_uiTextBundle = MobileResourceUtils.getBundle("oracle.adfmf.common.resource.UITextBundle");
    private static final Logger m_oLogger = Logger.getLogger(MobileResourceUtils.class.getName());
    private static final String ELEM_DESC = "ELEM_DESC_{0}";
    private static final String ATTR_DESC = "ATTR_DESC_{0}";
    private static final String ATTR_ELEM_DESC = "ATTR_DESC_{0}_{1}";
    private static final String HELP_TOPIC_FORMAT = "toc_htm#{0}";
    private static final Map<String, String> NS_MAP = new HashMap<String, String>(5);
    private static final Map<String, String> NAMESPACES_MAP;

    private static ResourceBundle getBundle(String sBundle) {
        ResourceBundle oResourceBundle = null;
        try {
            oResourceBundle = ResourceBundle.getBundle(sBundle);
        }
        catch (MissingResourceException mre) {
            m_oLogger.severe(MobileResourceUtils.getText("ERR_RESOURCE_BUNDLE_NOT_FOUND", sBundle));
            oResourceBundle = null;
        }
        return oResourceBundle;
    }

    public static String getMsg(String sKey) {
        String sText = null;
        if (m_oLogMsgBundle != null) {
            sText = MobileResourceUtils.getLocalFormattedMsg(m_oLogMsgBundle, sKey);
        }
        return sText;
    }

    public static String getMsg(String sKey, Object ... oParams) {
        String sText = null;
        if (m_oLogMsgBundle != null) {
            sText = MobileResourceUtils.getLocalFormattedMsg(m_oLogMsgBundle, sKey, oParams);
        }
        return sText;
    }

    private static String getLocalFormattedMsg(ResourceBundle oResource, String sKey) {
        String sResponse = null;
        try {
            sResponse = oResource.getString(sKey);
        }
        catch (Exception e) {
            m_oLogger.severe(MobileResourceUtils.getText("ERR_FAILED_TO_GET_STR_FOR_KEY", sKey));
            sResponse = null;
        }
        return sResponse;
    }

    private static String getLocalFormattedMsg(ResourceBundle oResource, String sKey, Object ... oParams) {
        String sResponse = null;
        try {
            sResponse = MessageFormat.format(oResource.getString(sKey), oParams);
        }
        catch (Exception e) {
            m_oLogger.severe(MobileResourceUtils.getText("ERR_FAILED_TO_GET_STR_FOR_KEY", sKey));
            sResponse = null;
        }
        return sResponse;
    }

    public static String getText(String key) {
        String text = null;
        if (m_uiTextBundle != null) {
            text = MobileResourceUtils.getLocalFormattedMsg(m_uiTextBundle, key);
        }
        return text;
    }

    public static String getText(String key, Object param1) {
        String text = null;
        if (m_uiTextBundle != null) {
            text = MobileResourceUtils.getLocalFormattedMsg(m_uiTextBundle, key, param1);
        }
        return text;
    }

    public static String getText(String key, Object param1, Object param2) {
        String text = null;
        if (m_uiTextBundle != null) {
            text = MobileResourceUtils.getLocalFormattedMsg(m_uiTextBundle, key, param1, param2);
        }
        return text;
    }

    public static String getText(String key, Object param1, Object param2, Object param3) {
        String text = null;
        if (m_uiTextBundle != null) {
            text = MobileResourceUtils.getLocalFormattedMsg(m_uiTextBundle, key, param1, param2, param3);
        }
        return text;
    }

    public static String getShortDescription(XmlKey xmlKey, String bundle) {
        if (xmlKey == null) {
            return null;
        }
        String resKey = null;
        if (xmlKey.getNodeType() == 1) {
            resKey = FastMessageFormat.formatMessage((String)ELEM_DESC, (String)xmlKey.getLocalName());
        } else if (xmlKey.getNodeType() == 2) {
            resKey = FastMessageFormat.formatMessage((String)ATTR_ELEM_DESC, (String)xmlKey.getElementQName().getName(), (String)xmlKey.getLocalName());
            String result = MobileResourceUtils.getLocalizedString(resKey, bundle, false);
            if (result != null) {
                return result;
            }
            resKey = FastMessageFormat.formatMessage((String)ATTR_DESC, (String)xmlKey.getLocalName());
        } else {
            return null;
        }
        return MobileResourceUtils.getLocalizedString(resKey, bundle, true);
    }

    public static String getLocalizedString(String resKey, String bundle, boolean logException) {
        String text;
        block2: {
            text = null;
            try {
                text = EditorUIBundle.getBundle(bundle).getString(resKey);
            }
            catch (Exception e) {
                if (!logException) break block2;
                m_oLogger.log(Level.WARNING, e.getMessage());
            }
        }
        return text;
    }

    public static String getHelpTopic(XmlKey key) {
        String qualifiedName;
        String helpTopic = null;
        if (key != null && (qualifiedName = MobileResourceUtils.getNameWithPrefix(key)) != null) {
            helpTopic = FastMessageFormat.formatMessage((String)HELP_TOPIC_FORMAT, (String)qualifiedName);
        }
        return helpTopic;
    }

    public static String getDisplayName(Map<String, String> displayNameMap, String elementName) {
        if (displayNameMap != null && displayNameMap.containsKey(elementName)) {
            return displayNameMap.get(elementName);
        }
        return MobileResourceUtils.convertFromCamelCase(elementName);
    }

    public static String convertFromCamelCase(String source) {
        if (source != null) {
            char ch;
            int sourceLength = source.length();
            StringBuffer camelcasedString = new StringBuffer(sourceLength);
            boolean previuosDash = false;
            boolean previuosUpperCase = false;
            boolean previuosLowerCase = false;
            int index = 0;
            if (Character.isLowerCase(ch = source.charAt(index++))) {
                camelcasedString.append(Character.toUpperCase(ch));
                previuosLowerCase = true;
            } else {
                camelcasedString.append(ch);
                previuosUpperCase = Character.isUpperCase(ch);
                boolean bl = previuosDash = ch == "-".charAt(0);
            }
            while (index < sourceLength) {
                ch = source.charAt(index);
                if (ch == "-".charAt(0)) {
                    camelcasedString.append(" ");
                    previuosDash = true;
                    previuosUpperCase = false;
                    previuosLowerCase = false;
                } else if (Character.isLowerCase(ch)) {
                    if (previuosDash) {
                        camelcasedString.append(Character.toUpperCase(ch));
                    } else {
                        camelcasedString.append(ch);
                    }
                    previuosDash = false;
                    previuosUpperCase = false;
                    previuosLowerCase = true;
                } else if (Character.isUpperCase(ch)) {
                    if (previuosLowerCase) {
                        camelcasedString.append(" ");
                    }
                    camelcasedString.append(ch);
                    previuosDash = false;
                    previuosUpperCase = true;
                    previuosLowerCase = false;
                } else {
                    camelcasedString.append(ch);
                    previuosDash = false;
                    previuosUpperCase = false;
                    previuosLowerCase = false;
                }
                ++index;
            }
            return camelcasedString.toString();
        }
        return source;
    }

    public static boolean isOldNamespace(String namespace) {
        return NAMESPACES_MAP.containsKey(namespace);
    }

    public static String getNewNamespace(String namespace) {
        return NAMESPACES_MAP.get(namespace);
    }

    private static String getNameWithPrefix(XmlKey xmlKey) {
        String nsPrefix;
        String qName = null;
        String namespace = null;
        QualifiedName attributeQName = xmlKey.getAttributeQName();
        if (attributeQName != null) {
            qName = attributeQName.getQualifiedName();
            namespace = attributeQName.getNamespace();
        } else {
            QualifiedName elementQName = xmlKey.getElementQName();
            if (elementQName != null) {
                qName = elementQName.getQualifiedName();
                namespace = elementQName.getNamespace();
            }
        }
        if (qName != null && (nsPrefix = NS_MAP.get(namespace)) != null) {
            qName = qName.replace(namespace, nsPrefix);
        }
        return qName;
    }

    static {
        NS_MAP.put("http://xmlns.oracle.com/adf/mf/amx", "amx");
        NS_MAP.put("http://xmlns.oracle.com/adf/mf/amx/dvt", "dvtm");
        NS_MAP.put("http://xmlns.oracle.com/adf/mf", "adfmf");
        NS_MAP.put("http://xmlns.oracle.com/adf/mf/config", "config");
        NS_MAP.put("http://xmlns.oracle.com/adf/mf/skin", "skin");
        NAMESPACES_MAP = new HashMap<String, String>(5);
        NAMESPACES_MAP.put("http://xmlns.oracle.com/jdev/amx", "http://xmlns.oracle.com/adf/mf/amx");
        NAMESPACES_MAP.put("http://xmlns.oracle.com/jdev/dvtm", "http://xmlns.oracle.com/adf/mf/amx/dvt");
        NAMESPACES_MAP.put("http://xmlns.oracle.com/jdev/adfmf", "http://xmlns.oracle.com/adf/mf");
        NAMESPACES_MAP.put("http://xmlns.oracle.com/jdev/adfmc", "http://xmlns.oracle.com/adf/mf/config");
        NAMESPACES_MAP.put("http://xmlns.oracle.com/jdev/adfms", "http://xmlns.oracle.com/adf/mf/skin");
    }
}

