/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.common.util;

import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.javatools.data.PropertyStorage;

public class McTechnologyUtils {
    public static ArrayList<Project> getTechnologyProjects(Workspace workspace, String techKey) {
        ArrayList<Project> techProjects = new ArrayList<Project>();
        Collection allProjects = workspace.projects();
        for (Project project : allProjects) {
            if (!McTechnologyUtils.hasTechnology(project, techKey)) continue;
            techProjects.add(project);
        }
        return techProjects;
    }

    public static boolean hasTechnology(Project project, String techKey) {
        TechnologyRegistry technologyRegistry = TechnologyRegistry.getInstance();
        TechId techId = technologyRegistry.getTechId(techKey);
        TechnologyScopeConfiguration technologyScopeConfiguration = TechnologyScopeConfiguration.getInstance((PropertyStorage)project);
        TechnologyScope technologyScope = technologyScopeConfiguration.getTechnologyScope();
        return technologyScope.contains(techId);
    }

    public static Project findFirstUIProjectInWorkspace(Workspace oWorkspace) {
        ArrayList<Project> oUIProjectsColl = McTechnologyUtils.getTechnologyProjects(oWorkspace, "ADFMobile");
        if (oUIProjectsColl.size() > 0) {
            return (Project)oUIProjectsColl.toArray()[0];
        }
        return Ide.getDefaultProject();
    }
}

